/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl.filesystem.ui.text;

import com.aptana.ide.search.epl.FileSearchQuery;
import com.aptana.ide.search.epl.FileSystemSearchResult;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemSearchPage;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;

public class FileTreeContentProvider
implements ITreeContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private FileSystemSearchResult fResult;
    private FileSystemSearchPage fPage;
    private AbstractTreeViewer fTreeViewer;
    private Map fChildrenMap;

    FileTreeContentProvider(FileSystemSearchPage page, AbstractTreeViewer viewer) {
        this.fPage = page;
        this.fTreeViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        Object[] children = this.getChildren(inputElement);
        int elementLimit = this.getElementLimit();
        if (elementLimit != -1 && elementLimit < children.length) {
            Object[] limitedChildren = new Object[elementLimit];
            System.arraycopy(children, 0, limitedChildren, 0, elementLimit);
            return limitedChildren;
        }
        return children;
    }

    private int getElementLimit() {
        Integer elementLimit = this.fPage.getElementLimit1();
        if (elementLimit != null) {
            return elementLimit;
        }
        return -1;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof FileSystemSearchResult) {
            this.initialize((FileSystemSearchResult)((Object)newInput));
        }
    }

    private synchronized void initialize(FileSystemSearchResult result) {
        this.fResult = result;
        this.fChildrenMap = new HashMap();
        if (result != null) {
            Object[] elements = result.getElements();
            int i = 0;
            while (i < elements.length) {
                this.insert(elements[i], false);
                ++i;
            }
        }
    }

    private void insert(Object child, boolean refreshViewer) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (refreshViewer) {
                    this.fTreeViewer.add(parent, child);
                }
            } else {
                if (refreshViewer) {
                    this.fTreeViewer.refresh(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild((Object)this.fResult, child) && refreshViewer) {
            this.fTreeViewer.add((Object)this.fResult, child);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        HashSet<Object> children = (HashSet<Object>)this.fChildrenMap.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.fChildrenMap.put(parent, children);
        }
        return children.add(child);
    }

    private void remove(Object element, boolean refreshViewer) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                this.fTreeViewer.refresh(element);
            }
        } else if (!this.hasMatches(element)) {
            this.fChildrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, (Object)this.fResult);
                if (refreshViewer) {
                    this.fTreeViewer.refresh();
                }
            }
        } else if (refreshViewer) {
            this.fTreeViewer.refresh(element);
        }
    }

    private boolean hasMatches(Object element) {
        return this.fResult.getMatchCount(element) > 0;
    }

    private void removeFromSiblings(Object element, Object parent) {
        Set siblings = (Set)this.fChildrenMap.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    public Object[] getChildren(Object parentElement) {
        Set children = (Set)this.fChildrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        return children.toArray();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public synchronized void elementsChanged(Object[] updatedElements) {
        int i = 0;
        while (i < updatedElements.length) {
            if (this.fResult.getMatchCount(updatedElements[i]) > 0) {
                this.insert(updatedElements[i], true);
            } else {
                this.remove(updatedElements[i], true);
            }
            ++i;
        }
    }

    public void clear() {
        this.initialize(this.fResult);
        this.fTreeViewer.refresh();
    }

    public Object getParent(Object element) {
        if (element instanceof File) {
            File file = (File)element;
            if (file.getAbsolutePath().equals(((FileSearchQuery)this.fResult.getQuery()).getDirectory())) {
                return null;
            }
            return file.getParentFile();
        }
        return null;
    }
}

