/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextSearchVisitor
extends org.eclipse.search.internal.core.text.TextSearchVisitor {
    private final MultiStatus fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
    private final boolean openEditorsOnly;
    private final boolean refresh;

    public TextSearchVisitor(TextSearchRequestor collector, Pattern searchPattern, boolean openEditorsOnly, boolean refresh) {
        super(collector, searchPattern);
        this.openEditorsOnly = openEditorsOnly;
        this.refresh = refresh;
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        IFile[] files = null;
        if (this.openEditorsOnly) {
            ArrayList<IFile> filesList = new ArrayList<IFile>();
            IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
            IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchPage[] pages = windows[i].getPages();
                int x = 0;
                while (x < pages.length) {
                    IEditorReference[] editorRefs = pages[x].getEditorReferences();
                    int z = 0;
                    while (z < editorRefs.length) {
                        IEditorInput editorInput;
                        IEditorPart ep = editorRefs[z].getEditor(false);
                        if (ep instanceof ITextEditor && (editorInput = ep.getEditorInput()) instanceof IFileEditorInput) {
                            IFileEditorInput ed = (IFileEditorInput)editorInput;
                            filesList.add(ed.getFile());
                        }
                        ++z;
                    }
                    ++x;
                }
                ++i;
            }
            files = new IFile[filesList.size()];
            filesList.toArray(files);
        } else {
            files = new FilesOfScopeCalculator(scope, this.fStatus).process();
        }
        return this.search(files, monitor);
    }

    private class FilesOfScopeCalculator
    extends org.eclipse.search.internal.core.text.FilesOfScopeCalculator {
        private final TextSearchScope fScope;
        private final MultiStatus fStatus;

        public FilesOfScopeCalculator(TextSearchScope scope, MultiStatus status) {
            super(scope, status);
            this.fScope = scope;
            this.fStatus = status;
        }

        public IFile[] process() {
            IResource[] roots;
            IFile[] files = super.process();
            IResource[] iResourceArray = roots = this.fScope.getRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                try {
                    if (TextSearchVisitor.this.refresh) {
                        resource.refreshLocal(2, null);
                    }
                }
                catch (CoreException ex) {
                    this.fStatus.add(ex.getStatus());
                }
                ++n2;
            }
            return files;
        }
    }
}

