/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.install.PlatformValidatorPatcher;
import com.aptana.ide.core.ui.preferences.Messages;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ExportPreferencesPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Button checkBox;
    private StringButtonFieldEditor stringButtonFieldEditor;
    private Text lastRestore;

    public ExportPreferencesPreferencePage() {
        super(1);
        this.setPreferenceStore(CoreUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.ExportPreferencesPreferencePage_BACKUP_DESCRIPTION);
    }

    private void updatePreferences() {
        String name = CoreUIPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.core.ui.AUTO_BACKUP_LASTRESTORE");
        long time = CoreUIPlugin.getDefault().getPreferenceStore().getLong("com.aptana.ide.core.ui.AUTO_BACKUP_LASTRESTORETIME");
        if (name.length() > 0) {
            Date date = new Date(time);
            String format = StringUtils.format((String)Messages.ExportPreferencesPreferencePage_LAST_RESTORE, (Object[])new Object[]{name, DateFormat.getDateTimeInstance().format(date)});
            this.lastRestore.setText(format);
        } else {
            this.lastRestore.setText(Messages.ExportPreferencesPreferencePage_NO_RESTORE);
        }
    }

    public void createFieldEditors() {
        final Composite c = this.getFieldEditorParent();
        BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor("com.aptana.ide.core.ui.AUTO_BACKUP_ENABLED", Messages.ExportPreferencesPreferencePage_BACKUP_TITLE, c);
        this.checkBox = (Button)c.getChildren()[0];
        this.addField((FieldEditor)booleanFieldEditor);
        this.stringButtonFieldEditor = new StringButtonFieldEditor("com.aptana.ide.core.ui.AUTO_BACKUP_PATH", Messages.ExportPreferencesPreferencePage_PATH, c){

            protected String changePressed() {
                DirectoryDialog dlg = new DirectoryDialog(this.getShell(), 8192);
                dlg.setFilterPath(ExportPreferencesPreferencePage.this.stringButtonFieldEditor.getStringValue());
                dlg.setText(Messages.ExportPreferencesPreferencePage_CHOOSE_CONTAINER);
                String open = dlg.open();
                return open;
            }
        };
        this.stringButtonFieldEditor.getTextControl(c).setEditable(false);
        this.addField((FieldEditor)this.stringButtonFieldEditor);
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = 150;
        this.stringButtonFieldEditor.getTextControl(c).setLayoutData((Object)data);
        String string = CoreUIPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.core.ui.AUTO_BACKUP_LASTNAME");
        String lastBackup = StringUtils.format((String)Messages.ExportPreferencesPreferencePage_LAST_BACKUP, (String)string);
        if (string.length() == 0) {
            lastBackup = Messages.ExportPreferencesPreferencePage_NONE;
        }
        Label lastBacked = new Label(c, 0);
        lastBacked.setText(Messages.ExportPreferencesPreferencePage_LASTBACKED);
        Text lastBackedLabel = new Text(c, 2060);
        lastBackedLabel.setEditable(false);
        lastBackedLabel.setText(lastBackup);
        data = new GridData(4, 4, true, false, 2, 1);
        data.widthHint = 150;
        lastBackedLabel.setLayoutData((Object)data);
        Label cm = new Label(c, 0);
        cm.setText(Messages.ExportPreferencesPreferencePage_LAST);
        this.lastRestore = new Text(c, 2060);
        this.lastRestore.setEditable(false);
        data = new GridData(4, 4, true, false);
        data.widthHint = 150;
        this.lastRestore.setLayoutData((Object)data);
        this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportPreferencesPreferencePage.this.stringButtonFieldEditor.setEnabled(ExportPreferencesPreferencePage.this.checkBox.getSelection(), c);
            }
        });
        Button restore = new Button(c, 8);
        restore.setText(Messages.ExportPreferencesPreferencePage_RESTORE_TITLE);
        restore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(ExportPreferencesPreferencePage.this.getShell(), 4096);
                dlg.setFilterPath(ExportPreferencesPreferencePage.this.stringButtonFieldEditor.getStringValue());
                dlg.setFilterExtensions(new String[]{"*.epr"});
                dlg.setText(Messages.ExportPreferencesPreferencePage_RESTORE_TEXT);
                String open = dlg.open();
                if (open != null) {
                    long l = System.currentTimeMillis();
                    File file = new File(open);
                    boolean importPreferences = PlatformValidatorPatcher.importPreferences(file);
                    if (importPreferences) {
                        CoreUIPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.core.ui.AUTO_BACKUP_LASTRESTORE", file.getName());
                        CoreUIPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.core.ui.AUTO_BACKUP_LASTRESTORETIME", l);
                        ExportPreferencesPreferencePage.this.updatePreferences();
                    }
                }
            }
        });
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.stringButtonFieldEditor.setEnabled(this.checkBox.getSelection(), this.getFieldEditorParent());
        this.updatePreferences();
    }
}

