/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.actions;

import com.aptana.ide.core.ui.actions.AbstractWorkbenchWindowPulldownDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowViewAction
extends AbstractWorkbenchWindowPulldownDelegate {
    private Menu toolbarMenu = null;
    private IWorkbenchWindow window;
    private Map<IWorkbenchPage, List<String>> openedViews = new HashMap<IWorkbenchPage, List<String>>();

    @Override
    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public Menu getMenu(Control parent) {
        if (this.toolbarMenu != null) {
            this.toolbarMenu.dispose();
        }
        this.toolbarMenu = new Menu(parent);
        this.buildMenu(this.toolbarMenu);
        return this.toolbarMenu;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        this.buildMenu(menu);
        return menu;
    }

    private void buildMenu(Menu menu) {
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return;
        }
        if (page.getPerspective() == null) {
            return;
        }
        List<String> viewIds = Arrays.asList(page.getShowViewShortcuts());
        viewIds = this.addOpenedViews(page, viewIds);
        viewIds.remove("org.eclipse.ui.internal.introview");
        final IViewRegistry viewsRegistry = PlatformUI.getWorkbench().getViewRegistry();
        ArrayList<IViewDescriptor> viewDescriptorsList = new ArrayList<IViewDescriptor>();
        IViewDescriptor[] viewDescriptors = viewsRegistry.getViews();
        int i = 0;
        while (i < viewDescriptors.length) {
            if (viewIds.contains(viewDescriptors[i].getId())) {
                viewDescriptorsList.add(viewDescriptors[i]);
            }
            ++i;
        }
        viewDescriptors = viewDescriptorsList.toArray(new IViewDescriptor[viewDescriptorsList.size()]);
        Arrays.sort(viewDescriptors, new Comparator<IViewDescriptor>(){

            @Override
            public int compare(IViewDescriptor vd1, IViewDescriptor vd2) {
                return vd1.getLabel().compareTo(vd2.getLabel());
            }
        });
        SelectionAdapter selAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IViewDescriptor viewId = viewsRegistry.find((String)e.widget.getData());
                    if (viewId != null) {
                        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IViewPart view = activePage.showView(viewId.getId(), null, 3);
                        activePage.activate((IWorkbenchPart)view);
                    }
                }
                catch (PartInitException partInitException) {}
            }
        };
        IViewDescriptor[] iViewDescriptorArray = viewDescriptors;
        int n = viewDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IViewDescriptor viewDescriptor = iViewDescriptorArray[n2];
            String viewId = viewDescriptor.getId();
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setText(viewDescriptor.getLabel());
            menuItem.setImage(viewDescriptor.getImageDescriptor().createImage());
            menuItem.setData((Object)viewId);
            menuItem.addSelectionListener((SelectionListener)selAdapter);
            ++n2;
        }
    }

    private List<String> addOpenedViews(IWorkbenchPage page, List<String> actions) {
        String element;
        List<String> views = this.getParts(page);
        ArrayList<String> result = new ArrayList<String>(views.size() + actions.size());
        int i = 0;
        while (i < actions.size()) {
            element = actions.get(i);
            if (result.indexOf(element) < 0) {
                result.add(element);
            }
            ++i;
        }
        i = 0;
        while (i < views.size()) {
            element = views.get(i);
            if (result.indexOf(element) < 0) {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    private List<String> getParts(IWorkbenchPage page) {
        List<String> parts = this.openedViews.get(page);
        if (parts == null) {
            parts = new ArrayList<String>();
            this.openedViews.put(page, parts);
        }
        return parts;
    }
}

