/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.update.internal.ui.UpdateUI;

public class InitialRestartStartup {
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String PROP_EXIT_DATA = "eclipse.exitdata";
    private static final String CMD_VMARGS = "-vmargs";
    private static final String NEW_LINE = "\n";

    public static void start() {
        try {
            IPreferenceStore preferences = CoreUIPlugin.getDefault().getPreferenceStore();
            IdeLog.logInfo((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.InitialRestartStartup_INF_CleanPreference, (Object)preferences.getBoolean("com.aptana.ide.core.PREF_CLEAN_RESTART")));
            if (preferences.getBoolean("com.aptana.ide.core.PREF_CLEAN_RESTART")) {
                preferences.setValue("com.aptana.ide.core.PREF_CLEAN_RESTART", false);
                System.setProperty(PROP_EXIT_CODE, Integer.toString(24));
                String commandLine = InitialRestartStartup.buildCommandLine("-clean");
                if (commandLine != null) {
                    IdeLog.logInfo((Plugin)CoreUIPlugin.getDefault(), (String)(String.valueOf(Messages.InitialRestartStartup_INF_NewCommandLine) + commandLine));
                    System.setProperty(PROP_EXIT_DATA, commandLine);
                    InitialRestartStartup.restartIDE();
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.InitialRestartStartup_ERR_UnableToCleanConfiguration, (Throwable)e);
        }
        IdeLog.flushCache();
    }

    private static void restartIDE() {
        UIJob job = new UIJob(Messages.InitialRestartStartup_MSG_RestartingIDE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Job[] jobs = Job.getJobManager().find((Object)"earlyStartup");
                if (jobs.length > 0) {
                    Job[] jobArray = jobs;
                    int n = jobs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Job job = jobArray[n2];
                        if (job.getState() != 0) {
                            this.schedule(100L);
                            return Status.OK_STATUS;
                        }
                        ++n2;
                    }
                }
                UpdateUI.requestRestart((boolean)true);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.schedule();
    }

    private static String buildCommandLine(String commands) {
        String property = System.getProperty(PROP_VM);
        if (property == null) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.InitialRestartStartup_ERR_VMArgumentsNullForRestartOfIDE);
            return null;
        }
        StringBuffer result = new StringBuffer(512);
        result.append(property);
        result.append(NEW_LINE);
        String vmargs = System.getProperty(PROP_VMARGS);
        if (vmargs != null) {
            result.append(vmargs);
        }
        if ((property = System.getProperty(PROP_COMMANDS)) == null) {
            result.append(commands);
            result.append(NEW_LINE);
        } else {
            result.append(commands);
            result.append(NEW_LINE);
            result.append(property);
        }
        if (vmargs != null) {
            result.append(CMD_VMARGS);
            result.append(NEW_LINE);
            result.append(vmargs);
        }
        return result.toString();
    }
}

