/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.DeleteConfigurationsDialog;
import com.aptana.ide.core.ui.IResourceChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.progress.UIJob;

public class ConfigExtensionLoader {
    private static Map<String, List<IResourceChangeListener>> naturesToListenerLists = null;
    private static Map<IProject, String[]> projectsToNatureArrays = new HashMap<IProject, String[]>();
    private static List<IResourceChangeListener> globalListeners = null;

    public static void init() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new org.eclipse.core.resources.IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                ConfigExtensionLoader.notifyListeners(event);
            }
        });
    }

    private ConfigExtensionLoader() {
    }

    private static void notifyListeners(IResourceChangeEvent event) {
        IResourceDelta delta;
        if (naturesToListenerLists == null) {
            ConfigExtensionLoader.loadConfigurationExtensionPoints();
        }
        if ((delta = event.getDelta()) == null) {
            if (event.getType() == 4 && event.getResource() instanceof IProject) {
                IProject project = (IProject)event.getResource();
                try {
                    String[] natures = project.getDescription().getNatureIds();
                    projectsToNatureArrays.put(project, natures);
                }
                catch (CoreException coreException) {}
            }
        } else {
            IResourceDelta[] deltas;
            IResourceDelta[] iResourceDeltaArray = deltas = delta.getAffectedChildren();
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta rDelta = iResourceDeltaArray[n2];
                if (rDelta.getKind() == 2 && rDelta.getMovedToPath() == null && rDelta.getResource() instanceof IProject) {
                    ConfigExtensionLoader.fireCollectDeletions((IProject)rDelta.getResource(), event);
                } else {
                    IProject project = rDelta.getResource().getProject();
                    if (project != null) {
                        ConfigExtensionLoader.fireResourceEvent(project, event);
                        projectsToNatureArrays.remove(project);
                    }
                }
                ++n2;
            }
        }
    }

    private static void fireCollectDeletions(IProject project, IResourceChangeEvent event) {
        String[] natures;
        block7: {
            natures = new String[]{};
            try {
                natures = project.getDescription().getNatureIds();
            }
            catch (CoreException coreException) {
                if (!projectsToNatureArrays.containsKey(project)) break block7;
                natures = projectsToNatureArrays.remove(project);
            }
        }
        final ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (naturesToListenerLists.containsKey(nature)) {
                List<IResourceChangeListener> natureListeners = naturesToListenerLists.get(nature);
                for (IResourceChangeListener listener : natureListeners) {
                    configurations.addAll(Arrays.asList(listener.getDeleteCandidates(project, event)));
                }
            }
            for (IResourceChangeListener listener : globalListeners) {
                configurations.addAll(Arrays.asList(listener.getDeleteCandidates(project, event)));
            }
            ++n2;
        }
        if (configurations.size() > 0) {
            UIJob job = new UIJob("Open delete candidates"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DeleteConfigurationsDialog dialog = new DeleteConfigurationsDialog(CoreUIUtils.getActiveShell(), configurations);
                    dialog.open();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private static void fireResourceEvent(IProject project, IResourceChangeEvent event) {
        try {
            String[] natures = project.getDescription().getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if (naturesToListenerLists.containsKey(natures[i])) {
                    List<IResourceChangeListener> natureListeners = naturesToListenerLists.get(natures[i]);
                    int j = 0;
                    while (j < natureListeners.size()) {
                        natureListeners.get(j).resourceChanged(event);
                        ++j;
                    }
                }
                int j = 0;
                while (j < globalListeners.size()) {
                    globalListeners.get(j).resourceChanged(event);
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    private static void loadConfigurationExtensionPoints() {
        IExtension[] extensions;
        naturesToListenerLists = new HashMap<String, List<IResourceChangeListener>>();
        globalListeners = new ArrayList<IResourceChangeListener>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint(String.valueOf(CoreUIPlugin.ID) + ".configuration");
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] ce = extension.getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                String nature = ce[j].getAttribute("nature");
                String listenerClass = ce[j].getAttribute("handler");
                if (listenerClass != null) {
                    try {
                        Object listener = ce[j].createExecutableExtension("handler");
                        if (listener instanceof IResourceChangeListener) {
                            if (nature != null) {
                                List<Object> natureListenerList = null;
                                if (naturesToListenerLists.containsKey(nature)) {
                                    natureListenerList = naturesToListenerLists.get(nature);
                                } else {
                                    natureListenerList = new ArrayList();
                                    naturesToListenerLists.put(nature, natureListenerList);
                                }
                                natureListenerList.add((IResourceChangeListener)listener);
                            } else {
                                globalListeners.add((IResourceChangeListener)listener);
                            }
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++j;
            }
            ++n2;
        }
    }
}

