/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.impl;

import com.aptana.ide.logging.ILogResource;
import com.aptana.ide.logging.ILogWatcher;
import com.aptana.ide.logging.impl.LocalLineBasedLogWatcher;
import com.aptana.ide.logging.impl.LocalLogResource;
import com.aptana.ide.logging.impl.LogWatcherConfiguration;
import com.aptana.ide.logging.impl.SFTPLineBasedLogWatcher;
import com.aptana.ide.logging.impl.WebLineBasedLogWatcher;
import com.aptana.ide.logging.impl.WebLogResource;
import java.net.MalformedURLException;

public class LogWatcherFactory {
    public static ILogWatcher createWatcher(ILogResource resource, LogWatcherConfiguration config) {
        if (resource instanceof LocalLogResource) {
            return new LocalLineBasedLogWatcher((LocalLogResource)resource, config);
        }
        if (resource instanceof WebLogResource) {
            try {
                String protocol = resource.getURI().toURL().getProtocol();
                if (protocol.equals("sftp")) {
                    return new SFTPLineBasedLogWatcher((WebLogResource)resource, config);
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            return new WebLineBasedLogWatcher((WebLogResource)resource, config);
        }
        return null;
    }

    private LogWatcherFactory() {
    }
}

