/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.impl;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.logging.LoggingPlugin;
import com.aptana.ide.logging.impl.AbstractLogResource;
import com.aptana.ide.logging.impl.AbstractLogWatcher;
import com.aptana.ide.logging.impl.LocalLogResource;
import com.aptana.ide.logging.impl.LogWatcherConfiguration;
import com.aptana.ide.logging.impl.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;

public class LocalLogWatcher
extends AbstractLogWatcher {
    private static final int INCREASE_K = 2;
    private final int MEAN_CHARS_PER_STRING = 80;
    private final int MAX_BUFFER = 0x100000;
    private final int LINEAR_BORDER = 65536;
    private final int estimatedBufferSize;
    private char[] buffer;
    private long lastFileLength;
    private boolean wholeFileRead = false;

    public LocalLogWatcher(AbstractLogResource resource, LogWatcherConfiguration config) {
        super(config, resource);
        this.estimatedBufferSize = this.estimateSize(config.getBacklogRows(), config.getEncoding());
        this.buffer = new char[this.estimatedBufferSize];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AbstractLogWatcher.DataChange getData() {
        RandomAccessFile raFile = null;
        try {
            raFile = new RandomAccessFile(this.getLocalResource().getFile(), "r");
            boolean wholeView = false;
            if (raFile.length() == this.lastFileLength) {
                return null;
            }
            this.lastFileLength = raFile.length();
            int bufLength = this.readBuffer(raFile);
            if (this.wholeFileRead) {
                AbstractLogWatcher.DataChange dataChange = this.buildChange(bufLength, 0, wholeView);
                return dataChange;
            }
            do {
                int upperLineOffset;
                if ((upperLineOffset = this.checkLinesNumber(bufLength)) != -1) {
                    AbstractLogWatcher.DataChange dataChange = this.buildChange(bufLength, upperLineOffset, wholeView);
                    return dataChange;
                }
                if (!this.increaseBuffer()) {
                    AbstractLogWatcher.DataChange dataChange = this.buildChange(bufLength, 0, wholeView);
                    return dataChange;
                }
                bufLength = this.readBuffer(raFile);
            } while (!this.wholeFileRead);
            AbstractLogWatcher.DataChange dataChange = this.buildChange(bufLength, 0, wholeView);
            return dataChange;
        }
        catch (IOException iOException) {
            this.notifyListenersResourceAvailable(false);
            return null;
        }
        finally {
            try {
                if (raFile != null) {
                    raFile.close();
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)Messages.LocalLogWatcher_ERR_Exception, (Throwable)e);
            }
        }
    }

    private AbstractLogWatcher.DataChange buildChange(int bufLength, int upperLineOffset, boolean wholeView) {
        int dataLength = bufLength - upperLineOffset;
        String data = new String(this.buffer, upperLineOffset, dataLength);
        AbstractLogWatcher.DataChange change = null;
        change = wholeView ? new AbstractLogWatcher.DataChange(data, (int)(this.lastFileLength - (long)dataLength), Integer.MAX_VALUE) : new AbstractLogWatcher.DataChange(data, (int)(this.lastFileLength - (long)dataLength), dataLength);
        return change;
    }

    private boolean increaseBuffer() {
        int currentSize = this.buffer.length;
        currentSize = currentSize < 65536 ? (currentSize *= 2) : (currentSize += 65536);
        if (currentSize >= 0x100000) {
            return false;
        }
        try {
            char[] newBuffer = new char[currentSize];
            this.buffer = newBuffer;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
        return true;
    }

    private int checkLinesNumber(int length) {
        int okNumberOfLines = this.getConfiguration().getBacklogRows();
        int linesNumber = 0;
        ArrayList<Integer> linesInfo = new ArrayList<Integer>();
        int i = 0;
        while (i < length) {
            char ch = this.buffer[i];
            switch (ch) {
                case '\r': {
                    char nextChar;
                    if (i < length - 1 && (nextChar = this.buffer[i + 1]) == '\n') {
                        ++i;
                    }
                    linesInfo.add(i);
                    ++linesNumber;
                    break;
                }
                case '\n': {
                    linesInfo.add(i);
                    ++linesNumber;
                    break;
                }
            }
            ++i;
        }
        if (linesNumber > okNumberOfLines) {
            int diff = linesNumber - okNumberOfLines;
            return (Integer)linesInfo.get(diff) + 1;
        }
        if (linesNumber == okNumberOfLines) {
            return 0;
        }
        return -1;
    }

    private int readBuffer(RandomAccessFile raFile) throws IOException {
        long startPos = this.lastFileLength - (long)this.buffer.length;
        if (startPos < 0L) {
            startPos = 0L;
            this.wholeFileRead = true;
        } else {
            this.wholeFileRead = false;
        }
        RandomAccessReader reader = new RandomAccessReader(raFile, startPos, this.getResource().getEncoding());
        int read = 0;
        int bufPos = 0;
        while (read != -1 && bufPos != this.buffer.length) {
            read = ((Reader)reader).read(this.buffer, bufPos += read, this.buffer.length - bufPos);
        }
        return bufPos;
    }

    public void resetWatching() {
        this.stopWatching();
        this.lastFileLength = 0L;
        this.wholeFileRead = false;
    }

    protected LocalLogResource getLocalResource() {
        return (LocalLogResource)this.getResource();
    }

    private int estimateSize(int backlogRows, Charset encoding) {
        float averageCharsPerByte = encoding.newDecoder().averageCharsPerByte();
        if (averageCharsPerByte == 0.0f) {
            return 0;
        }
        return (int)((float)backlogRows * 80.0f * (1.0f / averageCharsPerByte));
    }

    private class RandomAccessReader
    extends Reader {
        private Reader reader;

        public RandomAccessReader(final RandomAccessFile file, long startPos, Charset encoding) throws IOException {
            InputStream stream = new InputStream(){

                public int read() throws IOException {
                    throw new UnsupportedOperationException();
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    return file.read(b, off, len);
                }

                public int read(byte[] b) throws IOException {
                    return file.read(b);
                }
            };
            file.seek(startPos);
            this.reader = new InputStreamReader(stream, encoding);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.reader.read(cbuf, off, len);
        }
    }
}

