/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.impl;

import com.aptana.ide.logging.impl.LineBasedLogWatcher;
import com.aptana.ide.logging.impl.LocalLogResource;
import com.aptana.ide.logging.impl.LogWatcherConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class LocalLineBasedLogWatcher
extends LineBasedLogWatcher {
    private RandomAccessFile file;

    public LocalLineBasedLogWatcher(LocalLogResource resource, LogWatcherConfiguration config) {
        super(config, resource);
        try {
            this.file = new RandomAccessFile(resource.getFile(), "r");
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    protected long getCurrentLogLength() {
        if (this.file == null) {
            return 0L;
        }
        try {
            return this.file.length();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    protected void readData(int startPos, ByteBuffer buffer, int maxBytesToRead) {
        if (this.file == null) {
            return;
        }
        try {
            this.file.seek(startPos);
            int gotBytes = this.file.read(buffer.array(), 0, maxBytesToRead);
            if (gotBytes > 0) {
                buffer.limit(gotBytes);
            }
        }
        catch (IOException iOException) {}
    }
}

