/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.impl;

import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import com.aptana.xml.INode;
import java.util.HashMap;

public class InLineMatcher
extends AbstractTextMatcher {
    private MatcherMap _firstCharacters;
    private HashMap<ITextMatcher, Integer> indexes = null;

    public void addChildTypes() {
        this.addChildType(ITextMatcher.class);
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        MatcherMap localMap = null;
        if (this._firstCharacters == null) {
            localMap = new MatcherMap();
        }
        int childCount = this.getChildCount();
        int i = 0;
        while (i < childCount) {
            INode child = this.getChild(i);
            if (child instanceof ITextMatcher) {
                ITextMatcher matcher = (ITextMatcher)child;
                matcher.addFirstCharacters(map, target);
                if (localMap != null) {
                    matcher.addFirstCharacters(localMap);
                }
            }
            ++i;
        }
        if (localMap != null) {
            this._firstCharacters = localMap;
            this._firstCharacters.setSealed();
        }
    }

    public boolean buildFirstCharacterMap() {
        this.indexes = new HashMap(this.getChildCount(), 0.5f);
        int matcherIndex = 0;
        MatcherMap map = new MatcherMap();
        int i = 0;
        while (i < this.getChildCount()) {
            INode child = this.getChild(i);
            if (child instanceof ITextMatcher) {
                ITextMatcher matcher = (ITextMatcher)child;
                matcher.addFirstCharacters(map);
                this.indexes.put(matcher, matcherIndex);
                ++matcherIndex;
            }
            ++i;
        }
        this._firstCharacters = map;
        this._firstCharacters.setSealed();
        return !this._firstCharacters.hasUncategorizedMatchers();
    }

    public boolean canMatchNothing() {
        boolean result = false;
        int childCount = this.getChildCount();
        int i = 0;
        while (i < childCount) {
            ITextMatcher matcher;
            INode child = this.getChild(i);
            if (child instanceof ITextMatcher && (matcher = (ITextMatcher)child).canMatchNothing()) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public int match(char[] source, int offset, int eofset) {
        ITextMatcher[] matchers = null;
        if (this._firstCharacters == null) {
            matchers = new ITextMatcher[this.indexes.size()];
            this.indexes.keySet().toArray(matchers);
        }
        ITextMatcher winningMatcher = null;
        if (this.indexes == null) {
            this.buildFirstCharacterMap();
        }
        int topMostMatchedIndex = this.indexes.size();
        int currentOffset = offset;
        while (currentOffset < eofset) {
            char c = source[currentOffset];
            if (c == '\r') {
                if (currentOffset < eofset - 1 && source[currentOffset + 1] == '\n') {
                    ++currentOffset;
                }
                ++currentOffset;
                break;
            }
            if (c == '\n') break;
            if (this._firstCharacters != null) {
                matchers = offset < eofset ? this._firstCharacters.getMatchers(c) : this._firstCharacters.getUncategorizedMatchers();
            }
            int i = 0;
            while (i < matchers.length) {
                int result;
                ITextMatcher currentMatcher = matchers[i];
                int matcherIndex = this.indexes.get(currentMatcher);
                if (matcherIndex < topMostMatchedIndex && (result = currentMatcher.match(source, currentOffset, eofset)) != -1) {
                    topMostMatchedIndex = matcherIndex;
                    winningMatcher = currentMatcher;
                }
                ++i;
            }
            ++currentOffset;
        }
        if (winningMatcher != null) {
            this.accept(source, offset, currentOffset, winningMatcher.getMatchedToken());
            return currentOffset;
        }
        return -1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int childCount = this.getChildCount();
        if (childCount > 0) {
            buffer.append("(");
            buffer.append(this.getChild(0));
            int i = 1;
            while (i < childCount) {
                buffer.append(" | ");
                buffer.append(this.getChild(i));
                ++i;
            }
            buffer.append(")");
        }
        return buffer.toString();
    }
}

