/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.coloring;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.logging.LoggingPlugin;
import com.aptana.ide.logging.LoggingPreferences;
import com.aptana.ide.logging.coloring.Messages;
import com.aptana.ide.logging.coloring.TokenTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingLexemeManager {
    private Map<Integer, List<Lexeme>> lexemes;
    private final IDocument document;
    private final int regexpMaxLines;
    private List<String> topLines = new ArrayList<String>();

    public LoggingLexemeManager(IDocument document, LoggingPreferences preferences) {
        this.lexemes = new HashMap<Integer, List<Lexeme>>();
        this.regexpMaxLines = preferences.getRegexpMaxLines();
        this.document = document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lexeme[] getLexemes(int lineNumber) {
        List<Lexeme> cached = this.lexemes.get(lineNumber);
        if (cached == null) {
            Map<Integer, List<Lexeme>> map = this.lexemes;
            synchronized (map) {
                try {
                    this.prefetch(lineNumber);
                }
                catch (BadLocationException e) {
                    IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)Messages.LoggingLexemeManager_ERR_Exception, (Throwable)e);
                    return new Lexeme[0];
                }
                cached = this.lexemes.get(lineNumber);
                if (cached == null) {
                    return new Lexeme[0];
                }
            }
        }
        Lexeme[] result = new Lexeme[cached.size()];
        cached.toArray(result);
        return result;
    }

    private void prefetch(int lineNumber) throws BadLocationException {
        Lexeme lexeme;
        int lineToStart = lineNumber - this.regexpMaxLines + 1;
        if (lineToStart < -this.topLines.size()) {
            lineToStart = 0;
        }
        int i = lineToStart;
        while (i <= lineNumber) {
            List<Lexeme> lineLexemes = this.lexemes.get(i);
            if (lineLexemes == null) {
                lineToStart = i;
                break;
            }
            ++i;
        }
        String toParse = this.buildContentToParse(lineToStart, lineNumber);
        this.clearLines(lineToStart, lineNumber);
        try {
            this.getLexer().setLanguage("text/log");
        }
        catch (LexerException e1) {
            IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)Messages.LoggingLexemeManager_ERR_Exception, (Throwable)e1);
        }
        this.getLexer().setSource(toParse);
        while ((lexeme = this.getLexer().getNextLexeme()) != null) {
            this.addLexeme(lexeme, lineToStart);
        }
    }

    private ILexer getLexer() {
        return TokenTypes.getLexerFactory().getLexer();
    }

    private void clearLines(int startLine, int endLine) {
        int i = startLine;
        while (i <= endLine) {
            this.lexemes.put(i, null);
            ++i;
        }
    }

    private String buildContentToParse(int firstLine, int lastLine) throws BadLocationException {
        int startLine = firstLine;
        StringBuilder builder = new StringBuilder();
        if (startLine < 0) {
            int i = startLine;
            while (i <= 0) {
                builder.append(this.topLines.get(i + this.topLines.size()));
                ++i;
            }
            startLine = 0;
        }
        int lineNumber = startLine;
        while (lineNumber <= lastLine) {
            int lineOffset = this.document.getLineOffset(lineNumber);
            int lineLength = this.document.getLineLength(lineNumber);
            builder.append(this.document.get(lineOffset, lineLength));
            ++lineNumber;
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataAvailable(List<String> topLines) {
        Map<Integer, List<Lexeme>> map = this.lexemes;
        synchronized (map) {
            this.lexemes.clear();
            this.fillTopLines(topLines);
        }
    }

    public void clearCache() {
        this.lexemes.clear();
    }

    private void fillTopLines(List<String> topLines) {
        this.topLines.clear();
        this.topLines.addAll(topLines);
    }

    private void addLexeme(Lexeme lexeme, int baseLine) throws BadLocationException {
        int effectiveLineOffset = 0;
        effectiveLineOffset = baseLine < 0 ? this.getTopLineStartOffset(baseLine) : this.document.getLineOffset(baseLine);
        lexeme.adjustOffset(effectiveLineOffset);
        int lexemeStartLine = this.getLineByOffset(lexeme.getStartingOffset());
        List<Lexeme> lst = this.getModifiableLineLexemes(lexemeStartLine);
        lst.add(lexeme);
        int lexemeEndLine = this.getLineByOffset(lexeme.getEndingOffset());
        if (lexemeEndLine != lexemeStartLine) {
            if (lexemeEndLine == lexemeStartLine + 1 && this.lexemeEndsWithNewLine(lexeme.getText())) {
                return;
            }
            lst = this.getModifiableLineLexemes(lexemeEndLine);
            lst.add(lexeme);
        }
    }

    private boolean lexemeEndsWithNewLine(String text) {
        return text.endsWith("\r") || text.endsWith("\n") || text.endsWith("\r\n");
    }

    private int getTopLineStartOffset(int line) {
        int result = 0;
        int i = line;
        while (i < 0) {
            result += this.topLines.get(i).length();
            ++i;
        }
        return result;
    }

    private int getLineByOffset(int offset) throws BadLocationException {
        return this.document.getLineOfOffset(offset);
    }

    private List<Lexeme> getModifiableLineLexemes(int lineNumber) {
        List<Lexeme> toReturn = this.lexemes.get(lineNumber);
        if (toReturn == null) {
            toReturn = new ArrayList<Lexeme>(1);
            this.lexemes.put(lineNumber, toReturn);
        }
        return toReturn;
    }
}

