/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.xhr;

import com.aptana.ide.debug.core.xhr.IXHRService;
import com.aptana.ide.debug.core.xhr.IXHRTransfer;
import com.aptana.ide.debug.internal.core.xhr.XHRTransfer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;

public class XHRService
implements IXHRService {
    private Map<String, IXHRTransfer> transfers = new LinkedHashMap<String, IXHRTransfer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openRequest(String rid, String method, String url, boolean auth) {
        XHRTransfer xhr = new XHRTransfer(method, url, auth);
        Map<String, IXHRTransfer> map = this.transfers;
        synchronized (map) {
            this.transfers.put(rid, xhr);
        }
        this.fireChangeEvent(null);
    }

    public void setRequestHeaders(String rid, String[][] headers) {
        XHRTransfer xhr = (XHRTransfer)this.transfers.get(rid);
        if (xhr != null) {
            int i = 0;
            while (i < headers.length) {
                xhr.addRequestHeader(headers[i][0], headers[i][1]);
                ++i;
            }
            this.fireChangeEvent(xhr);
        }
    }

    public void setRequestBody(String rid, String body) {
        XHRTransfer xhr = (XHRTransfer)this.transfers.get(rid);
        if (xhr != null) {
            xhr.setRequestBody(body);
            this.fireChangeEvent(xhr);
        }
    }

    public void setResponseHeaders(String rid, String[][] headers) {
        XHRTransfer xhr = (XHRTransfer)this.transfers.get(rid);
        if (xhr != null) {
            int i = 0;
            while (i < headers.length) {
                xhr.addResponseHeader(headers[i][0], headers[i][1]);
                ++i;
            }
            this.fireChangeEvent(xhr);
        }
    }

    public void setResponseBody(String rid, String body) {
        XHRTransfer xhr = (XHRTransfer)this.transfers.get(rid);
        if (xhr != null) {
            xhr.setResponseBody(body);
            this.fireChangeEvent(xhr);
        }
    }

    public void setResponseStatus(String rid, int code, String text) {
        XHRTransfer xhr = (XHRTransfer)this.transfers.get(rid);
        if (xhr != null) {
            xhr.setResponseStatus(code, text);
            this.fireChangeEvent(xhr);
        }
    }

    public void setError(String rid) {
        XHRTransfer xhr = (XHRTransfer)this.transfers.get(rid);
        if (xhr != null) {
            xhr.setError(true);
            this.fireChangeEvent(xhr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXHRTransfer[] getTransfers() {
        Map<String, IXHRTransfer> map = this.transfers;
        synchronized (map) {
            return this.transfers.values().toArray(new IXHRTransfer[this.transfers.size()]);
        }
    }

    public int getTransfersCount() {
        return this.transfers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IXHRTransfer xhr) {
        Map<String, IXHRTransfer> map = this.transfers;
        synchronized (map) {
            this.transfers.remove(xhr);
        }
        this.fireChangeEvent(null);
    }

    private void fireChangeEvent(Object data) {
        DebugEvent event = new DebugEvent((Object)this, 16, 512);
        event.setData(data);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }
}

