/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.sourcelookup;

import com.aptana.ide.debug.core.model.IJSDebugTarget;
import com.aptana.ide.debug.internal.core.IFileContentRetriever;
import com.aptana.ide.debug.internal.core.sourcelookup.RemoteFileStorage;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;

public final class RemoteSourceCacheManager
implements IDebugEventSetListener {
    private static RemoteSourceCacheManager fgDefault;
    private Map<URI, RemoteFileStorage> cache = new Hashtable<URI, RemoteFileStorage>();
    private IFileContentRetriever fileContentRetriever;

    private RemoteSourceCacheManager() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public static RemoteSourceCacheManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new RemoteSourceCacheManager();
        }
        return fgDefault;
    }

    public RemoteFileStorage getStorage(URI uri) {
        return this.cache.get(uri);
    }

    public void add(URI uri, RemoteFileStorage storage) {
        this.cache.put(uri, storage);
        if (storage.getFileContentRetriever() == null) {
            storage.setFileContentRetriever(this.fileContentRetriever);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() instanceof IJSDebugTarget) {
                switch (event.getKind()) {
                    case 4: {
                        this.updateStorageContent((IDebugTarget)event.getSource(), false);
                        break;
                    }
                    case 8: {
                        this.updateStorageContent((IDebugTarget)event.getSource(), true);
                        break;
                    }
                }
            }
            ++i;
        }
    }

    private void updateStorageContent(IDebugTarget target, boolean clear) {
        this.fileContentRetriever = (IFileContentRetriever)target.getAdapter(IFileContentRetriever.class);
        if (this.fileContentRetriever != null) {
            for (RemoteFileStorage storage : this.cache.values()) {
                if (clear) {
                    if (storage.getFileContentRetriever() != this.fileContentRetriever) continue;
                    storage.setFileContentRetriever(null);
                    continue;
                }
                if (storage.getFileContentRetriever() != null) continue;
                storage.setFileContentRetriever(this.fileContentRetriever);
            }
        }
        if (clear) {
            this.fileContentRetriever = null;
        }
    }
}

