/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core;

import com.aptana.ide.core.FirefoxUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PlatformUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.internal.core.Messages;
import com.aptana.ide.debug.internal.core.browsers.Firefox;
import com.aptana.ide.debug.internal.core.browsers.InternetExplorer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStatusHandler;
import org.osgi.framework.Bundle;

public final class BrowserUtil {
    public static final String DEBUGGER_LAUNCH_URL = "http://www.aptana.com/?debugger=true&port=";
    private static final String[] EXTENSION_ID = new String[]{"debugger@aptana.com", "firebug@software.joehewitt.com"};
    private static final String[] EXTENSION_LOCAL_PATH = new String[]{"/res/firefox/aptanadebugger.xpi", "/res/firefox/firebug.xpi", "/res/ie/AptanaDebugger.dll"};
    private static final String FIREBUG_MIN_VERSION = "1.1.0";
    private static final String IE_PLUGIN_ID = "com.aptana.ide.debug.core.ie";
    private static final String EXTENSIONS = "extensions/";
    private static final String DEBUGGER_FILE = "chrome/aptanadebugger.jar";
    private static final long INSTALL_TIMEOUT = 5000L;
    private static final Map<String, Boolean> browserCache = new HashMap<String, Boolean>(4);
    private static final IStatus installDebuggerPromptStatus = new Status(1, "com.aptana.ide.debug.core", 301, "", null);

    private BrowserUtil() {
    }

    public static String getMacOSXApplicationIdentifier(String application) {
        return PlatformUtils.getApplicationInfo((String)application, (String)"CFBundleIdentifier");
    }

    public static boolean isBrowserRunning(String browserExecutable) {
        PlatformUtils.ProcessItem[] processes;
        if ("macosx".equals(Platform.getOS())) {
            browserExecutable = PlatformUtils.getApplicationExecutable((String)browserExecutable).getAbsolutePath();
        }
        if ((processes = PlatformUtils.getRunningProcesses()) != null) {
            String browserExecutable2 = browserExecutable;
            if ("linux".equals(Platform.getOS())) {
                browserExecutable2 = String.valueOf(browserExecutable2) + "-bin";
            }
            int i = 0;
            while (i < processes.length) {
                if (browserExecutable.equals(processes[i].getExecutableName()) || browserExecutable2.equals(processes[i].getExecutableName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isBrowserDebugCompatible(String browserExecutable) {
        return Firefox.isBrowserExecutable(browserExecutable) || InternetExplorer.isBrowserExecutable(browserExecutable) && BrowserUtil.isIEDebuggerAvailable();
    }

    private static boolean isIEDebuggerAvailable() {
        Bundle bundle = Platform.getBundle((String)IE_PLUGIN_ID);
        if (bundle != null) {
            return bundle.getEntry(EXTENSION_LOCAL_PATH[2]) != null;
        }
        return false;
    }

    public static void resetBrowserCache(String browserExecutable) {
        IPath dllPath;
        browserCache.remove(browserExecutable);
        if (InternetExplorer.isBrowserExecutable(browserExecutable) && (dllPath = JSDebugPlugin.getDefault().getStateLocation().append(".dll").addTrailingSeparator().append("AptanaDebugger.dll")).toFile().exists()) {
            dllPath.addFileExtension("registered").toFile().delete();
        }
    }

    public static boolean isBrowserDebugAvailable(String browserExecutable) {
        Boolean value = browserCache.get(browserExecutable);
        if (value != null) {
            return value;
        }
        if ("true".equals(Platform.getDebugOption((String)"com.aptana.ide.debug.core/skip_debugger_install"))) {
            return true;
        }
        if (Firefox.isBrowserExecutable(browserExecutable)) {
            File profile = FirefoxUtils.findDefaultProfileLocation();
            if (profile != null) {
                String version;
                boolean available = false;
                if (FirefoxUtils.getExtensionVersion((String)EXTENSION_ID[0], (File)profile) != null && (version = FirefoxUtils.getExtensionVersion((String)EXTENSION_ID[1], (File)profile)) != null && StringUtils.compareVersions((String)version, (String)FIREBUG_MIN_VERSION) >= 0) {
                    File extension = new File(new File(profile, EXTENSIONS), EXTENSION_ID[1]);
                    available = extension.exists() && !new File(extension, DEBUGGER_FILE).exists();
                }
                browserCache.put(browserExecutable, available);
                return available;
            }
        } else if (InternetExplorer.isBrowserExecutable(browserExecutable) && BrowserUtil.isIEDebuggerAvailable()) {
            boolean available;
            block19: {
                IPath dllPath = JSDebugPlugin.getDefault().getStateLocation().append(".dll").addTrailingSeparator().append("AptanaDebugger.dll");
                boolean bl = available = dllPath.toFile().exists() && dllPath.addFileExtension("registered").toFile().exists();
                if (available) {
                    String currentDllPath;
                    File file;
                    block20: {
                        boolean pathMatch;
                        block18: {
                            file = dllPath.toFile();
                            currentDllPath = PlatformUtils.queryRegestryStringValue((String)"HKCR\\CLSID\\{B8ADD4EA-ADE3-4DEB-A957-9BBD17D6D0C8}\\InprocServer32", null);
                            boolean bl2 = pathMatch = currentDllPath != null && file.getAbsolutePath().compareTo(new File(currentDllPath).getAbsolutePath()) == 0;
                            if (!file.exists()) break block18;
                            if (file.delete()) {
                                BrowserUtil.extractFile(IE_PLUGIN_ID, EXTENSION_LOCAL_PATH[2], file);
                                break block18;
                            }
                            if (pathMatch) break block18;
                            BrowserUtil.resetBrowserCache(browserExecutable);
                            return false;
                        }
                        if (pathMatch) break block19;
                        if (!BrowserUtil.isBrowserRunning(browserExecutable)) break block20;
                        return false;
                    }
                    try {
                        if (System.getProperty("os.version").charAt(0) >= '6' && !PlatformUtils.isUserAdmin()) {
                            PlatformUtils.runAsAdmin((String)"regsvr32.exe", (String[])new String[]{"/s", dllPath.toOSString()});
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            BrowserUtil.execProcess(new String[]{"regsvr32.exe", "/s", dllPath.toOSString()}, -1L);
                        }
                        currentDllPath = PlatformUtils.queryRegestryStringValue((String)"HKCR\\CLSID\\{B8ADD4EA-ADE3-4DEB-A957-9BBD17D6D0C8}\\InprocServer32", null);
                        if (currentDllPath == null || file.getAbsolutePath().compareTo(new File(currentDllPath).getAbsolutePath()) != 0) {
                            available = false;
                        }
                    }
                    catch (IOException e) {
                        JSDebugPlugin.log((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, e.getMessage(), (Throwable)e));
                    }
                }
            }
            browserCache.put(browserExecutable, available);
            return available;
        }
        return false;
    }

    private static int execProcess(String[] cmdline, final long timeout) throws IOException {
        Process process = Runtime.getRuntime().exec(cmdline);
        final Thread thread = Thread.currentThread();
        Thread waitTimeout = new Thread(){

            public void run() {
                try {
                    Thread.sleep(timeout);
                    thread.interrupt();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        int exitcode = 0;
        if (timeout != -1L) {
            try {
                waitTimeout.start();
                exitcode = process.waitFor();
                waitTimeout.interrupt();
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
            }
            process.destroy();
        }
        try {
            exitcode = process.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        return exitcode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean installDebugExtension(String browserExecutable, IStatusHandler prompter, IProgressMonitor monitor) throws CoreException {
        boolean installDebugger = false;
        String browserName = "";
        if (Firefox.isBrowserExecutable(browserExecutable)) {
            browserName = "Firefox";
        } else if (InternetExplorer.isBrowserExecutable(browserExecutable)) {
            browserName = "Microsoft(R) Internet Explorer";
        }
        Object result = prompter.handleStatus(installDebuggerPromptStatus, (Object)browserName);
        if (result instanceof Boolean) {
            installDebugger = (Boolean)result;
        }
        if (!installDebugger) return false;
        monitor.subTask(Messages.BrowserUtil_InstallingDebugExtension);
        BrowserUtil.resetBrowserCache(browserExecutable);
        boolean installed = false;
        if (Firefox.isBrowserExecutable(browserExecutable)) {
            File profile = FirefoxUtils.findDefaultProfileLocation();
            if (profile != null) {
                try {
                    String version = FirefoxUtils.getExtensionVersion((String)"{85c7d2bd-b7c6-4644-95b2-9145a8505c4d}", (File)profile);
                    if (version != null) {
                        prompter.handleStatus(installDebuggerPromptStatus, (Object)"warning_Previous version of AptanaDebugger extension for Firefox has been found.\n Uninstall it and try again.");
                        return false;
                    }
                    File extension = new File(new File(profile, EXTENSIONS), EXTENSION_ID[1]);
                    if (extension.exists() && new File(extension, DEBUGGER_FILE).exists()) {
                        prompter.handleStatus(installDebuggerPromptStatus, (Object)"warning_Previous version of Firebug extension for Firefox has been found.\n Uninstall it and try again.");
                        return false;
                    }
                    version = FirefoxUtils.getExtensionVersion((String)EXTENSION_ID[1], (File)profile);
                    if (version != null && StringUtils.compareVersions((String)version, (String)FIREBUG_MIN_VERSION) < 0) {
                        prompter.handleStatus(installDebuggerPromptStatus, (Object)"warning_Previous version of Firebug extension for Firefox has been found.\n Uninstall it and try again.");
                        return false;
                    }
                    if (FirefoxUtils.getExtensionVersion((String)EXTENSION_ID[0], (File)profile) == null) {
                        installed = Firefox.installExtension(Platform.getBundle((String)"com.aptana.ide.debug.core").getEntry(EXTENSION_LOCAL_PATH[0]), EXTENSION_ID[0], new File(profile, EXTENSIONS));
                    }
                    if (FirefoxUtils.getExtensionVersion((String)EXTENSION_ID[1], (File)profile) == null) {
                        installed = Firefox.installExtension(Platform.getBundle((String)"com.aptana.ide.debug.core").getEntry(EXTENSION_LOCAL_PATH[1]), EXTENSION_ID[1], new File(profile, EXTENSIONS));
                    }
                    if (installed) {
                        int max_retry = 3;
                        while (BrowserUtil.isBrowserRunning(browserExecutable) && max_retry-- > 0) {
                            prompter.handleStatus(installDebuggerPromptStatus, (Object)("quit_" + browserName));
                        }
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
                }
            } else {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)Messages.BrowserUtil_FirefoxProfileNotFound);
            }
            if (installed && "macosx".equals(Platform.getOS())) {
                try {
                    BrowserUtil.execProcess(new String[]{"/usr/bin/open", "-b", BrowserUtil.getMacOSXApplicationIdentifier(browserExecutable), "about:blank"}, -1L);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.interrupted();
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.BrowserUtil_InstallError, (Throwable)e));
                }
            }
        } else if (InternetExplorer.isBrowserExecutable(browserExecutable)) {
            while (PlatformUtils.queryRegestryStringValue((String)"HKCR\\CLSID\\{04CCE2FF-A7D3-11D0-B436-00A0244A1DD2}\\InprocServer32", null) == null) {
                Boolean retry = (Boolean)prompter.handleStatus(installDebuggerPromptStatus, (Object)"nopdm");
                if (retry == null) return false;
                if (retry == false) return false;
            }
            int max_retry = 3;
            while (BrowserUtil.isBrowserRunning(browserExecutable) && max_retry-- > 0) {
                prompter.handleStatus(installDebuggerPromptStatus, (Object)("quit_" + browserName));
            }
            IPath dllPath = JSDebugPlugin.getDefault().getStateLocation().append(".dll").addTrailingSeparator().append("AptanaDebugger.dll");
            try {
                File file = dllPath.toFile();
                if (file.exists()) {
                    file.delete();
                } else {
                    dllPath.removeLastSegments(1).toFile().mkdirs();
                }
                BrowserUtil.extractFile(IE_PLUGIN_ID, EXTENSION_LOCAL_PATH[2], file);
                if (System.getProperty("os.version").charAt(0) >= '6' && !PlatformUtils.isUserAdmin()) {
                    PlatformUtils.runAsAdmin((String)"regsvr32.exe", (String[])new String[]{"/s", dllPath.toOSString()});
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    BrowserUtil.execProcess(new String[]{"regsvr32.exe", "/s", dllPath.toOSString()}, -1L);
                }
                dllPath.addFileExtension("registered").toFile().createNewFile();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.BrowserUtil_InstallError, (Throwable)e));
            }
        }
        if (installed = BrowserUtil.isBrowserDebugAvailable(browserExecutable)) {
            prompter.handleStatus(installDebuggerPromptStatus, (Object)("installed_" + browserName));
            return installed;
        }
        BrowserUtil.resetBrowserCache(browserExecutable);
        prompter.handleStatus(installDebuggerPromptStatus, (Object)("failed_" + browserName));
        return installed;
    }

    private static void extractFile(String bundleId, String path, File file) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            int n;
            in = Platform.getBundle((String)bundleId).getEntry(path).openStream();
            out = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((n = in.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }
}

