/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.decorators;

import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.StartPage;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;

public class StartPageDecorator
implements ILightweightLabelDecorator,
Observer {
    private static final ImageDescriptor START_PAGE = ServerUIPlugin.getImageDescriptor("icons/start_page_ovr.gif");
    private IResource decoratedResource;
    private ListenerList listeners = new ListenerList(1);

    public StartPageDecorator() {
        this.decoratedResource = StartPage.getInstance().getStartPageResource();
        StartPage.getInstance().addObserver(this);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (!(element instanceof IResource)) {
            return;
        }
        IResource resource = (IResource)element;
        IResource startPage = this.decoratedResource;
        if (startPage != null && startPage.equals((Object)resource)) {
            decoration.addOverlay(START_PAGE);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void fireLabelEvent(final LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                StartPageDecorator.this.fireLabelProviderChanged(event);
            }
        });
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] listeners = this.listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }

    public void update(Observable arg0, Object arg1) {
        IResource oldDecoratedResource = this.decoratedResource;
        this.decoratedResource = StartPage.getInstance().getStartPageResource();
        Object[] updatedResources = null;
        if (oldDecoratedResource != null) {
            updatedResources = this.decoratedResource != null ? new IResource[]{oldDecoratedResource, this.decoratedResource} : new IResource[]{oldDecoratedResource};
        } else if (this.decoratedResource != null) {
            updatedResources = new IResource[]{this.decoratedResource};
        }
        if (updatedResources != null) {
            this.fireLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, updatedResources));
        }
    }
}

