/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.configuration.ui;

import com.aptana.ide.server.configuration.ui.ApacheServerComposite;
import com.aptana.ide.server.configuration.ui.BasicServerComposite;
import com.aptana.ide.server.configuration.ui.ServerDialog;
import com.aptana.ide.server.internal.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class ApacheServerDialog
extends ServerDialog {
    private ApacheServerComposite apacheServerComposite;

    protected void updateServer() {
        super.updateServer();
        this.setStopApache(this.apacheServerComposite.getApacheStop());
        this.setStartApache(this.apacheServerComposite.getApacheStart());
        this.setRestartApache(this.apacheServerComposite.getApacheRestart());
        this.setDocumentRoot(this.apacheServerComposite.getDocumentRoot());
        this.setEtcHosts(this.apacheServerComposite.getEtcHostsPath());
        this.getConfiguration().setStringAttribute("HOSTNAME", this.apacheServerComposite.getApacheHost());
    }

    private void setEtcHosts(String etcHostsPath) {
        this.getConfiguration().setStringAttribute("ETCHOSTS", etcHostsPath);
    }

    private void setDocumentRoot(String root) {
        this.getConfiguration().setStringAttribute("document_root", root);
    }

    private void setRestartApache(String apacheRestart) {
        this.getConfiguration().setStringAttribute("restart", apacheRestart);
    }

    private void setStartApache(String apacheStart) {
        this.getConfiguration().setStringAttribute("start", apacheStart);
    }

    private void setStopApache(String apacheStop) {
        this.getConfiguration().setStringAttribute("shutdown", apacheStop);
    }

    public void create() {
        super.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.aptana.ide.server.ui.servers_add_apache");
    }

    protected BasicServerComposite createServerComposite(Composite composite, BasicServerComposite.StatusUpdater statusUpdater) {
        if (this.isEdit()) {
            this.setTitle(Messages.ApacheServerTypeDelegate_EDIT);
            this.setDescription(Messages.ApacheServerTypeDelegate_DESC);
        } else {
            this.setTitle(Messages.ApacheServerTypeDelegate_ADD);
            this.setDescription(Messages.ApacheServerTypeDelegate_ADD_DESC);
        }
        this.apacheServerComposite = new ApacheServerComposite(composite, 0, statusUpdater, false);
        return this.apacheServerComposite;
    }

    protected void updateData() {
        super.updateData();
        this.apacheServerComposite.setApacheStart(this.getStartApache());
        this.apacheServerComposite.setApacheRestart(this.getRestartApache());
        this.apacheServerComposite.setApacheStop(this.getStopApache());
        this.apacheServerComposite.setDocumentRoot(this.getDocumentRoot());
        this.apacheServerComposite.setEtcHostsPath(this.getEtcHosts());
        this.apacheServerComposite.setApacheHost(this.getConfiguration().getStringAttribute("HOSTNAME"));
    }

    private String getEtcHosts() {
        return this.getConfiguration().getStringAttribute("ETCHOSTS");
    }

    private String getDocumentRoot() {
        return this.getConfiguration().getStringAttribute("document_root");
    }

    private String getStopApache() {
        return this.getConfiguration().getStringAttribute("shutdown");
    }

    private String getRestartApache() {
        return this.getConfiguration().getStringAttribute("restart");
    }

    private String getStartApache() {
        return this.getConfiguration().getStringAttribute("start");
    }
}

