/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.configuration.ui;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.configuration.ui.BasicServerComposite;
import com.aptana.ide.server.configuration.ui.Messages;
import com.aptana.ide.server.internal.ApacheServer;
import java.io.File;
import java.util.Properties;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ApacheServerComposite
extends BasicServerComposite {
    private Text apacheStatup;
    private Text apacheRestart;
    private Text apacheStop;
    private Text portText;
    private Text hostText;

    public String getEtcHostsPath() {
        return "";
    }

    public String getApacheStart() {
        return this.apacheStatup.getText();
    }

    public String getApacheStop() {
        return this.apacheStop.getText();
    }

    public String getApacheRestart() {
        return this.apacheRestart.getText();
    }

    public void setEtcHostsPath(String path) {
    }

    public void setApacheStart(String value) {
        this.apacheStatup.setText(value);
    }

    public void setApacheStop(String value) {
        this.apacheStop.setText(value);
    }

    public void setApacheRestart(String value) {
        this.apacheRestart.setText(value);
    }

    public ApacheServerComposite(Composite parent, int style, BasicServerComposite.StatusUpdater updater, boolean isNested) {
        super(parent, style, updater, isNested);
        this.addExampleText(this, Messages.ApachePathHint);
        Label host = new Label((Composite)this, 0);
        Composite lhost = new Composite((Composite)this, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        GridLayout ls = new GridLayout(3, false);
        ls.marginHeight = 0;
        ls.marginWidth = 0;
        lhost.setLayout((Layout)ls);
        lhost.setLayoutData((Object)gd);
        this.hostText = new Text(lhost, 2048);
        host.setText(Messages.ApacheServerComposite_HOST);
        Label port = new Label(lhost, 0);
        port.setText(Messages.ApacheServerComposite_PORT);
        this.portText = new Text(lhost, 2048);
        this.portText.setTextLimit(5);
        this.portText.setText("80");
        this.hostText.setText("localhost");
        this.hostText.addModifyListener(this.validationModifyListener);
        this.portText.addModifyListener(this.validationModifyListener);
        this.path.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ApacheServerComposite.this.initHostAndPort();
            }
        });
        GridData gridData = new GridData(768);
        this.hostText.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        this.portText.setLayoutData((Object)gridData);
        Label startup = new Label((Composite)this, 0);
        startup.setText(Messages.ApacheServerComposite_START_APACHE);
        this.apacheStatup = new Text((Composite)this, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.apacheStatup.setLayoutData((Object)gridData);
        Label restart = new Label((Composite)this, 0);
        restart.setText(Messages.ApacheServerComposite_RESTART_APACHE);
        this.apacheRestart = new Text((Composite)this, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.apacheRestart.setLayoutData((Object)gridData);
        Label stop = new Label((Composite)this, 0);
        stop.setText(Messages.ApacheServerComposite_STOP_APACHE);
        this.apacheStop = new Text((Composite)this, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.apacheStop.setLayoutData((Object)gridData);
        this.addHorizontalSpace(this);
        this.addLogPath(this);
        this.addDocumentRootPath(this);
        this.addExampleText(this, Messages.ApacheDocRootHint);
    }

    private void initHostAndPort() {
        if (this.path != null && !"".equals(this.path.getText())) {
            File apachePath = new File(this.path.getText()).getParentFile().getParentFile();
            Properties readServerProperties = ApacheServer.readServerProperties(apachePath);
            String property = readServerProperties.getProperty("listen");
            this.setApacheHost(property);
        }
    }

    protected String getPathLabel() {
        return Messages.ApacheServerComposite_Apache;
    }

    public boolean validate() {
        boolean validate = super.validate();
        if (!validate) {
            return validate;
        }
        String host = this.hostText.getText();
        if (host.length() == 0) {
            this.updater.updateStatus(false, Messages.ApacheServerComposite_HOST_SHOULD_NOT_BE_EMPTY);
            return false;
        }
        String name = this.portText.getText();
        if (name.length() == 0) {
            this.updater.updateStatus(false, Messages.ApacheServerComposite_PORT_SHOULD_NOT_BE_EMPTY);
            return false;
        }
        try {
            int parseInt = Integer.parseInt(name);
            if (parseInt < 1 || parseInt > 65535) {
                this.updater.updateStatus(false, Messages.ApacheServerComposite_PORT_SHOULD_BE_BETWEEN);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.updater.updateStatus(false, Messages.ApacheServerComposite_PORT_SHOULD_BE_BETWEEN);
            return false;
        }
        return true;
    }

    public void setApacheHost(String property) {
        if (property != null && property.length() > 0) {
            int indexOf = property.indexOf(58);
            if (indexOf != -1) {
                this.hostText.setText(property.substring(0, indexOf));
                this.portText.setText(property.substring(indexOf + 1));
            } else {
                this.hostText.setText("127.0.0.1");
                this.portText.setText(property);
            }
        }
    }

    public String getApacheHost() {
        return StringUtils.format((String)"{0}:{1}", (Object[])new Object[]{this.hostText.getText(), this.portText.getText()});
    }
}

