/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.update.portal.clients;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.update.Activator;
import com.aptana.ide.update.FeatureUtil;
import com.aptana.ide.update.manager.IPlugin;
import com.aptana.ide.update.manager.IPluginManager;
import com.aptana.ide.update.manager.Plugin;
import com.aptana.ide.update.manager.PluginManagerException;
import com.aptana.ide.update.portal.clients.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class PluginsManager {
    PluginsManager() {
    }

    public static void install(String pluginId) {
        Plugin plugin = FeatureUtil.findRemotePlugin((String)pluginId);
        if (plugin == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.PluginsManager_ERR_TTL_Unable_find_plugin, (String)(String.valueOf(Messages.PluginsManager_ERR_MSG_Unable_find_plugin) + pluginId));
            return;
        }
        if (FeatureUtil.isInstalled((String)pluginId)) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.PluginsManager_TTL_Plugin_already_installed, (String)Messages.PluginsManager_INF_MSG_Feature_selected_already_installed);
            return;
        }
        try {
            PluginsManager.getPluginManager().install((IPlugin[])new Plugin[]{plugin}, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (PluginManagerException e) {
            IdeLog.logError((org.eclipse.core.runtime.Plugin)Activator.getDefault(), (String)e.getMessage(), (Throwable)e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.PluginsManager_ERR_TTL_Unable_install_plugin, (String)(String.valueOf(Messages.PluginsManager_ERR_MSG_Unable_install_plugin) + pluginId));
        }
    }

    private static IPluginManager getPluginManager() {
        return Activator.getDefault().getPluginManager();
    }
}

