/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.jface.internal.text.revisions.RevisionPainter;
import org.eclipse.jface.internal.text.source.DiffPainter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.JFaceTextUtil;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class UnifiedLineNumberChangeRulerColumn
extends LineNumberRulerColumn
implements IVerticalRulerInfo,
IVerticalRulerInfoExtension,
IChangeRulerColumn,
IRevisionRulerColumn {
    private IAnnotationModel fAnnotationModel;
    private boolean fCharacterDisplay;
    private StyledText textWidget;
    private ISourceViewer sourceViewer;
    private final RevisionPainter fRevisionPainter;
    private final DiffPainter fDiffPainter;

    public UnifiedLineNumberChangeRulerColumn(ISharedTextColors sharedColors) {
        Assert.isNotNull((Object)sharedColors);
        this.fRevisionPainter = new RevisionPainter((IVerticalRulerColumn)this, sharedColors);
        this.fDiffPainter = new DiffPainter((IVerticalRulerColumn)this, sharedColors);
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        Control control = super.createControl(parentRuler, parentControl);
        this.fRevisionPainter.setParentRuler(parentRuler);
        this.fDiffPainter.setParentRuler(parentRuler);
        return control;
    }

    public int getLineOfLastMouseButtonActivity() {
        return this.getParentRuler().getLineOfLastMouseButtonActivity();
    }

    public int toDocumentLineNumber(int y_coordinate) {
        return this.getParentRuler().toDocumentLineNumber(y_coordinate);
    }

    public void setModel(IAnnotationModel model) {
        this.setAnnotationModel(model);
        this.fRevisionPainter.setModel(model);
        this.fDiffPainter.setModel(model);
        this.updateNumberOfDigits();
        this.computeIndentations();
        this.layout(true);
        this.postRedraw();
    }

    private void setAnnotationModel(IAnnotationModel model) {
        if (this.fAnnotationModel != model) {
            this.fAnnotationModel = model;
        }
    }

    public void setDisplayMode(boolean characterMode) {
        if (characterMode != this.fCharacterDisplay) {
            this.fCharacterDisplay = characterMode;
            this.updateNumberOfDigits();
            this.computeIndentations();
            this.layout(true);
        }
    }

    public IAnnotationModel getModel() {
        return this.fAnnotationModel;
    }

    protected String createDisplayString(int line) {
        if (this.fCharacterDisplay && this.getModel() != null) {
            return String.valueOf(super.createDisplayString(line)) + this.fDiffPainter.getDisplayCharacter(line);
        }
        return super.createDisplayString(line);
    }

    protected int computeNumberOfDigits() {
        if (this.fCharacterDisplay && this.getModel() != null) {
            return super.computeNumberOfDigits() + 1;
        }
        return super.computeNumberOfDigits();
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    void doPaint(GC gc, ILineRange visibleLines) {
        Color foreground = gc.getForeground();
        if (visibleLines != null) {
            this.fRevisionPainter.paint(gc, visibleLines);
            if (!this.fRevisionPainter.hasInformation()) {
                this.fDiffPainter.paint(gc, visibleLines);
            }
        }
        gc.setForeground(foreground);
        Display display = this.textWidget.getDisplay();
        int y = -JFaceTextUtil.getHiddenTopLinePixels(this.textWidget);
        int lastLine = UnifiedLineNumberChangeRulerColumn.end(visibleLines);
        int line = visibleLines.getStartLine();
        while (line < lastLine) {
            int widgetLine = JFaceTextUtil.modelLineToWidgetLine((ITextViewer)this.sourceViewer, line);
            if (widgetLine != -1) {
                int lineHeight = 0;
                if (widgetLine + 1 < this.textWidget.getLineCount()) {
                    int start = this.textWidget.getOffsetAtLine(widgetLine);
                    int next = this.textWidget.getOffsetAtLine(widgetLine + 1) - 1;
                    Rectangle bounds = this.textWidget.getTextBounds(start, next);
                    lineHeight = Math.max(bounds.height, this.textWidget.getLineHeight(widgetLine));
                } else {
                    lineHeight = this.textWidget.getLineHeight(this.textWidget.getOffsetAtLine(widgetLine));
                }
                this.paintLine(line, y, lineHeight, gc, display);
                y += lineHeight;
            }
            ++line;
        }
    }

    private static int end(ILineRange range) {
        return range.getStartLine() + range.getNumberOfLines();
    }

    public IAnnotationHover getHover() {
        int activeLine = this.getParentRuler().getLineOfLastMouseButtonActivity();
        if (this.fRevisionPainter.hasHover(activeLine)) {
            return this.fRevisionPainter.getHover();
        }
        if (this.fDiffPainter.hasHover(activeLine)) {
            return this.fDiffPainter.getHover();
        }
        return null;
    }

    public void setHover(IAnnotationHover hover) {
        this.fRevisionPainter.setHover(hover);
        this.fDiffPainter.setHover(hover);
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        this.fRevisionPainter.setBackground(background);
        this.fDiffPainter.setBackground(background);
    }

    public void setAddedColor(Color addedColor) {
        this.fDiffPainter.setAddedColor(addedColor);
    }

    public void setChangedColor(Color changedColor) {
        this.fDiffPainter.setChangedColor(changedColor);
    }

    public void setDeletedColor(Color deletedColor) {
        this.fDiffPainter.setDeletedColor(deletedColor);
    }

    public void setRevisionInformation(RevisionInformation info) {
        this.fRevisionPainter.setRevisionInformation(info);
    }

    public ISelectionProvider getRevisionSelectionProvider() {
        return this.fRevisionPainter.getRevisionSelectionProvider();
    }

    public ISourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public StyledText getTextWidget() {
        return this.textWidget;
    }

    public void setTextWidget(StyledText textWidget) {
        this.textWidget = textWidget;
    }
}

