/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.secureftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

class FTPFileUploadOutputStream
extends OutputStream {
    private FTPClientInterface ftpClient;
    private FileTransferOutputStream ftpOutputStream;
    private String filename;
    private Date modificationTime;
    private long permissions;

    public FTPFileUploadOutputStream(FTPClientInterface ftpClient, FileTransferOutputStream ftpOutputStream, String filename, Date modificationTime, long permissions) {
        this.ftpClient = ftpClient;
        this.ftpOutputStream = ftpOutputStream;
        this.filename = filename;
        this.modificationTime = modificationTime;
        this.permissions = permissions;
    }

    private void safeQuit(boolean failed) {
        if (this.ftpClient instanceof FTPClient) {
            ((FTPClient)this.ftpClient).setMessageListener(null);
        }
        try {
            if (this.ftpClient.connected()) {
                if (failed) {
                    this.ftpClient.delete(this.ftpOutputStream.getRemoteFile());
                }
                this.ftpClient.quit();
            }
        }
        catch (Exception exception) {
            try {
                this.ftpClient.quitImmediately();
            }
            catch (Exception exception2) {}
        }
    }

    public void write(int b) throws IOException {
        try {
            this.ftpOutputStream.write(b);
        }
        catch (IOException e) {
            this.safeQuit(true);
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            this.ftpOutputStream.close();
            try {
                if (this.modificationTime != null) {
                    this.ftpClient.setModTime(this.ftpOutputStream.getRemoteFile(), this.modificationTime);
                }
                if (this.filename != null) {
                    if (this.ftpClient.exists(this.filename)) {
                        this.ftpClient.delete(this.filename);
                    }
                    this.ftpClient.rename(this.ftpOutputStream.getRemoteFile(), this.filename);
                    if (this.ftpClient instanceof FTPClient) {
                        ((FTPClient)this.ftpClient).site("CHMOD " + Long.toOctalString(this.permissions) + " " + this.filename);
                    } else if (this.ftpClient instanceof SSHFTPClient) {
                        ((SSHFTPClient)this.ftpClient).changeMode((int)(this.permissions & 0x1FFL), this.filename);
                    }
                }
            }
            catch (FTPException e) {
                this.safeQuit(true);
                throw new IOException(e.getMessage());
            }
        }
        finally {
            this.safeQuit(false);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.ftpOutputStream.write(b, off, len);
        }
        catch (IOException e) {
            this.safeQuit(true);
            throw e;
        }
    }
}

