/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.efs;

import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.efs.LocalFile;
import com.aptana.ide.core.io.efs.WorkspaceFileSystem;
import com.aptana.ide.core.io.preferences.CloakingUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EFSUtils {
    private EFSUtils() {
    }

    public static IFileStore getFileStore(IResource resource) {
        return WorkspaceFileSystem.getInstance().getStore(resource.getFullPath());
    }

    public static IFileStore getFileStore(File file) {
        return new LocalFile(file);
    }

    public static IFileStore getLocalFileStore(File file) {
        return EFS.getLocalFileSystem().fromLocalFile(file);
    }

    public static void setModificationTime(long modifiedTime, IFileStore destFile) throws CoreException {
        FileInfo fi = new FileInfo();
        fi.setLastModified(modifiedTime);
        destFile.putInfo((IFileInfo)fi, 2048, null);
    }

    public static IFileStore[] getFiles(IFileStore file) throws CoreException {
        return EFSUtils.getFiles(file, false, true);
    }

    public static IFileStore[] getFiles(IFileStore file, IProgressMonitor monitor) throws CoreException {
        return EFSUtils.getFiles(file, false, true, monitor);
    }

    public static IFileStore[] getFiles(IFileStore file, boolean recurse, boolean includeCloakedFiles) throws CoreException {
        return EFSUtils.getFiles(file, recurse, includeCloakedFiles, null);
    }

    public static String getAbsolutePath(IFileStore file) {
        return file.toURI().getPath();
    }

    public static String getRelativePath(IFileStore parent, IFileStore file) {
        if (parent.equals(file) || parent.isParentOf(file)) {
            String rootFile = EFSUtils.getAbsolutePath(parent);
            String childFile = EFSUtils.getAbsolutePath(file);
            return childFile.substring(rootFile.length());
        }
        return null;
    }

    public static IFileStore createFile(IFileStore sourceRoot, IFileStore sourceStore, IFileStore destinationRoot) {
        String sourceRootPath = sourceRoot.toURI().getPath();
        String sourcePath = sourceStore.toURI().getPath();
        int index = sourcePath.indexOf(sourceRootPath);
        if (index > -1) {
            String relativePath = sourcePath.substring(index + sourceRootPath.length());
            return destinationRoot.getFileStore((IPath)new Path(relativePath));
        }
        return null;
    }

    public static String getRelativePath(IConnectionPoint point, IFileStore file) {
        try {
            return EFSUtils.getRelativePath(point.getRoot(), file);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static boolean copyFile(IFileStore sourceStore, IFileStore destinationStore, IProgressMonitor monitor) throws CoreException {
        if (sourceStore == null || CloakingUtils.isFileCloaked(sourceStore)) {
            return false;
        }
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        boolean success = true;
        monitor.subTask(MessageFormat.format("Copying {0} to {1}", sourceStore.getName(), destinationStore.getName()));
        sourceStore.copy(destinationStore, 2, monitor);
        return success;
    }

    public static boolean copyFileWithAttributes(IFileStore sourceStore, IFileStore destinationStore, IProgressMonitor monitor, IFileInfo info) throws CoreException {
        boolean success = EFSUtils.copyFile(sourceStore, destinationStore, monitor);
        if (success) {
            EFSUtils.setModificationTime(info.getLastModified(), destinationStore);
        }
        return success;
    }

    public static IFileStore[] getFiles(IFileStore file, boolean recurse, boolean includeCloakedFiles, IProgressMonitor monitor) throws CoreException {
        IFileStore[] result = null;
        ArrayList<IFileStore> list = new ArrayList<IFileStore>();
        EFSUtils.getFiles(file, recurse, list, includeCloakedFiles, monitor);
        result = list.toArray(new IFileStore[0]);
        return result;
    }

    public static IFileStore[] getFiles(IFileStore[] files, boolean recurse, boolean includeCloakedFiles, IProgressMonitor monitor) throws CoreException {
        ArrayList<IFileStore> fileList = new ArrayList<IFileStore>();
        int i = 0;
        while (i < files.length) {
            fileList.addAll(Arrays.asList(EFSUtils.getFiles(files[i], recurse, includeCloakedFiles, monitor)));
            ++i;
        }
        return fileList.toArray(new IFileStore[0]);
    }

    public static IFileStore[] getAllFiles(IFileStore[] files, boolean recurse, boolean includeCloakedFiles, IProgressMonitor monitor) throws CoreException {
        ArrayList<IFileStore> fileList = new ArrayList<IFileStore>();
        fileList.addAll(Arrays.asList(files));
        IFileStore[] childFiles = EFSUtils.getFiles(files, true, false, monitor);
        fileList.addAll(Arrays.asList(childFiles));
        return fileList.toArray(new IFileStore[0]);
    }

    private static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    private static void getFiles(IFileStore file, boolean recurse, List<IFileStore> list, boolean includeCloakedFiles, IProgressMonitor monitor) throws CoreException {
        IFileStore[] children;
        if (file == null) {
            return;
        }
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        Policy.checkCanceled((IProgressMonitor)monitor);
        if (EFSUtils.isFolder(file, monitor) && (children = file.childStores(0, monitor)) != null) {
            IProgressMonitor subMonitor = EFSUtils.subMonitorFor(monitor, 2);
            subMonitor.beginTask(MessageFormat.format("Fetching children of {0}", file.getName()), children.length);
            int i = 0;
            while (i < children.length) {
                Policy.checkCanceled((IProgressMonitor)monitor);
                IFileStore child = children[i];
                boolean addingFile = false;
                if (includeCloakedFiles || !CloakingUtils.isFileCloaked(child)) {
                    list.add(child);
                    addingFile = true;
                    subMonitor.worked(1);
                }
                if (recurse && addingFile && EFSUtils.isFolder(child, monitor)) {
                    EFSUtils.getFiles(child, recurse, list, includeCloakedFiles, subMonitor);
                }
                ++i;
            }
            subMonitor.done();
        }
    }

    private static boolean isFolder(IFileStore file, IProgressMonitor monitor) throws CoreException {
        IResource resource = (IResource)file.getAdapter(IResource.class);
        if (resource instanceof IContainer) {
            return true;
        }
        return !(resource instanceof IFile) && file.fetchInfo(0, monitor).isDirectory();
    }
}

