/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.ide.core.epl.IMemento;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.vfs.VirtualConnectionManager;
import java.net.URI;
import java.util.UUID;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class ConnectionPoint
extends PlatformObject
implements IConnectionPoint,
IExecutableExtension {
    protected static final String ELEMENT_NAME = "name";
    private String id;
    private String type;
    private boolean dirty;
    protected String name;

    protected ConnectionPoint(String type) {
        this.type = type;
        this.setId(UUID.randomUUID().toString());
    }

    protected ConnectionPoint() {
        this("");
    }

    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.setType(config.getAttribute("id"));
    }

    protected boolean isPersistent() {
        return true;
    }

    protected void loadState(IMemento memento) {
        IMemento child = memento.getChild(ELEMENT_NAME);
        if (child != null) {
            this.name = child.getTextData();
        }
    }

    protected void saveState(IMemento memento) {
        memento.createChild(ELEMENT_NAME).putTextData(this.name);
    }

    public final String getId() {
        return this.id;
    }

    protected final void setId(String id) {
        this.id = id;
        VirtualConnectionManager.getInstance().register(this);
    }

    public final String getType() {
        return this.type;
    }

    protected final void setType(String type) {
        this.type = type;
    }

    protected final void notifyChanged() {
        this.dirty = true;
    }

    final boolean isChanged() {
        try {
            boolean bl = this.dirty;
            return bl;
        }
        finally {
            this.dirty = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.notifyChanged();
    }

    public URI getRootURI() {
        return VirtualConnectionManager.getInstance().getConnectionVirtualURI(this);
    }

    public IFileStore getRoot() throws CoreException {
        return EFS.getStore((URI)this.getRootURI());
    }

    public void connect(IProgressMonitor monitor) throws CoreException {
        this.connect(false, monitor);
    }

    public void connect(boolean force, IProgressMonitor monitor) throws CoreException {
    }

    public boolean isConnected() {
        return true;
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect(IProgressMonitor monitor) throws CoreException {
    }

    public Object getAdapter(Class adapter) {
        if (IFileStore.class == adapter) {
            try {
                return this.getRoot();
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return this.getName();
    }

    public boolean load15Data(String data) {
        return false;
    }
}

