/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.ui.text.spelling.engine;

import com.aptana.internal.ui.text.spelling.PreferenceConstants;
import com.aptana.internal.ui.text.spelling.engine.AbstractSpellDictionary;
import com.aptana.internal.ui.text.spelling.engine.ISpellCheckIterator;
import com.aptana.internal.ui.text.spelling.engine.ISpellChecker;
import com.aptana.internal.ui.text.spelling.engine.ISpellDictionary;
import com.aptana.internal.ui.text.spelling.engine.ISpellEventListener;
import com.aptana.internal.ui.text.spelling.engine.SpellEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;

public class DefaultSpellChecker
implements ISpellChecker {
    public static final String[] URL_PREFIXES = new String[]{"http://", "https://", "www.", "ftp://", "ftps://", "news://", "mailto://"};
    private final Set fDictionaries = Collections.synchronizedSet(new HashSet());
    private final Set fIgnored = Collections.synchronizedSet(new HashSet());
    private final IPreferenceStore fPreferences;
    private final Locale fLocale;

    protected static boolean isDigits(String word) {
        int index = 0;
        while (index < word.length()) {
            if (Character.isDigit(word.charAt(index))) {
                return true;
            }
            ++index;
        }
        return false;
    }

    protected static boolean isMixedCase(String word, boolean sentence) {
        int length = word.length();
        boolean upper = Character.isUpperCase(word.charAt(0));
        if (sentence && upper && length > 1) {
            upper = Character.isUpperCase(word.charAt(1));
        }
        if (upper) {
            int index = length - 1;
            while (index > 0) {
                if (Character.isLowerCase(word.charAt(index))) {
                    return true;
                }
                --index;
            }
        } else {
            int index = length - 1;
            while (index > 0) {
                if (Character.isUpperCase(word.charAt(index))) {
                    return true;
                }
                --index;
            }
        }
        return false;
    }

    protected static boolean isUpperCase(String word) {
        int index = word.length() - 1;
        while (index >= 0) {
            if (Character.isLowerCase(word.charAt(index))) {
                return false;
            }
            --index;
        }
        return true;
    }

    protected static boolean isUrl(String word) {
        int index = 0;
        while (index < URL_PREFIXES.length) {
            if (word.startsWith(URL_PREFIXES[index])) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public DefaultSpellChecker(IPreferenceStore store, Locale locale) {
        Assert.isLegal((store != null ? 1 : 0) != 0);
        Assert.isLegal((locale != null ? 1 : 0) != 0);
        this.fPreferences = store;
        this.fLocale = locale;
    }

    public final void addDictionary(ISpellDictionary dictionary) {
        this.fDictionaries.add(dictionary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptsWords() {
        HashSet copy;
        Set set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet(this.fDictionaries);
        }
        ISpellDictionary dictionary2 = null;
        for (ISpellDictionary dictionary2 : copy) {
            if (!dictionary2.acceptsWords()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWord(String word) {
        HashSet copy;
        Set set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet(this.fDictionaries);
        }
        String addable = word.toLowerCase();
        for (ISpellDictionary dictionary : copy) {
            if (!dictionary.acceptsWords()) continue;
            dictionary.addWord(addable);
        }
    }

    public final void checkWord(String word) {
        this.fIgnored.remove(word.toLowerCase());
    }

    public void execute(ISpellEventListener listener, ISpellCheckIterator iterator) {
        boolean ignoreDigits = this.fPreferences.getBoolean("spelling_ignore_digits");
        boolean ignoreMixed = this.fPreferences.getBoolean("spelling_ignore_mixed");
        boolean ignoreSentence = this.fPreferences.getBoolean("spelling_ignore_sentence");
        boolean ignoreUpper = this.fPreferences.getBoolean("spelling_ignore_upper");
        boolean ignoreURLS = this.fPreferences.getBoolean("spelling_ignore_urls");
        boolean ignoreNonLetters = this.fPreferences.getBoolean("spelling_ignore_non_letters");
        boolean ignoreSingleLetters = this.fPreferences.getBoolean("spelling_ignore_single_letters");
        int problemsThreshold = PreferenceConstants.getPreferenceStore().getInt("spelling_problems_threshold");
        iterator.setIgnoreSingleLetters(ignoreSingleLetters);
        Iterator iter = this.fDictionaries.iterator();
        while (iter.hasNext()) {
            ((ISpellDictionary)iter.next()).setStripNonLetters(ignoreNonLetters);
        }
        String word = null;
        boolean starts = false;
        int problemCount = 0;
        while (problemCount <= problemsThreshold && iterator.hasNext()) {
            word = (String)iterator.next();
            if (word == null || this.fIgnored.contains(word)) continue;
            starts = iterator.startsSentence();
            if (!this.isCorrect(word)) {
                boolean isMixed = DefaultSpellChecker.isMixedCase(word, true);
                boolean isUpper = DefaultSpellChecker.isUpperCase(word);
                boolean isDigits = DefaultSpellChecker.isDigits(word);
                boolean isURL = DefaultSpellChecker.isUrl(word);
                if (!(!ignoreMixed && isMixed || !ignoreUpper && isUpper || !ignoreDigits && isDigits || !ignoreURLS && isURL) && (isMixed || isUpper || isDigits || isURL)) continue;
                listener.handle(new SpellEvent(this, word, iterator.getBegin(), iterator.getEnd(), starts, false));
                ++problemCount;
                continue;
            }
            if (ignoreSentence || !starts || !Character.isLowerCase(word.charAt(0))) continue;
            listener.handle(new SpellEvent(this, word, iterator.getBegin(), iterator.getEnd(), true, true));
            ++problemCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getProposals(String word, boolean sentence) {
        HashSet copy;
        Set set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet(this.fDictionaries);
        }
        ISpellDictionary dictionary2 = null;
        HashSet proposals = new HashSet();
        for (ISpellDictionary dictionary2 : copy) {
            proposals.addAll(dictionary2.getProposals(word, sentence));
        }
        return proposals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getCompletionProposals(String word, boolean sentence) {
        HashSet copy;
        Set set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet(this.fDictionaries);
        }
        ISpellDictionary dictionary2 = null;
        HashSet proposals = new HashSet();
        for (ISpellDictionary dictionary2 : copy) {
            if (dictionary2 instanceof AbstractSpellDictionary) {
                AbstractSpellDictionary sp = (AbstractSpellDictionary)dictionary2;
                proposals.addAll(sp.getCompletionProposals(word, sentence));
                continue;
            }
            proposals.addAll(dictionary2.getProposals(word, sentence));
        }
        return proposals;
    }

    public final void ignoreWord(String word) {
        this.fIgnored.add(word.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCorrect(String word) {
        HashSet copy;
        Set set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet(this.fDictionaries);
        }
        if (this.fIgnored.contains(word.toLowerCase())) {
            return true;
        }
        if (word.indexOf(64) != -1) {
            return true;
        }
        ISpellDictionary dictionary2 = null;
        for (ISpellDictionary dictionary2 : copy) {
            if (!dictionary2.isCorrect(word)) continue;
            return true;
        }
        return false;
    }

    public final void removeDictionary(ISpellDictionary dictionary) {
        this.fDictionaries.remove(dictionary);
    }

    public Locale getLocale() {
        return this.fLocale;
    }
}

