/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.ui.text.spelling;

import com.aptana.internal.ui.text.spelling.TextSpellingEngine;
import com.aptana.semantic.ui.text.spelling.Activator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingEngineDescriptor;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class DefaultSpellingEngine
implements ISpellingEngine {
    private static final IContentType TEXT_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
    private final Map fEngines = new HashMap();
    private SpellingService spellingService;
    ISpellingEngine defaultEngine;

    public DefaultSpellingEngine() {
        if (TEXT_CONTENT_TYPE != null) {
            this.fEngines.put(TEXT_CONTENT_TYPE, new TextSpellingEngine());
        }
        this.spellingService = new SpellingService(Activator.getSpellingPreferenceStore());
    }

    public void check(IDocument document, IRegion[] regions, SpellingContext context, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        ISpellingEngine engine = this.getEngine(context.getContentType());
        if (engine == null) {
            engine = this.getEngine(TEXT_CONTENT_TYPE);
        }
        if (engine != null) {
            engine.check(document, regions, context, collector, monitor);
        }
    }

    private ISpellingEngine getEngine(IContentType contentType) {
        SpellingEngineDescriptor[] spellingEngineDescriptors;
        if (contentType == null) {
            return null;
        }
        if (this.fEngines.containsKey(contentType)) {
            return (ISpellingEngine)this.fEngines.get(contentType);
        }
        if (this.defaultEngine != null) {
            return this.defaultEngine;
        }
        SpellingEngineDescriptor[] spellingEngineDescriptorArray = spellingEngineDescriptors = this.spellingService.getSpellingEngineDescriptors();
        int n = spellingEngineDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            SpellingEngineDescriptor d = spellingEngineDescriptorArray[n2];
            String id = d.getId();
            if (id.equals("org.eclipse.jdt.internal.ui.text.spelling.DefaultSpellingEngine")) {
                try {
                    ISpellingEngine createEngine;
                    this.defaultEngine = createEngine = d.createEngine();
                    return createEngine;
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
            }
            ++n2;
        }
        return null;
    }
}

