/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.commons.spelling.engine;

import com.aptana.commons.spelling.engine.NoCompletionsProposal;
import com.aptana.commons.spelling.engine.SpellingAnnotation;
import com.aptana.commons.spelling.engine.TextInvocationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpellingCorrectionProcessor
implements IQuickAssistProcessor {
    private static final ICompletionProposal[] fgNoSuggestionsProposal = new ICompletionProposal[]{new NoCompletionsProposal()};

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        int documentOffset = quickAssistContext.getOffset();
        int length = 0;
        if (viewer != null && viewer.getSelectedRange() != null) {
            length = viewer.getSelectedRange().y;
        }
        TextInvocationContext ts = new TextInvocationContext(viewer, documentOffset, length);
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return fgNoSuggestionsProposal;
        }
        List<ICompletionProposal> proposals = this.computeProposals(ts, model);
        if (proposals.isEmpty()) {
            return fgNoSuggestionsProposal;
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private boolean isAtPosition(int offset, Position pos) {
        return pos != null && offset >= pos.getOffset() && offset <= pos.getOffset() + pos.getLength();
    }

    private List<ICompletionProposal> computeProposals(TextInvocationContext ts, IAnnotationModel model) {
        ArrayList<SpellingProblem> annotationList = new ArrayList<SpellingProblem>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Annotation annotation = (Annotation)iter.next();
            if (!this.canFix(annotation)) continue;
            Position pos = model.getPosition(annotation);
            if (!this.isAtPosition(ts.getOffset(), pos)) continue;
            this.collectSpellingProblems(ts, annotation, pos, annotationList);
        }
        SpellingProblem[] spellingProblems = annotationList.toArray(new SpellingProblem[annotationList.size()]);
        return this.computeProposals(spellingProblems, ts);
    }

    private void collectSpellingProblems(TextInvocationContext ts, Annotation annotation, Position pos, List<SpellingProblem> problems) {
        if (annotation instanceof SpellingAnnotation) {
            problems.add(((SpellingAnnotation)annotation).getSpellingProblem());
        }
    }

    private List<ICompletionProposal> computeProposals(SpellingProblem[] spellingProblems, TextInvocationContext ts) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        int i = 0;
        if (i < spellingProblems.length) {
            ICompletionProposal[] proposals2 = spellingProblems[i].getProposals((IQuickAssistInvocationContext)ts);
            proposals.addAll(Arrays.asList(proposals2));
        }
        return proposals;
    }

    public String getErrorMessage() {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        return annotation instanceof SpellingAnnotation && !annotation.isMarkedDeleted();
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }
}

