/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.views.profiles;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.core.ui.WorkbenchHelper;
import com.aptana.ide.core.ui.widgets.Accordion;
import com.aptana.ide.editor.js.JSLanguageEnvironment;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.profiles.IProfileAppliedListener;
import com.aptana.ide.editors.profiles.IProfileChangeListener;
import com.aptana.ide.editors.profiles.Profile;
import com.aptana.ide.editors.profiles.ProfileManager;
import com.aptana.ide.editors.profiles.ProfileURI;
import com.aptana.ide.editors.profiles.TransientProfileURI;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.FileContextContentEvent;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileContextListener;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.UnifiedInformationControl;
import com.aptana.ide.editors.unified.utils.HTMLTextPresenter;
import com.aptana.ide.editors.views.profiles.IProfilesViewEventListener;
import com.aptana.ide.editors.views.profiles.Messages;
import com.aptana.ide.editors.views.profiles.ProfilesViewEvent;
import com.aptana.ide.editors.views.profiles.ProfilesViewHelper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;

public class ProfilesView
extends ViewPart
implements IFileContextListener,
IPropertyChangeListener {
    static final String INFO_MESSAGE = Messages.ProfilesView_OpenOrDropFile;
    static final String[] FILTER_EXTENSIONS = new String[]{Messages.ProfilesView_JsExtension, Messages.ProfilesView_HtmlExtension, Messages.ProfilesView_AllExtension};
    static final String[] FILTER_NAMES = new String[]{StringUtils.format((String)Messages.ProfilesView_JavaScriptFiles, (String)FILTER_EXTENSIONS[0]), StringUtils.format((String)Messages.ProfilesView_HTMLFiles, (String)FILTER_EXTENSIONS[1]), StringUtils.format((String)Messages.ProfilesView_AllFiles, (String)FILTER_EXTENSIONS[2])};
    static final String defaultTitle = "Default Profile";
    static final String staticProtocol = "static://";
    static final String defaultPath = "static://Default Profile";
    static final String titleLabel = " (Auto-created)";
    protected static final String JS_EDITOR_CLASS = "com.aptana.ide.editor.js.JSEditor";
    protected static final String HTML_EDITOR_CLASS = "com.aptana.ide.editor.html.HTMLEditor";
    protected static final String GENERIC_EDITOR_CLASS = "com.aptana.ide.editors";
    protected static final String JS_EDITOR_ID = "com.aptana.ide.editors.JSEditor";
    protected static final String HTML_EDITOR_ID = "com.aptana.ide.editors.HTMLEditor";
    private boolean isLinked = true;
    private IPartListener _partListener;
    private static ImageDescriptor fUpIconDescriptor = ProfilesView.getImageDescriptor("icons/upward_nav_on.gif");
    private static ImageDescriptor fDownIconDescriptor = ProfilesView.getImageDescriptor("icons/downward_nav_on.gif");
    private static ImageDescriptor fAddFileIconDescriptor = ProfilesView.getImageDescriptor("icons/js_file_new.gif");
    private static ImageDescriptor fAddProfileIconDescriptor = ProfilesView.getImageDescriptor("icons/folder_new.gif");
    private static ImageDescriptor fRefreshIconDescriptor = ProfilesView.getImageDescriptor("icons/refresh.gif");
    private static ImageDescriptor fLinkWithEditorIconDescriptor = ProfilesView.getImageDescriptor("icons/sync.gif");
    private static ImageDescriptor fMakeCurrentProfileIconDescriptor = ProfilesView.getImageDescriptor("icons/profile-current.gif");
    private static Image fErrIcon = ProfilesView.getImageDescriptor("icons/error.gif").createImage();
    private static Image fProfileIcon = ProfilesView.getImageDescriptor("icons/profile.gif").createImage();
    private static Image fProfileDynamicIcon = ProfilesView.getImageDescriptor("icons/profile-dynamic.gif").createImage();
    private static Image fProfileCurrentIcon = ProfilesView.getImageDescriptor("icons/profile-current.gif").createImage();
    private static Image fProfileCurrentDynamicIcon = ProfilesView.getImageDescriptor("icons/profile-dynamic-current.gif").createImage();
    private static Image fProfileFileIcon = ProfilesView.getImageDescriptor("icons/js_file.gif").createImage();
    private static Image fProfileFileDynamicIcon = ProfilesView.getImageDescriptor("icons/js_file_new.gif").createImage();
    private static Image fProfileFileIconGrey = ProfilesView.getImageDescriptor("icons/js_file_grey.gif").createImage();
    private static Image fProfileFileDynamicIconGrey = ProfilesView.getImageDescriptor("icons/js_file_new_grey.gif").createImage();
    private Composite displayArea;
    private TreeViewer viewer;
    private Accordion accordion;
    private Composite fileDrawer;
    private Composite globalDrawer;
    private Composite top;
    private ToolBar globalToolbar;
    private ToolItem addGlobal;
    private ToolItem removeGlobal;
    private Table globalEnvironments;
    private ProgressBar bar;
    private StackLayout topLayout;
    private Label infoLabel;
    private Font infoLabelFont;
    private HashMap<File, Image> images = new HashMap();
    private Action actionAddProfile;
    private Action actionAdd;
    private Action actionDelete;
    private Action actionMoveUp;
    private Action actionMoveDown;
    private Action actionRefresh;
    private Action actionDoubleClick;
    private Action actionAddCurrentFile;
    private Action actionMakeStatic;
    private Action actionLinkWithEditor;
    private Action actionMakeCurrent;
    private ArrayList<IProfilesViewEventListener> listeners = new ArrayList();
    public ProfileManager profileManager = UnifiedEditorsPlugin.getDefault().getProfileManager();

    public void fireProfilesViewEvent(ProfilesViewEvent e) {
        int i = 0;
        while (i < this.listeners.size()) {
            IProfilesViewEventListener listener = this.listeners.get(i);
            listener.onProfilesViewEvent(e);
            ++i;
        }
    }

    public void addProfilesViewEventListener(IProfilesViewEventListener l) {
        this.listeners.add(l);
    }

    public void removeProfilesViewEventListener(IProfilesViewEventListener l) {
        this.listeners.remove(l);
    }

    public ProfilesView() {
        this.profileManager.addProfileChangeListener(new IProfileChangeListener(){

            public void onProfileChanged(Profile p) {
                if (ProfilesView.this.viewer.getTree().isDisposed()) {
                    return;
                }
                ProfilesView.this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (ProfilesView.this.viewer.getTree().isDisposed()) {
                            return;
                        }
                        Object[] expanded = ProfilesView.this.viewer.getExpandedElements();
                        ProfilesView.this.viewer.refresh();
                        ProfilesView.this.viewer.setExpandedElements(expanded);
                    }
                });
            }
        });
        this.profileManager.addProfileAppliedListener(new IProfileAppliedListener(){

            public void onProfileApplied(final ProfileURI profileURI, final boolean state) {
                if (ProfilesView.this.viewer == null || ProfilesView.this.viewer.getTree() == null || ProfilesView.this.viewer.getTree().isDisposed()) {
                    return;
                }
                ProfilesView.this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (ProfilesView.this.viewer.getTree().isDisposed()) {
                            return;
                        }
                        TreeItem[] treeItems = ProfilesView.this.viewer.getTree().getItems();
                        boolean toggleState = state;
                        int i = 0;
                        while (i < treeItems.length) {
                            Profile profile;
                            Object o = treeItems[i].getData();
                            if (o instanceof Profile && (profile = (Profile)o).getURI().equals(profileURI.getParent().getURI())) {
                                TreeItem[] children = treeItems[i].getItems();
                                int j = 0;
                                while (j < children.length) {
                                    TreeItem treeItem = children[j];
                                    ProfileURI profileURIItem = (ProfileURI)treeItem.getData();
                                    String uri = profileURI.getURI();
                                    if (profileURIItem != null && profileURIItem.getURI().equals(uri)) {
                                        if (treeItem.getImage() == fErrIcon) {
                                            return;
                                        }
                                        if (profileURIItem instanceof TransientProfileURI) {
                                            if (toggleState) {
                                                treeItem.setImage(fProfileFileDynamicIcon);
                                            } else {
                                                treeItem.setImage(fProfileFileDynamicIconGrey);
                                            }
                                        } else if (toggleState) {
                                            treeItem.setImage(fProfileFileIcon);
                                        } else {
                                            treeItem.setImage(fProfileFileIconGrey);
                                        }
                                        return;
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                    }
                });
            }
        });
        JSPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void bindToWorkbench() {
        final ProfilesView me = this;
        me._partListener = new IPartListener(){

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    String uri = CoreUIUtils.getURI((IEditorPart)((IEditorPart)part));
                    if (part.getClass().getName().equals(ProfilesView.HTML_EDITOR_CLASS)) {
                        Profile profile = ProfilesView.this.profileManager.getProfile(uri);
                        if (ProfilesView.this.getCurrentProfile() != null && ProfilesView.this.getCurrentProfile().equals(profile)) {
                            ProfilesView.this.setCurrentProfile(ProfilesView.defaultPath);
                        }
                        if (profile != null) {
                            ProfilesView.this.deleteProfile(profile.getURI());
                        }
                    }
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
                IEditorPart activeEditor;
                if (part instanceof IEditorPart && (activeEditor = CoreUIUtils.getActiveEditor()) != null && activeEditor instanceof IUnifiedEditor) {
                    IUnifiedEditor editor = (IUnifiedEditor)activeEditor;
                    editor.getFileContext().removeDelayedFileListener((IFileContextListener)me);
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    IDocumentProviderExtension extension;
                    IStatus status;
                    ITextEditor te;
                    if (part instanceof ITextEditor && (te = (ITextEditor)part).getDocumentProvider() instanceof IDocumentProviderExtension && (status = (extension = (IDocumentProviderExtension)te.getDocumentProvider()).getStatus((Object)te.getEditorInput())) != null && !status.isOK()) {
                        return;
                    }
                    String uri = CoreUIUtils.getURI((IEditorPart)((IEditorPart)part));
                    IEditorPart activeEditor = CoreUIUtils.getActiveEditor();
                    if (activeEditor != null && activeEditor instanceof IUnifiedEditor) {
                        IUnifiedEditor editor = (IUnifiedEditor)activeEditor;
                        editor.getFileContext().addDelayedFileListener((IFileContextListener)me);
                    }
                    boolean needsRefresh = false;
                    if (uri == null || uri.equals("")) {
                        return;
                    }
                    if (activeEditor != null && part.getClass().getName().equals(ProfilesView.HTML_EDITOR_CLASS)) {
                        needsRefresh = true;
                        if (ProfilesView.this.profileManager.getProfile(uri) == null && ProfilesView.this.profileManager.getProfile(ProfilesView.staticProtocol + uri) == null) {
                            String[] scripts;
                            String title = activeEditor.getTitle();
                            Profile profile = ProfilesView.this.createDynamicProfile(String.valueOf(title) + ProfilesView.titleLabel, uri);
                            URL url = FileUtils.uriToURL((String)uri);
                            if (url != null && (scripts = ProfilesView.this.addScriptTags(url)).length > 0) {
                                profile.addTransientURIs(scripts);
                            }
                        }
                        if (ProfilesView.this.isLinked) {
                            if (ProfilesView.this.profileManager.getProfile(ProfilesView.staticProtocol + uri) != null) {
                                ProfilesView.this.setCurrentProfile(ProfilesView.staticProtocol + uri);
                            } else {
                                ProfilesView.this.setCurrentProfile(uri);
                            }
                            ProfilesView.this.expandProfile(ProfilesView.this.getCurrentProfile().getURI());
                        }
                    } else if (activeEditor != null && part.getClass().getName().equals(ProfilesView.JS_EDITOR_CLASS)) {
                        needsRefresh = true;
                        if (ProfilesView.this.isLinked) {
                            Profile[] profiles = ProfilesView.this.profileManager.getProfiles();
                            String[] uris = null;
                            String profileUri = "";
                            int i = 0;
                            while (i < profiles.length) {
                                uris = profiles[i].getURIsAsStrings();
                                int j = 0;
                                while (j < uris.length) {
                                    if (uris[j].equals(uri)) {
                                        profileUri = profiles[i].getURI();
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                            if (!profileUri.equals("")) {
                                ProfilesView.this.setCurrentProfile(profileUri);
                            } else {
                                ProfilesView.this.setCurrentProfile(ProfilesView.defaultPath);
                            }
                            Profile currentProfile = ProfilesView.this.getCurrentProfile();
                            if (currentProfile != null) {
                                ProfilesView.this.expandProfile(currentProfile.getURI());
                            }
                        }
                    } else if (part.getClass().getName().indexOf(ProfilesView.GENERIC_EDITOR_CLASS) != -1 && ProfilesView.this.isLinked) {
                        ProfilesView.this.setCurrentProfile(ProfilesView.defaultPath);
                    }
                    if (needsRefresh) {
                        Job updateJob = new Job(Messages.ProfilesView_UpdatingProfileEnvironment){

                            protected IStatus run(IProgressMonitor monitor) {
                                UnifiedEditorsPlugin.getDefault().getProfileManager().onUpdaterThreadUpdate();
                                return Status.OK_STATUS;
                            }
                        };
                        updateJob.setSystem(true);
                        updateJob.schedule();
                    }
                }
            }
        };
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    window.getPartService().addPartListener(ProfilesView.this._partListener);
                }
            }
        });
    }

    public void dispose() {
        if (this.infoLabelFont != null) {
            this.infoLabelFont.dispose();
        }
        if (fErrIcon != null) {
            fErrIcon.dispose();
        }
        JSPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.aptana.ide.js.ui.ProfilesView");
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.accordion = new Accordion();
        this.accordion.createAccordion(this.displayArea);
        this.fileDrawer = this.accordion.addDrawer(Messages.ProfilesView_File_references);
        Composite fda = this.accordion.getDrawerArea(this.fileDrawer);
        GridLayout fdaLayout = new GridLayout(1, true);
        fdaLayout.marginHeight = 0;
        fdaLayout.marginWidth = 0;
        fda.setBackground(fda.getDisplay().getSystemColor(25));
        fda.setLayout((Layout)fdaLayout);
        this.globalDrawer = this.accordion.addDrawer(Messages.ProfilesView_Global_references);
        Composite gda = this.accordion.getDrawerArea(this.globalDrawer);
        GridLayout gdaLayout = new GridLayout(1, true);
        gdaLayout.marginHeight = 0;
        gdaLayout.marginWidth = 0;
        gda.setBackground(gda.getDisplay().getSystemColor(25));
        gda.setLayout((Layout)gdaLayout);
        this.top = new Composite(fda, 0);
        this.top.setBackground(this.top.getDisplay().getSystemColor(25));
        this.topLayout = new StackLayout();
        this.top.setLayout((Layout)this.topLayout);
        GridData topData = new GridData(4, 4, true, true);
        topData.horizontalIndent = 10;
        this.top.setLayoutData((Object)topData);
        this.viewer = this.createTreeViewer(this.top);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new ViewerSorterProvider());
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setInput((Object)this.getViewSite());
        if (this.viewer.getTree().getItemCount() > 0) {
            this.viewer.getTree().showItem(this.viewer.getTree().getItem(0));
        }
        if (this.viewer.getTree().getColumnCount() > 0) {
            this.viewer.getTree().showColumn(this.viewer.getTree().getColumn(0));
        }
        this.infoLabel = new Label(this.top, 0x1000000);
        this.infoLabelFont = new Font((Device)parent.getDisplay(), Messages.ProfilesView_Font_name, 12, 0);
        this.infoLabel.setFont(this.infoLabelFont);
        this.infoLabel.setForeground(parent.getDisplay().getSystemColor(15));
        PreferenceUtils.ignoreForegroundColorPreference((Control)this.infoLabel);
        this.infoLabel.setData("IGNORE_COLOR_KEY", (Object)Boolean.TRUE);
        this.infoLabel.setText(INFO_MESSAGE);
        this.topLayout.topControl = this.infoLabel;
        this.top.layout();
        this.createEnvironmentTable();
        this.bar = new ProgressBar(gda, 65792);
        GridData barData = new GridData(4, 4, true, false);
        barData.exclude = true;
        barData.heightHint = 10;
        this.bar.setLayoutData((Object)barData);
        this.bar.setVisible(false);
        this.bar.setMaximum(5);
        this.bar.setMinimum(0);
        this.bar.setSelection(3);
        this.fillEnvironmentTable();
        this.bindToWorkbench();
        this.initStaticProfiles();
        this.checkForOpenEditor();
        this.addDragDrop();
        this.makeActions();
        this.hookKeyActions(this.viewer.getControl());
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        parent.setBackgroundMode(2);
        PreferenceUtils.registerBackgroundColorPreference((Control)parent, (String)"com.aptana.ide.core.ui.background.color.profilesView");
        PreferenceUtils.registerForegroundColorPreference((Control)parent, (String)"com.aptana.ide.core.ui.foreground.color.profilesView");
        this.viewer.refresh();
        this.accordion.setInitialDrawerOpen(this.fileDrawer);
    }

    private void addDragDrop() {
        DropTarget labeldt = new DropTarget((Control)this.infoLabel, 2);
        labeldt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        labeldt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                ProfilesView.this.handleDrop(event);
            }
        });
        DragSource ds = new DragSource(this.viewer.getControl(), 3);
        ds.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                super.dragStart(event);
                IStructuredSelection selection = (IStructuredSelection)ProfilesView.this.viewer.getSelection();
                for (Object element : selection) {
                    Profile p;
                    if (!(element instanceof Profile) || (p = (Profile)element).getURIs().length != 0) continue;
                    event.doit = false;
                    return;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ProfilesView.this.viewer.getSelection();
                if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    Object[] items = selection.toArray();
                    ArrayList<String> al = new ArrayList<String>();
                    int i = 0;
                    while (i < items.length) {
                        if (items[i] instanceof ProfileURI) {
                            al.add(CoreUIUtils.getPathFromURI((String)((ProfileURI)items[i]).getURI()));
                        } else if (items[i] instanceof Profile) {
                            Profile p = (Profile)items[i];
                            int j = 0;
                            while (j < p.getURIs().length) {
                                ProfileURI object = p.getURIs()[j];
                                al.add(CoreUIUtils.getPathFromURI((String)object.getURI()));
                                ++j;
                            }
                        }
                        ++i;
                    }
                    event.data = al.toArray(new String[0]);
                }
            }
        });
        DropTarget dt = new DropTarget(this.viewer.getControl(), 2);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                ProfilesView.this.handleDrop(event);
            }
        });
    }

    private void changeEnvironment() {
        UIJob job = new UIJob(Messages.ProfilesView_Refreshing_environment_job_title){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ProfilesView.this.bar.setSelection(4);
                TableItem[] items = ProfilesView.this.globalEnvironments.getItems();
                ArrayList<String> environments = new ArrayList<String>();
                ArrayList<String> disabledEnvironments = new ArrayList<String>();
                int i = 0;
                while (i < items.length) {
                    if (items[i].getChecked()) {
                        environments.add(items[i].getText().trim());
                    } else {
                        disabledEnvironments.add(items[i].getText().trim());
                    }
                    ++i;
                }
                JSLanguageEnvironment.setEnabledEnvironments(environments.toArray(new String[0]));
                JSLanguageEnvironment.setDisabledEnvironments(disabledEnvironments.toArray(new String[0]));
                try {
                    JSLanguageEnvironment.resetEnvironment();
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)Messages.ProfilesView_ERR_Setting_global_refs, (String)Messages.ProfilesView_ERR_MSG_error_occurred_setting_global_refs);
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)Messages.ProfilesView_ERR_Setting_global_refs, (Throwable)e);
                }
                ProfilesView.this.bar.setSelection(5);
                GridData data = (GridData)ProfilesView.this.bar.getLayoutData();
                data.exclude = true;
                ProfilesView.this.bar.setVisible(false);
                ProfilesView.this.accordion.getDrawerArea(ProfilesView.this.globalDrawer).layout(true, true);
                ProfilesView.this.globalEnvironments.setEnabled(true);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void createEnvironmentTable() {
        this.globalToolbar = new ToolBar(this.accordion.getDrawerArea(this.globalDrawer), 0x800040);
        this.globalToolbar.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.addGlobal = new ToolItem(this.globalToolbar, 8);
        this.addGlobal.setToolTipText(Messages.ProfilesView_Add_reference);
        this.addGlobal.setImage(JSPlugin.getImage("icons/add_obj.gif"));
        this.addGlobal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog newGlobal = new FileDialog(ProfilesView.this.globalToolbar.getShell(), 4096);
                newGlobal.setFilterExtensions(new String[]{"*.xml;*.js;*.sdoc;*.bin"});
                newGlobal.setText(Messages.ProfilesView_Select_new_global_ref);
                String rc = newGlobal.open();
                if (rc != null) {
                    File file = new File(rc);
                    String name = file.getName();
                    TableItem[] items = ProfilesView.this.globalEnvironments.getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].getText().equals(name)) {
                            CoreUIUtils.showMessage((String)Messages.ProfilesView_ERR_MSG_coudlnt_add_global_ref);
                            return;
                        }
                        ++i;
                    }
                    JSLanguageEnvironment.addUserEnvironment(file.getAbsolutePath());
                    TableItem item = new TableItem(ProfilesView.this.globalEnvironments, 0);
                    item.setText(file.getName());
                    item.setData((Object)file);
                    item.setChecked(true);
                    item.setImage(JSPlugin.getImage("icons/js_file.gif"));
                    ProfilesView.this.changeEnvironment();
                }
            }
        });
        this.removeGlobal = new ToolItem(this.globalToolbar, 8);
        this.removeGlobal.setToolTipText(Messages.ProfilesView_Remove_reference);
        this.removeGlobal.setEnabled(false);
        this.removeGlobal.setImage(JSPlugin.getImage("icons/delete_obj.gif"));
        this.removeGlobal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                if (ProfilesView.this.globalEnvironments.getSelectionCount() == 1 && (item = ProfilesView.this.globalEnvironments.getSelection()[0]).getData() instanceof File) {
                    JSLanguageEnvironment.removeUserEnvironment(((File)item.getData()).getAbsolutePath());
                    item.dispose();
                    ProfilesView.this.changeEnvironment();
                }
                ProfilesView.this.removeGlobal.setEnabled(false);
            }
        });
        this.globalEnvironments = new Table(this.accordion.getDrawerArea(this.globalDrawer), 804);
        this.globalEnvironments.setBackground(this.globalEnvironments.getDisplay().getSystemColor(25));
        this.globalEnvironments.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    ProfilesView.this.globalEnvironments.setEnabled(false);
                    GridData data = (GridData)ProfilesView.this.bar.getLayoutData();
                    data.exclude = false;
                    ProfilesView.this.bar.setSelection(3);
                    ProfilesView.this.bar.setVisible(true);
                    ProfilesView.this.accordion.getDrawerArea(ProfilesView.this.globalDrawer).layout(true, true);
                    ProfilesView.this.changeEnvironment();
                } else if (ProfilesView.this.globalEnvironments.getSelectionCount() == 1) {
                    TableItem item = ProfilesView.this.globalEnvironments.getSelection()[0];
                    ProfilesView.this.removeGlobal.setEnabled(item.getData() instanceof File);
                }
            }
        });
        GridData geData = new GridData(4, 4, true, true);
        geData.horizontalIndent = 10;
        this.globalEnvironments.setLayoutData((Object)geData);
    }

    private void fillEnvironmentTable() {
        String[] userAdded;
        IExtensionPoint extensionPoint;
        ArrayList<IConfigurationElement> elementList = new ArrayList<IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null && (extensionPoint = registry.getExtensionPoint(JSPlugin.ID, "scriptdoc")) != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String agent = element.getAttribute("user-agent");
                    if (agent != null) {
                        elementList.add(element);
                    }
                    ++j;
                }
                ++i;
            }
        }
        Collections.sort(elementList, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement arg0, IConfigurationElement arg1) {
                String agent0 = arg0.getAttribute("user-agent");
                String agent1 = arg1.getAttribute("user-agent");
                return agent0.compareTo(agent1);
            }
        });
        int i = 0;
        while (i < elementList.size()) {
            IConfigurationElement element = (IConfigurationElement)elementList.get(i);
            IExtension declaring = element.getDeclaringExtension();
            String declaringPluginID = declaring.getNamespaceIdentifier();
            Bundle bundle = Platform.getBundle((String)declaringPluginID);
            String agent = element.getAttribute("user-agent");
            String icon = element.getAttribute("icon");
            if (agent != null) {
                File file;
                String iconFile;
                TableItem item = new TableItem(this.globalEnvironments, 0);
                item.setText(agent);
                item.setData((Object)element);
                if (icon != null && (iconFile = ProfilesView.getResolvedFilename(bundle, icon)) != null && (file = new File(iconFile)).exists()) {
                    Image result = null;
                    result = this.images.containsKey(file.getAbsolutePath()) ? this.images.get(file.getAbsolutePath()) : new Image((Device)Display.getDefault(), file.getAbsolutePath());
                    this.images.put(file.getAbsoluteFile(), result);
                    item.setImage(result);
                }
            }
            ++i;
        }
        String[] stringArray = userAdded = JSLanguageEnvironment.getUserAddedJSEnvironments();
        int n = userAdded.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(path);
            if (file.exists()) {
                TableItem item = new TableItem(this.globalEnvironments, 0);
                item.setText(file.getName());
                item.setData((Object)file);
                item.setImage(JSPlugin.getImage("icons/js_file.gif"));
            }
            ++n2;
        }
        this.checkLoadedEnvironments();
    }

    private void checkLoadedEnvironments() {
        String[] environments = JSLanguageEnvironment.getLoadedEnvironments();
        if (this.globalEnvironments != null && !this.globalEnvironments.isDisposed()) {
            TableItem[] items = this.globalEnvironments.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].setChecked(false);
                ++i;
            }
            i = 0;
            while (i < items.length) {
                String label = items[i].getText();
                int j = 0;
                while (j < environments.length) {
                    if (label.equals(environments[j])) {
                        items[i].setChecked(true);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static URL getResolvedURL(Bundle b, String fullPath) {
        URL url = FileLocator.find((Bundle)b, (IPath)new Path(fullPath), null);
        if (url != null) {
            try {
                URL localUrl = FileLocator.toFileURL((URL)url);
                if (localUrl != null) {
                    return localUrl;
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)e.getMessage());
            }
        }
        return null;
    }

    private static String getResolvedFilename(Bundle b, String fullPath) {
        URL url = ProfilesView.getResolvedURL(b, fullPath);
        if (url != null) {
            return url.getFile();
        }
        return null;
    }

    private String getEditorSource(IEditorPart editorPart) {
        String retVal = "";
        if (editorPart instanceof ITextEditor) {
            ITextEditor editor = (ITextEditor)editorPart;
            IDocumentProvider dp = editor.getDocumentProvider();
            IDocument doc = dp.getDocument((Object)editor.getEditorInput());
            retVal = doc.get();
        }
        return retVal;
    }

    public void onContentChanged(FileContextContentEvent evt) {
        IEditorPart sourceEditor = CoreUIUtils.getActiveEditor();
        if (sourceEditor != null && sourceEditor.getClass().getName().equals(HTML_EDITOR_CLASS)) {
            String uri = CoreUIUtils.getURI((IEditorPart)sourceEditor);
            String path = CoreUIUtils.getPathFromURI((String)uri);
            Profile profile = this.profileManager.getProfile(uri);
            if (profile == null) {
                profile = this.profileManager.getProfile(staticProtocol + path);
            }
            String[] set = null;
            set = profile != null ? profile.getURIsIncludingChildrenAsStrings() : new String[]{};
            URL basePath = ProfilesViewHelper.getBasePath(uri);
            if (basePath != null) {
                String[] newSet = ProfilesViewHelper.addScriptTagsFromHTMLSource(basePath, this.getEditorSource(sourceEditor), this.getFileService().getParseState());
                boolean diff = false;
                if (set.length != newSet.length) {
                    diff = true;
                } else {
                    int i = 0;
                    while (i < set.length) {
                        if (!set[i].equals(newSet[i])) {
                            diff = true;
                        }
                        ++i;
                    }
                }
                if (diff && profile != null) {
                    profile.replaceAllURIs(set, newSet);
                }
            }
        }
    }

    protected void handleDrop(DropTargetEvent event) {
        String[] files = (String[])event.data;
        ArrayList<ProfileURI> paths = new ArrayList<ProfileURI>();
        int i = 0;
        while (i < files.length) {
            paths.add(new ProfileURI(CoreUIUtils.getURI((String)files[i])));
            ++i;
        }
        if (paths.size() > 0) {
            Profile profile = null;
            ProfileURI[] uris = paths.toArray(new ProfileURI[0]);
            Widget w = event.item;
            if (w != null) {
                TreeItem item = (TreeItem)w;
                Object element = item.getData();
                if (element instanceof Profile) {
                    profile = (Profile)element;
                } else if (element instanceof ProfileURI) {
                    profile = ((ProfileURI)element).getParent();
                }
            }
            this.onProfilesAddDropEvent(uris, profile);
        }
    }

    private String[] addScriptTags(URL file) {
        URL basePath = ProfilesViewHelper.getBasePath(file);
        if (basePath != null) {
            try {
                String text = FileUtils.readContent((URL)file);
                return ProfilesViewHelper.addScriptTagsFromHTMLSource(basePath, text, this.getFileService().getParseState());
            }
            catch (IOException iOException) {
                return new String[0];
            }
        }
        return new String[0];
    }

    private IUnifiedEditor getUnifiedEditor() {
        ITextEditor editor;
        IEditorPart part = CoreUIUtils.getActiveEditor();
        IUnifiedEditor result = null;
        if (part instanceof ITextEditor && (editor = (ITextEditor)part) instanceof IUnifiedEditor) {
            result = (IUnifiedEditor)editor;
        }
        return result;
    }

    private FileService getFileService() {
        IUnifiedEditor uniEditor = this.getUnifiedEditor();
        FileService result = null;
        if (uniEditor != null) {
            EditorFileContext service = uniEditor.getFileContext();
            if (service instanceof EditorFileContext) {
                service = service.getFileContext();
            }
            if (service instanceof FileService) {
                result = (FileService)service;
            }
        }
        return result;
    }

    private void onProfilesAddDropEvent(ProfileURI[] uris, Profile profile) {
        String string;
        String fileSetName = string = "";
        ArrayList<String> fileList = new ArrayList<String>();
        if (profile == null && (profile = this.profileManager.getProfile(defaultPath)) == null) {
            profile = this.createProfile(defaultTitle, defaultPath);
        }
        int i = 0;
        while (i < uris.length) {
            String filename = uris[i].getURI();
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(filename);
            if (desc != null && desc.getId().equals(HTML_EDITOR_ID)) {
                int lastSlashIndex = filename.lastIndexOf("/");
                String name = lastSlashIndex == -1 ? filename : filename.substring(lastSlashIndex + 1);
                profile.removeURIs(new ProfileURI[]{new ProfileURI(filename)});
                fileSetName = staticProtocol + filename;
                profile = this.createProfile(name, fileSetName);
                String[] scripts = new String[]{};
                try {
                    URI uri = new URI(filename);
                    scripts = this.addScriptTags(uri.toURL());
                }
                catch (URISyntaxException e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ProfilesView_URISyntaxException, (Throwable)e);
                }
                catch (MalformedURLException e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ProfilesView_MalformedURLException, (Throwable)e);
                }
                if (scripts.length == 0) {
                    this.showMessage(Messages.ProfilesView_NoScriptTagFound);
                } else {
                    fileList.addAll(Arrays.asList(scripts));
                }
            } else if (desc != null && desc.getId().equals(JS_EDITOR_ID)) {
                fileSetName = profile.getURI();
                if (fileSetName == null || fileSetName == string) {
                    fileSetName = defaultPath;
                }
                fileList.add(filename);
                URL url = FileUtils.uriToURL((String)filename);
                if (url != null) {
                    String[] sdocs = ProfilesViewHelper.addScriptFromJavaScriptSource(url);
                    fileList.addAll(Arrays.asList(sdocs));
                }
            } else {
                this.showMessage(Messages.ProfilesView_UnsupportedFileType);
            }
            ++i;
        }
        if (fileList.size() > 0) {
            profile.addURIs(fileList.toArray(new String[fileList.size()]));
            if (fileSetName.indexOf(staticProtocol) != 0) {
                boolean result = this.showConfirmMessage(Messages.ProfilesView_ConfirmProfilePersistence);
                String[] urisStrings = profile.getURIsAsStrings();
                if (result) {
                    this.onProfilesMakeStaticEvent(profile, urisStrings);
                }
            }
        }
    }

    private void onProfilesMakeStaticEvent(Profile profile, String[] fileListArray) {
        String profileName = profile.getName();
        String path = profile.getURI();
        boolean wasSelected = false;
        if (path == this.getCurrentProfile().getURI()) {
            wasSelected = true;
        }
        String newPath = staticProtocol + path;
        this.deleteProfile(path);
        if (profileName.indexOf(titleLabel) != -1) {
            profileName = profileName.substring(0, profileName.length() - titleLabel.length());
        }
        Profile newProfile = this.createProfile(profileName, newPath);
        newProfile.addURIs(fileListArray);
        if (wasSelected) {
            this.setCurrentProfile(newProfile.getURI());
        }
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        final TreeViewer treeViewer = new TreeViewer(new Tree(parent, 770));
        GridData tvData = new GridData(4, 4, true, true);
        treeViewer.getTree().setLayoutData((Object)tvData);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] paths = ((ITreeSelection)treeViewer.getSelection()).toArray();
                ProfilesView.this.actionMakeCurrent.setEnabled(paths.length == 1 && paths[0] instanceof Profile);
                int i = 0;
                while (i < paths.length) {
                    if (paths[i] instanceof Profile) {
                        ProfilesView.this.actionMoveDown.setEnabled(false);
                        ProfilesView.this.actionMoveUp.setEnabled(false);
                        return;
                    }
                    ++i;
                }
                ProfilesView.this.actionMoveDown.setEnabled(true);
                ProfilesView.this.actionMoveUp.setEnabled(true);
            }
        });
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                StyledText label = (StyledText)event.widget;
                Shell shell = (Shell)label.getData("_SHELL");
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData("_TREEITEM");
                        treeViewer.getTree().setSelection(new TreeItem[]{(TreeItem)e.item});
                        treeViewer.getTree().notifyListeners(13, e);
                    }
                    case 7: {
                        shell.dispose();
                        break;
                    }
                }
            }
        };
        final Shell shell = this.getSite().getShell();
        Listener tableListener = new Listener(){
            UnifiedInformationControl info = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.info == null || this.info.getShell() == null) break;
                        this.info.getShell().dispose();
                        this.info = null;
                        break;
                    }
                    case 32: {
                        TreeItem item = treeViewer.getTree().getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.info != null && this.info.getShell() != null && !this.info.getShell().isDisposed()) {
                            this.info.getShell().dispose();
                        }
                        this.info = new UnifiedInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
                        this.info.getStyledTextWidget().setData("_TREEITEM", (Object)item);
                        this.info.getStyledTextWidget().setData("_SHELL", (Object)this.info.getShell());
                        this.info.getStyledTextWidget().addListener(7, labelListener);
                        this.info.getStyledTextWidget().addListener(3, labelListener);
                        Object data = item.getData();
                        String txt = null;
                        if (data instanceof Profile) {
                            Profile profile = (Profile)data;
                            txt = StringUtils.format((String)Messages.ProfilesView_ProfileItems, (Object[])new Object[]{profile.getName(), Integer.toString(profile.getURIs().length)});
                        } else if (data instanceof ProfileURI) {
                            ProfileURI uri = (ProfileURI)data;
                            txt = StringUtils.urlDecodeFilename((char[])uri.getURI().toCharArray());
                        }
                        if (txt == null) break;
                        this.info.setSizeConstraints(300, 500);
                        this.info.setInformation(txt);
                        StyledText styledText = this.info.getStyledTextWidget();
                        GC gc = new GC((Drawable)styledText);
                        int width = gc.getFontMetrics().getAverageCharWidth();
                        width = (txt.length() + 2) * width;
                        Rectangle rect = item.getBounds(0);
                        Point pt = treeViewer.getTree().toDisplay(20 + rect.x, rect.y);
                        this.info.setSize(width, 0);
                        this.info.setLocation(pt);
                        this.info.setVisible(true);
                    }
                }
            }
        };
        treeViewer.getTree().addListener(12, tableListener);
        treeViewer.getTree().addListener(1, tableListener);
        treeViewer.getTree().addListener(5, tableListener);
        treeViewer.getTree().addListener(32, tableListener);
        return treeViewer;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = ProfilesView.this.viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                ProfilesView.this.fillContextMenu(manager, firstElement);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager, Object element) {
        if (element instanceof Profile) {
            Profile p = (Profile)element;
            manager.add((IAction)this.actionMakeCurrent);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionAdd);
            manager.add((IAction)this.actionAddCurrentFile);
            if (!p.isDynamic()) {
                manager.add((IAction)this.actionDelete);
            } else {
                manager.add((IAction)this.actionMakeStatic);
            }
        } else if (element instanceof ProfileURI && !(element instanceof TransientProfileURI)) {
            ProfileURI path = (ProfileURI)element;
            manager.add((IAction)this.actionAdd);
            if (!path.getParent().isDynamic()) {
                manager.add((IAction)this.actionDelete);
            }
            manager.add((IAction)this.actionMoveUp);
            manager.add((IAction)this.actionMoveDown);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
        manager.add((IAction)this.actionMakeCurrent);
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionAddProfile);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionMoveUp);
        manager.add((IAction)this.actionMoveDown);
        manager.add((IAction)this.actionLinkWithEditor);
    }

    private void makeActions() {
        this.createLinkWithEditorAction();
        this.createMakeCurrentAction();
        this.createRefreshAction();
        this.createMakeStaticAction();
        this.createAddCurrentFileAction();
        this.createAddProfileAction();
        this.createAddAction();
        this.createDeleteAction();
        this.createMoveUpAction();
        this.createMoveDownAction();
        this.createDoubleClickAction();
    }

    private void createDoubleClickAction() {
        this.actionDoubleClick = new Action(){

            public void run() {
                ISelection selection = ProfilesView.this.viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof Profile) {
                    File f;
                    String data = ((Profile)firstElement).getURI();
                    if (data == null || data.equals(ProfilesView.defaultPath) || data.startsWith(ProfilesView.staticProtocol) && data.indexOf(".") == -1) {
                        ProfilesView.this.toggleElementState(firstElement);
                        return;
                    }
                    if (data.startsWith(ProfilesView.staticProtocol)) {
                        data = data.substring(ProfilesView.staticProtocol.length());
                    }
                    if ((f = FileUtils.openURL((String)data)) != null && f.exists()) {
                        WorkbenchHelper.openFile((File)f, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    } else {
                        ProfilesView.this.showMessage(Messages.ProfilesView_FileNoLongerAvailable);
                    }
                    return;
                }
                if (firstElement instanceof ProfileURI) {
                    ProfileURI uri = (ProfileURI)firstElement;
                    File f = FileUtils.openURL((String)uri.getURI());
                    if (f != null && f.exists()) {
                        WorkbenchHelper.openFile((File)f, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        ProfilesViewEvent e = new ProfilesViewEvent(0);
                        e.setProfile(uri.getParent());
                        if (ProfilesView.this.isLinked) {
                            ProfilesView.this.setCurrentProfile(uri.getParent().getURI());
                        }
                    } else {
                        ProfilesView.this.showMessage(Messages.ProfilesView_FileNoLongerAvailable);
                    }
                }
            }
        };
    }

    private void createMoveDownAction() {
        this.actionMoveDown = new Action(){

            public void run() {
                ProfilesView.this.moveFilesDown(ProfilesView.this.viewer.getSelection());
            }
        };
        this.actionMoveDown.setText(Messages.ProfilesView_MoveDown);
        this.actionMoveDown.setToolTipText(Messages.ProfilesView_MoveDown);
        this.actionMoveDown.setImageDescriptor(fDownIconDescriptor);
        this.actionMoveDown.setEnabled(false);
    }

    private void createMoveUpAction() {
        this.actionMoveUp = new Action(){

            public void run() {
                ProfilesView.this.moveFilesUp(ProfilesView.this.viewer.getSelection());
            }
        };
        this.actionMoveUp.setText(Messages.ProfilesView_MoveUp);
        this.actionMoveUp.setToolTipText(Messages.ProfilesView_MoveUp);
        this.actionMoveUp.setImageDescriptor(fUpIconDescriptor);
        this.actionMoveUp.setEnabled(false);
    }

    private void createDeleteAction() {
        this.actionDelete = new Action(){

            public void run() {
                ProfilesView.this.removeFiles(ProfilesView.this.viewer.getSelection());
            }
        };
        this.actionDelete.setText(Messages.ProfilesView_RemoveFile);
        this.actionDelete.setToolTipText(Messages.ProfilesView_RemoveFile);
        this.actionDelete.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    private void createAddAction() {
        this.actionAdd = new Action(){

            public void run() {
                Object element;
                ISelection selection = ProfilesView.this.viewer.getSelection();
                if (selection != null && (element = ((IStructuredSelection)selection).getFirstElement()) != null) {
                    Profile profile = null;
                    if (element instanceof Profile) {
                        profile = (Profile)element;
                    } else if (element instanceof ProfileURI) {
                        profile = ((ProfileURI)element).getParent();
                    } else {
                        return;
                    }
                    FileDialog fileDialog = new FileDialog(ProfilesView.this.viewer.getControl().getShell(), 2);
                    fileDialog.setFilterExtensions(FILTER_EXTENSIONS);
                    fileDialog.setFilterNames(FILTER_NAMES);
                    String text = fileDialog.open();
                    if (text != null) {
                        Path basePath = new Path(fileDialog.getFilterPath());
                        String[] fileNames = fileDialog.getFileNames();
                        String[] uris = new String[fileNames.length];
                        int i = 0;
                        while (i < uris.length) {
                            uris[i] = CoreUIUtils.getURI((IPath)basePath.append(fileNames[i]));
                            ++i;
                        }
                        profile.addURIs(uris);
                    }
                }
            }
        };
        this.actionAdd.setText(Messages.ProfilesView_AddFilesDotDotDot);
        this.actionAdd.setToolTipText(Messages.ProfilesView_AddFilesToProfile);
        this.actionAdd.setImageDescriptor(fAddFileIconDescriptor);
    }

    private void createAddProfileAction() {
        this.actionAddProfile = new Action(){

            public void run() {
                String name;
                InputDialog input = new InputDialog(ProfilesView.this.getSite().getShell(), Messages.ProfilesView_NewProfileName, Messages.ProfilesView_EnterNewProfileName, "", null);
                if (input.open() == 0 && input.getValue().length() > 0 && (name = input.getValue()).trim().length() > 0) {
                    ProfilesView.this.addProfile(new Profile(name, ProfilesView.staticProtocol + name));
                }
            }
        };
        this.actionAddProfile.setText(Messages.ProfilesView_AddProfileDotDotDot);
        this.actionAddProfile.setToolTipText(Messages.ProfilesView_AddProfile);
        this.actionAddProfile.setImageDescriptor(fAddProfileIconDescriptor);
    }

    private void createAddCurrentFileAction() {
        this.actionAddCurrentFile = new Action(){

            public void run() {
                ISelection selection = ProfilesView.this.viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof Profile) {
                    ProfilesView.this.handleAddCurrentFileAction((Profile)firstElement);
                }
            }
        };
        this.actionAddCurrentFile.setText(Messages.ProfilesView_AddCurrentFile);
        this.actionAddCurrentFile.setToolTipText(Messages.ProfilesView_AddFileToProfile);
    }

    private void handleAddCurrentFileAction(Profile profile) {
        String uri = CoreUIUtils.getActiveEditorURI();
        String path = CoreUIUtils.getPathFromURI((String)uri);
        if (uri == null) {
            this.showMessage(Messages.ProfilesView_NoOpenEditor);
            return;
        }
        if (!new File(path).exists()) {
            this.showMessage(Messages.ProfilesView_SaveBeforeAdd);
            return;
        }
        if (uri.toLowerCase().indexOf(Messages.ProfilesView_JsExtension) == -1) {
            this.showMessage(Messages.ProfilesView_UnsupportedFileType);
            return;
        }
        profile.addURIs(new String[]{uri});
    }

    private void createMakeStaticAction() {
        this.actionMakeStatic = new Action(){

            public void run() {
                ISelection selection = ProfilesView.this.viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof Profile) {
                    Profile profile = (Profile)firstElement;
                    String profileName = profile.getName();
                    String path = profile.getURI();
                    boolean wasSelected = false;
                    if (path == ProfilesView.this.getCurrentProfile().getURI()) {
                        wasSelected = true;
                    }
                    String newPath = ProfilesView.staticProtocol + path;
                    String[] uris = profile.getURIsAsStrings();
                    ProfilesView.this.deleteProfile(path);
                    if (profileName.indexOf(ProfilesView.titleLabel) != -1) {
                        profileName = profileName.substring(0, profileName.length() - ProfilesView.titleLabel.length());
                    }
                    Profile newProfile = ProfilesView.this.createProfile(profileName, newPath);
                    newProfile.addURIs(uris);
                    if (wasSelected) {
                        ProfilesView.this.setCurrentProfile(newPath);
                    }
                }
            }
        };
        this.actionMakeStatic.setText(Messages.ProfilesView_MakeProfilePermanent);
        this.actionMakeStatic.setToolTipText(Messages.ProfilesView_MakeThisProfilePermanent);
    }

    private void createRefreshAction() {
        this.actionRefresh = new Action(){

            public void run() {
                ProfilesView.this.profileManager.refreshEnvironment();
            }
        };
        this.actionRefresh.setText(Messages.ProfilesView_RefreshEnvironment);
        this.actionRefresh.setToolTipText(Messages.ProfilesView_RefreshEnvironment);
        this.actionRefresh.setImageDescriptor(fRefreshIconDescriptor);
    }

    private void createLinkWithEditorAction() {
        this.actionLinkWithEditor = new CheckboxAction(){

            public void run() {
                if (this.isChecked()) {
                    ProfilesView.this.isLinked = true;
                    ProfilesView.this.setCurrentProfile(ProfilesView.defaultPath);
                    ProfilesView.this.checkForOpenEditor();
                } else {
                    ProfilesView.this.isLinked = false;
                    ProfilesView.this.checkForOpenEditor();
                }
            }
        };
        this.actionLinkWithEditor.setText(Messages.ProfilesView_LinkWithEditor);
        this.actionLinkWithEditor.setToolTipText(Messages.ProfilesView_LinkWithEditor);
        this.actionLinkWithEditor.setImageDescriptor(fLinkWithEditorIconDescriptor);
        this.actionLinkWithEditor.setChecked(true);
    }

    private void initStaticProfiles() {
        Profile[] profiles = this.getProfiles();
        int i = 0;
        while (i < profiles.length) {
            String path = profiles[i].getURI();
            if (path.indexOf(staticProtocol) == 0) {
                this.setCurrentProfile(path);
                this.expandProfile(path);
            }
            ++i;
        }
    }

    private void checkForOpenEditor() {
        IEditorPart activeEditor = CoreUIUtils.getActiveEditor();
        String uri = CoreUIUtils.getURI((IEditorPart)activeEditor);
        if ("".equals(uri)) {
            return;
        }
        String path = CoreUIUtils.getPathFromURI((String)uri);
        if (path == null) {
            return;
        }
        if (!new File(path).exists()) {
            return;
        }
        this._partListener.partActivated((IWorkbenchPart)activeEditor);
    }

    private void createMakeCurrentAction() {
        this.actionMakeCurrent = new Action(){

            public void run() {
                ISelection selection = ProfilesView.this.viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof Profile) {
                    ProfilesView.this.actionLinkWithEditor.setChecked(false);
                    ProfilesView.this.actionLinkWithEditor.run();
                    ProfilesView.this.setCurrentProfile(((Profile)firstElement).getURI());
                }
            }
        };
        this.actionMakeCurrent.setText(Messages.ProfilesView_MakeCurrentProfile);
        this.actionMakeCurrent.setImageDescriptor(fMakeCurrentProfileIconDescriptor);
        this.actionMakeCurrent.setToolTipText(Messages.ProfilesView_MakeProfileCurrentProfile);
        this.actionMakeCurrent.setEnabled(false);
    }

    private void toggleElementState(Object element) {
        boolean state = this.viewer.getExpandedState(element);
        if (state) {
            this.viewer.setExpandedState(element, false);
        } else {
            this.viewer.setExpandedState(element, true);
        }
    }

    private void removeFiles(ISelection selection) {
        block8: {
            ProfileURI[] uris;
            Object o;
            block7: {
                if (!(selection instanceof StructuredSelection)) {
                    return;
                }
                o = ((StructuredSelection)selection).getFirstElement();
                if (o instanceof TransientProfileURI) {
                    this.showMessage(Messages.ProfilesView_CannotDeleteAutomaticFile);
                    return;
                }
                if (o instanceof Profile && ((Profile)o).getURI().equals(defaultPath)) {
                    this.showMessage(Messages.ProfilesView_CannotDeleteDefaultProfile);
                    return;
                }
                if (!(o instanceof Profile)) break block7;
                Profile p = (Profile)o;
                String profilePath = p.getURI();
                if (profilePath == null) break block8;
                Profile profile = UnifiedEditorsPlugin.getDefault().getProfileManager().getProfile(profilePath);
                Profile currentProfile = UnifiedEditorsPlugin.getDefault().getProfileManager().getCurrentProfile();
                if (profile == null) break block8;
                if (currentProfile.getURI() == profile.getURI()) {
                    UnifiedEditorsPlugin.getDefault().getProfileManager().setCurrentProfile(defaultPath);
                }
                profile.removeTransientURIs(new String[]{profilePath});
                this.deleteProfile(profilePath);
                break block8;
            }
            if (o instanceof ProfileURI && (uris = this.convertSelectionToProfileURIs((StructuredSelection)selection)).length > 0) {
                int i = 0;
                while (i < uris.length) {
                    Profile profile = uris[i].getParent();
                    if (profile != null) {
                        ProfileURI[] files = new ProfileURI[]{uris[i]};
                        profile.removeURIs(files);
                    }
                    ++i;
                }
            }
        }
    }

    private void deleteProfile(String profilePath) {
        UnifiedEditorsPlugin.getDefault().getProfileManager().removeProfile(profilePath);
    }

    private void moveFilesUp(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        Object o = ((StructuredSelection)selection).getFirstElement();
        if (o instanceof TransientProfileURI) {
            this.showMessage(Messages.ProfilesView_CannotMoveAutoFile);
            return;
        }
        ProfileURI[] uris = this.convertSelectionToProfileURIs((StructuredSelection)selection);
        if (uris.length > 0) {
            int i = 0;
            while (i < uris.length) {
                Profile profile = uris[i].getParent();
                if (profile != null) {
                    ProfileURI[] files = new ProfileURI[]{uris[i]};
                    profile.moveURIsUp(files);
                }
                ++i;
            }
        }
    }

    private void moveFilesDown(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        Object o = ((StructuredSelection)selection).getFirstElement();
        if (o instanceof TransientProfileURI) {
            this.showMessage(Messages.ProfilesView_CannotMoveAutoFile);
            return;
        }
        ProfileURI[] uris = this.convertSelectionToProfileURIs((StructuredSelection)selection);
        if (uris.length > 0) {
            Collections.reverse(Arrays.asList(uris));
            int i = 0;
            while (i < uris.length) {
                Profile profile = uris[i].getParent();
                if (profile != null) {
                    ProfileURI[] files = new ProfileURI[]{uris[i]};
                    profile.moveURIsDown(files);
                }
                ++i;
            }
        }
    }

    public ProfileURI[] convertSelectionToProfileURIs(StructuredSelection selection) {
        ArrayList<ProfileURI> paths = new ArrayList<ProfileURI>();
        for (Object o : selection) {
            if (o instanceof ProfileURI) {
                ProfileURI uri = (ProfileURI)o;
                paths.add(uri);
                continue;
            }
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.ProfilesView_PathNotProfileURI, (String)o.getClass().toString()));
        }
        return paths.toArray(new ProfileURI[0]);
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)Messages.ProfilesView_FileExplorer, (String)message);
    }

    private boolean showConfirmMessage(String message) {
        return MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)Messages.ProfilesView_FileExplorer, (String)message);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProfilesView.this.actionDoubleClick.run();
            }
        });
    }

    private void hookKeyActions(Control control) {
        control.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    ProfilesView.this.removeFiles(ProfilesView.this.viewer.getSelection());
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private static ImageDescriptor getImageDescriptor(String imageFilePath) {
        ImageDescriptor imageDescriptor = UnifiedEditorsPlugin.getImageDescriptor((String)imageFilePath);
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }

    public void expandAll() {
        this.viewer.expandAll();
    }

    public void expandProfile(String profilePath) {
        if (this.viewer == null || this.viewer.getTree().isDisposed()) {
            return;
        }
        TreeItem[] treeItems = this.viewer.getTree().getItems();
        int i = 0;
        while (i < treeItems.length) {
            Profile p;
            String path;
            Object o = treeItems[i].getData();
            if (o instanceof Profile && (path = (p = (Profile)o).getURI()).equals(profilePath)) {
                this.viewer.setExpandedState(o, true);
                return;
            }
            ++i;
        }
    }

    public boolean getLinkWithEditorState() {
        return this.actionLinkWithEditor.isChecked();
    }

    public boolean getIsLinked() {
        return this.getLinkWithEditorState();
    }

    public void addProfile(Object profile) {
        if (profile instanceof Profile) {
            UnifiedEditorsPlugin.getDefault().getProfileManager().addProfile((Profile)profile);
        }
    }

    public Profile createProfile(String name, String path) {
        return UnifiedEditorsPlugin.getDefault().getProfileManager().createProfile(name, path, false);
    }

    public Profile createDynamicProfile(String name, String path) {
        return UnifiedEditorsPlugin.getDefault().getProfileManager().createProfile(name, path, true);
    }

    public void removeProfile(String name) {
        UnifiedEditorsPlugin.getDefault().getProfileManager().removeProfile(name);
    }

    public void setCurrentProfile(String name) {
        UnifiedEditorsPlugin.getDefault().getProfileManager().setCurrentProfile(name);
    }

    public Profile getCurrentProfile() {
        return UnifiedEditorsPlugin.getDefault().getProfileManager().getCurrentProfile();
    }

    public String[] getProfilePaths() {
        return UnifiedEditorsPlugin.getDefault().getProfileManager().getProfilePaths();
    }

    public Profile[] getProfiles() {
        return UnifiedEditorsPlugin.getDefault().getProfileManager().getProfiles();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event != null && (event.getProperty().equals("com.aptana.ide.editor.js.LOADED_ENVIRONMENTS") || event.getProperty().equals("com.aptana.ide.editor.js.DISABLED_ENVIRONMENTS"))) {
            this.checkLoadedEnvironments();
        }
    }

    protected class CheckboxAction
    extends Action {
        public CheckboxAction() {
            super(Messages.ProfilesView_Sort, 2);
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (!(parent instanceof IPath)) {
                boolean showProfiles = false;
                Object[] profiles = ProfilesView.this.profileManager.getProfiles();
                if (profiles != null && profiles.length > 0) {
                    showProfiles = true;
                }
                if (showProfiles && profiles.length == 1 && profiles[0].getName().equals(ProfilesView.defaultTitle) && profiles[0].getURIs().length == 0) {
                    showProfiles = false;
                }
                if (showProfiles) {
                    if (ProfilesView.this.topLayout != null && ProfilesView.this.infoLabel != null && ProfilesView.this.top != null && ((ProfilesView)ProfilesView.this).topLayout.topControl == ProfilesView.this.infoLabel) {
                        ((ProfilesView)ProfilesView.this).topLayout.topControl = ProfilesView.this.viewer.getControl();
                        ProfilesView.this.top.layout();
                    }
                    return profiles;
                }
            }
            if (ProfilesView.this.topLayout != null && ProfilesView.this.infoLabel != null && ProfilesView.this.top != null) {
                ((ProfilesView)ProfilesView.this).topLayout.topControl = ProfilesView.this.infoLabel;
                ProfilesView.this.top.layout();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Profile) {
                Profile profile = (Profile)parentElement;
                Object[] uris = profile.getURIs();
                return uris;
            }
            if (parentElement instanceof ProfileURI) {
                ProfileURI path = (ProfileURI)parentElement;
                return path.getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ProfileURI) {
                return ((ProfileURI)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Profile) {
                Profile profile = (Profile)element;
                boolean children = profile.getURIs().length > 0;
                return children;
            }
            if (element instanceof ProfileURI) {
                ProfileURI path = (ProfileURI)element;
                return path.getChildren().length > 0;
            }
            return false;
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Profile) {
                Profile profile = (Profile)element;
                return profile.getName();
            }
            if (element instanceof ProfileURI) {
                ProfileURI profileURI = (ProfileURI)element;
                String uri = StringUtils.urlDecodeFilename((char[])profileURI.getURI().toCharArray());
                int lastSlashIndex = uri.lastIndexOf("/");
                if (lastSlashIndex != -1) {
                    return uri.substring(lastSlashIndex + 1);
                }
                return uri;
            }
            return null;
        }

        public Image getImage(Object obj) {
            if (obj instanceof Profile) {
                Profile p = (Profile)obj;
                if (ProfilesView.this.profileManager.isCurrentProfile(p)) {
                    if (p.isDynamic()) {
                        return fProfileCurrentDynamicIcon;
                    }
                    return fProfileCurrentIcon;
                }
                if (p.isDynamic()) {
                    return fProfileDynamicIcon;
                }
                return fProfileIcon;
            }
            if (obj instanceof ProfileURI) {
                ProfileURI uri = (ProfileURI)obj;
                URL url = FileUtils.uriToURL((String)uri.getURI());
                if (url != null && ProfilesViewHelper.isValidURL(url)) {
                    if (obj instanceof TransientProfileURI) {
                        return fProfileFileDynamicIcon;
                    }
                    return fProfileFileIcon;
                }
                return fErrIcon;
            }
            return null;
        }
    }

    class ViewerSorterProvider
    extends ViewerSorter {
        ViewerSorterProvider() {
        }

        public int category(Object element) {
            if (element instanceof Profile && ((Profile)element).getName().equals(ProfilesView.defaultTitle)) {
                return 0;
            }
            return 1;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            return 0;
        }
    }
}

