/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.validator;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.Messages;
import com.aptana.ide.editor.js.validator.JSValidationUtils;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.errors.FileError;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.UnifiedErrorReporter;
import com.aptana.ide.editors.validator.ValidatorBase;
import com.aptana.ide.lexer.Range;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Parser;

public class MozillaJsValidator
extends ValidatorBase {
    private static String LINE_DELIM = System.getProperty("line.separator", "\r\n");

    public IFileError[] parseForErrors(String path, String source, IFileSourceProvider sourceProvider, boolean collectErrors, boolean collectWarnings, boolean collectInfos) {
        ArrayList<Range> ranges;
        UnifiedErrorReporter reporter;
        block17: {
            IFileError[] err = new IFileError[]{};
            reporter = new UnifiedErrorReporter(sourceProvider);
            reporter.addErrors(err);
            Context cx = Context.enter();
            ranges = new ArrayList<Range>();
            try {
                try {
                    source = JSValidationUtils.filterPIInstructions(source, ranges);
                    source = source.replace("=<", "= ");
                    cx.setErrorReporter((ErrorReporter)reporter);
                    if (collectErrors) {
                        CompilerEnvirons compilerEnv = new CompilerEnvirons();
                        compilerEnv.initFromContext(cx);
                        Parser p = new Parser(compilerEnv, (ErrorReporter)reporter);
                        try {
                            p.parse(source, path, 1);
                        }
                        catch (EvaluatorException evaluatorException) {}
                    }
                }
                catch (Exception e) {
                    IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)Messages.JSErrorManager_ParseForErrorsFailed, (Throwable)e);
                    Context.exit();
                    break block17;
                }
            }
            catch (Throwable throwable) {
                Context.exit();
                throw throwable;
            }
            Context.exit();
        }
        IFileError[] errors = JSValidationUtils.filterErrors(source, reporter, ranges);
        if (errors != null) {
            int i = 0;
            while (i < errors.length) {
                block18: {
                    try {
                        IFileError currError = errors[i];
                        int offset = currError.getOffset();
                        if (offset < source.length() && (offset > source.length() || LINE_DELIM.indexOf(source.charAt(offset)) == -1) || !(currError instanceof FileError)) break block18;
                        if (offset > source.length()) {
                            offset = source.length();
                        }
                        int j = offset = offset == source.length() ? offset - 1 : offset;
                        while (j >= 0) {
                            if (LINE_DELIM.indexOf(source.charAt(j)) == -1) {
                                ((FileError)currError).setOffset(j);
                                ((FileError)currError).setLineNumber(sourceProvider.getLineOfOffset(currError.getOffset()) + 1);
                                break;
                            }
                            --j;
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)"Error running JavaScript lint script", (Throwable)e);
                    }
                }
                ++i;
            }
        }
        try {
            return errors;
        }
        catch (Throwable th) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"Novalidate filtering failed", (Throwable)th);
            return errors;
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        if (PluginUtils.isPluginLoaded((Plugin)JSPlugin.getDefault())) {
            return JSPlugin.getDefault().getPreferenceStore();
        }
        return null;
    }
}

