/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.runtime;

import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.Location;
import com.aptana.ide.editor.js.runtime.Messages;
import com.aptana.ide.editor.js.runtime.ObjectBase;
import com.aptana.ide.editor.js.runtime.OrderedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OrderedObjectCollection {
    private List<OrderedObject> _items;

    public OrderedObject get(int index) {
        OrderedObject result = null;
        if (this._items != null) {
            result = this._items.get(index);
        }
        return result;
    }

    public int size() {
        int result = 0;
        if (this._items != null) {
            result = this._items.size();
        }
        return result;
    }

    public void add(IObject object, int fileIndex) {
        int offset;
        Location key;
        int position;
        if (object == null) {
            throw new NullPointerException(Messages.OrderedObjectCollection_ObjectMustBeDefined);
        }
        if (this._items == null) {
            this._items = new ArrayList<OrderedObject>();
        }
        if ((position = Collections.binarySearch(this._items, key = new Location(fileIndex, offset = object.getStartingOffset()))) >= 0) {
            throw new IllegalStateException(Messages.OrderedObjectCollection_CanNotOverwriteExistingObject);
        }
        position = -(position + 1);
        this._items.add(position, new OrderedObject(object, fileIndex));
    }

    public IObject getFloorObject(int fileIndex, int offset) {
        int size = this.size();
        IObject result = ObjectBase.UNDEFINED;
        if (size > 0) {
            Location key = new Location(fileIndex, offset);
            int position = Collections.binarySearch(this._items, key);
            if (position < 0) {
                position = -(position + 1) - 1;
            }
            if (position >= 0 && position < size) {
                OrderedObject item = this._items.get(position);
                result = item.object;
            }
        }
        return result;
    }

    public int getFloorFileIndex(int fileIndex, int offset) {
        int size = this.size();
        int result = -1;
        if (size > 0) {
            Location key = new Location(fileIndex, offset);
            int position = Collections.binarySearch(this._items, key);
            if (position < 0) {
                position = -(position + 1) - 1;
            }
            if (position >= 0 && position < size) {
                OrderedObject item = this._items.get(position);
                result = item.fileIndex;
            }
        }
        return result;
    }

    public void remove(int index) {
        this._items.remove(index);
    }

    public void remove(int fileIndex, int offset) {
        int position;
        if (this._items != null) {
            Location key = new Location(fileIndex, offset);
            position = Collections.binarySearch(this._items, key);
            if (position < 0) {
                throw new IllegalStateException(Messages.OrderedObjectCollection_NoObjectExists);
            }
        } else {
            throw new IllegalStateException(Messages.OrderedObjectCollection_CanNotRemoveFromEmpty);
        }
        this._items.remove(position);
    }
}

