/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.parsing;

import com.aptana.ide.editor.js.lexing.JSTokenTypes;
import com.aptana.ide.editor.js.parsing.JSMessages;
import com.aptana.ide.editor.js.parsing.JSParserBase;
import com.aptana.ide.editor.js.parsing.nodes.JSNaryNode;
import com.aptana.ide.editor.js.parsing.nodes.JSParseNode;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.IParseNodeFactory;
import java.text.ParseException;
import java.util.Arrays;

public class JSParser
extends JSParserBase {
    private String _expressionErrorKey;
    private static final int[] additiveExpressionSet = new int[]{37, 45};
    private static final int[] assignmentOperatorSet = new int[]{57, 73, 40, 81, 41, 49, 79, 56, 72, 65, 48, 64};
    private static final int[] commentSet = new int[]{2, 91};
    private static final int[] caseBlockSet = new int[]{42, 10, 13};
    private static final int[] equalityExpressionSet = new int[]{44, 52, 60, 68};
    private static final int[] expressionStatementSet = new int[]{51, 22};
    private static final int[] multiplicativeExpressionSet = new int[]{53, 80, 61};
    private static final int[] postfixExpressionSet = new int[]{69, 76};
    private static final int[] postfixMemberExpressionSet = new int[]{35, 66, 50};
    private static final int[] propertyNameSet = new int[]{8, 87, 88};
    private static final int[] relationalExpressionSet = new int[]{59, 67, 75, 36, 19, 18};
    private static final int[] returnSet;
    private static final int[] shiftExpressionSet;
    private static final int[] stopSet;
    private static final int[] unaryExpressionSet;
    private static final int[] unclosedCommentSet;
    private static final int[] referenceableSet;
    private Lexeme prevLexeme;
    private static final String DEFAULT_GROUP = "default";
    private static final String REGEX_GROUP = "regex";
    private static final String ADDITION_GROUP = "addition";
    public static final String DOCUMENTATION_DELIMITER_GROUP = "documentation-delimiter";
    public static final String LINE_DELIMITER_GROUP = "line-delimiter";

    static {
        int[] nArray = new int[3];
        nArray[0] = 43;
        nArray[1] = 42;
        returnSet = nArray;
        shiftExpressionSet = new int[]{38, 46, 54};
        stopSet = new int[]{43, 42};
        unaryExpressionSet = new int[]{14, 39, 45, 76, 37, 69, 47, 29, 31};
        unclosedCommentSet = new int[]{6, 7};
        referenceableSet = new int[]{13, 14, 64};
        Arrays.sort(additiveExpressionSet);
        Arrays.sort(assignmentOperatorSet);
        Arrays.sort(caseBlockSet);
        Arrays.sort(commentSet);
        Arrays.sort(equalityExpressionSet);
        Arrays.sort(expressionStatementSet);
        Arrays.sort(multiplicativeExpressionSet);
        Arrays.sort(postfixExpressionSet);
        Arrays.sort(postfixMemberExpressionSet);
        Arrays.sort(propertyNameSet);
        Arrays.sort(relationalExpressionSet);
        Arrays.sort(returnSet);
        Arrays.sort(shiftExpressionSet);
        Arrays.sort(stopSet);
        Arrays.sort(unaryExpressionSet);
        Arrays.sort(unclosedCommentSet);
        Arrays.sort(referenceableSet);
    }

    public JSParser() throws ParserInitializationException {
        this("text/javascript");
    }

    public JSParser(String mimeType) throws ParserInitializationException {
        super(mimeType);
    }

    private JSParseNode createNode(int type, Lexeme startingLexeme) {
        IParseNodeFactory factory = this.getParseNodeFactory();
        JSParseNode result = null;
        result = factory != null ? (JSParseNode)factory.createParseNode(type, startingLexeme) : new JSParseNode(type, startingLexeme);
        return result;
    }

    private void handleOptionalSemicolon(JSParseNode node) throws LexerException, ParseException {
        switch (this.currentLexeme.typeIndex) {
            case 43: {
                node.setIncludesSemicolon(true);
                this.advance();
                break;
            }
            case 0: 
            case 42: {
                break;
            }
            default: {
                if (this.currentLexeme == EOS || this.currentLexeme.isAfterEOL()) break;
                this.throwParseError(JSMessages.getString("error.semicolon"));
            }
        }
    }

    public synchronized void parseAll(IParseNode parentNode) throws LexerException, ParseException {
        IParseNode rootNode = this.getParseRootNode(parentNode, JSNaryNode.class);
        ILexer lexer = this.getLexer();
        lexer.setLanguageAndGroup(this.getLanguage(), DEFAULT_GROUP);
        this.advance();
        while (!this.isEOS()) {
            JSParseNode result = this.parseSourceElement();
            if (rootNode == null || result == null) continue;
            rootNode.appendChild((IParseNode)result);
        }
    }

    private JSParseNode parseAdditiveExpression() throws ParseException, LexerException {
        char startChar;
        JSParseNode result = this.parseMultiplicativeExpression();
        ILexer lexer = this.getLexer();
        if (this.isType(87) && ((startChar = lexer.getCharacterAt(this.currentLexeme.offset)) == '-' || startChar == '+')) {
            this.rescan(ADDITION_GROUP);
        }
        while (this.inSet(additiveExpressionSet)) {
            char startChar2;
            JSParseNode lhs = result;
            int operatorType = this.currentLexeme.typeIndex;
            Lexeme operator = this.currentLexeme;
            this.advance();
            JSParseNode rhs = this.parseMultiplicativeExpression();
            if (this.isType(87) && ((startChar2 = lexer.getCharacterAt(this.currentLexeme.offset)) == '-' || startChar2 == '+')) {
                this.rescan(ADDITION_GROUP);
            }
            switch (operatorType) {
                case 45: {
                    result = this.createNode(37, operator);
                    result.appendChild((IParseNode)lhs);
                    result.appendChild((IParseNode)rhs);
                    break;
                }
                case 37: {
                    result = this.createNode(27, operator);
                    result.appendChild((IParseNode)lhs);
                    result.appendChild((IParseNode)rhs);
                    break;
                }
                default: {
                    String typeName = JSTokenTypes.getName(operatorType);
                    this.throwParseError(String.valueOf(JSMessages.getString("error.internal.additive.expression")) + typeName);
                }
            }
        }
        return result;
    }

    private JSParseNode parseArgumentList() throws ParseException, LexerException {
        JSParseNode arguments = this.createNode(53, this.currentLexeme);
        arguments.appendChild((IParseNode)this.parseAssignmentExpression(false));
        while (this.isType(51)) {
            this.advance();
            arguments.appendChild((IParseNode)this.parseAssignmentExpression(false));
        }
        return arguments;
    }

    private JSParseNode parseArrayLiteral() throws ParseException, LexerException {
        JSParseNode result = this.createNode(54, this.currentLexeme);
        this.assertType(66, "error.internal.punctuator");
        this.advance();
        boolean comma = true;
        while (!this.isType(74) && !this.isEOS()) {
            if (this.isType(51)) {
                this.advance();
                if (!comma) {
                    comma = true;
                    continue;
                }
                result.appendChild((IParseNode)this.createNode(65, null));
                continue;
            }
            if (!comma) {
                this.throwParseError(JSMessages.getString("error.array.missing.comma"));
            }
            result.appendChild((IParseNode)this.parseAssignmentExpression(false));
            comma = false;
        }
        if (comma && result.getChildCount() > 0) {
            result.appendChild((IParseNode)this.createNode(65, null));
        }
        this.assertType(74, "error.array.literal.rbracket");
        this.advance();
        result.includeLexemeInRange(this.currentLexeme);
        return result;
    }

    private JSParseNode parseAssignmentExpression(boolean noIn) throws ParseException, LexerException {
        JSParseNode result = this.parseConditionalExpression(noIn);
        if (this.inSet(assignmentOperatorSet)) {
            boolean referenceable = true;
            if (result.getTypeIndex() == 74) {
                JSParseNode child = (JSParseNode)result.getChild(0);
                while (child != null && child.getTypeIndex() == 74) {
                    child = (JSParseNode)child.getChild(0);
                }
                if (child == null || Arrays.binarySearch(referenceableSet, child.getTypeIndex()) < 0) {
                    referenceable = false;
                }
            }
            if (!referenceable || Arrays.binarySearch(referenceableSet, result.getTypeIndex()) < 0) {
                this.throwParseError(JSMessages.getString("error.assignment.invalid.lhs"));
            }
            JSParseNode lhs = result;
            int operatorType = this.currentLexeme.typeIndex;
            Lexeme operator = this.currentLexeme;
            this.advance();
            JSParseNode rhs = this.parseAssignmentExpression(noIn);
            switch (operatorType) {
                case 57: {
                    result = this.createNode(4, operator);
                    break;
                }
                case 73: {
                    result = this.createNode(6, operator);
                    break;
                }
                case 40: {
                    result = this.createNode(1, operator);
                    break;
                }
                case 81: {
                    result = this.createNode(7, operator);
                    break;
                }
                case 41: {
                    result = this.createNode(11, operator);
                    break;
                }
                case 49: {
                    result = this.createNode(3, operator);
                    break;
                }
                case 79: {
                    result = this.createNode(10, operator);
                    break;
                }
                case 56: {
                    result = this.createNode(12, operator);
                    break;
                }
                case 72: {
                    result = this.createNode(8, operator);
                    break;
                }
                case 65: {
                    result = this.createNode(5, operator);
                    break;
                }
                case 48: {
                    result = this.createNode(2, operator);
                    break;
                }
                case 64: {
                    result = this.createNode(9, operator);
                    break;
                }
                default: {
                    String typeName = JSTokenTypes.getName(operatorType);
                    this.throwParseError(String.valueOf(JSMessages.getString("error.internal.assignment.expression")) + typeName);
                }
            }
            result.appendChild((IParseNode)lhs);
            result.appendChild((IParseNode)rhs);
        }
        return result;
    }

    private JSParseNode parseBitwiseANDExpression(boolean noIn) throws ParseException, LexerException {
        JSParseNode result = this.parseEqualityExpression(noIn);
        while (this.isType(62)) {
            JSParseNode lhs = result;
            Lexeme operator = this.currentLexeme;
            this.advance();
            JSParseNode rhs = this.parseEqualityExpression(noIn);
            result = this.createNode(29, operator);
            result.appendChild((IParseNode)lhs);
            result.appendChild((IParseNode)rhs);
        }
        return result;
    }

    private JSParseNode parseBitwiseORExpression(boolean noIn) throws ParseException, LexerException {
        JSParseNode result = this.parseBitwiseXORExpression(noIn);
        while (this.isType(70)) {
            JSParseNode lhs = result;
            Lexeme operator = this.currentLexeme;
            this.advance();
            JSParseNode rhs = this.parseBitwiseXORExpression(noIn);
            result = this.createNode(30, operator);
            result.appendChild((IParseNode)lhs);
            result.appendChild((IParseNode)rhs);
        }
        return result;
    }

    private JSParseNode parseBitwiseXORExpression(boolean noIn) throws ParseException, LexerException {
        JSParseNode result = this.parseBitwiseANDExpression(noIn);
        while (this.isType(77)) {
            JSParseNode lhs = result;
            Lexeme operator = this.currentLexeme;
            this.advance();
            JSParseNode rhs = this.parseBitwiseANDExpression(noIn);
            result = this.createNode(31, operator);
            result.appendChild((IParseNode)lhs);
            result.appendChild((IParseNode)rhs);
        }
        return result;
    }

    private JSParseNode parseBlock() throws ParseException, LexerException {
        JSParseNode result = this.createNode(61, this.currentLexeme);
        this.assertType(34, "error.block.lcurly");
        this.advance();
        while (!this.isType(42) && !this.isEOS()) {
            JSParseNode lastStatement = this.parseStatement();
            result.appendChild((IParseNode)lastStatement);
        }
        result.includeLexemeInRange(this.currentLexeme);
        this.assertType(42, "error.block.rcurly");
        this.advance();
        return result;
    }

    private JSParseNode parseBreakStatement() throws ParseException, LexerException {
        Lexeme keyword = this.currentLexeme;
        JSParseNode label = this.createNode(43, null);
        this.assertAndAdvance(9, "error.internal.keyword");
        if (this.isType(8)) {
            label = this.createNode(64, this.currentLexeme);
            this.advance();
        }
        JSParseNode result = this.createNode(51, keyword);
        result.appendChild((IParseNode)label);
        this.handleOptionalSemicolon(result);
        return result;
    }

    private JSParseNode parseCaseOrDefaultBlock() throws ParseException, LexerException {
        JSParseNode clause = null;
        Lexeme keyword = this.currentLexeme;
        switch (this.currentLexeme.typeIndex) {
            case 10: {
                this.assertAndAdvance(10, "error.internal.keyword");
                JSParseNode expression = this.parseExpression(false, "error.switch.case.expression");
                clause = this.createNode(57, keyword);
                clause.appendChild((IParseNode)expression);
                this.assertType(78, "error.switch.case.colon");
                this.advance();
                break;
            }
            case 13: {
                this.assertAndAdvance(13, "error.internal.keyword");
                this.assertType(78, "error.switch.default.colon");
                clause = this.createNode(56, keyword);
                clause.includeLexemeInRange(this.currentLexeme);
                this.advance();
                break;
            }
            default: {
                this.throwParseError(JSMessages.getString("error.switch.body"));
                break;
            }
        }
        while (!this.inSet(caseBlockSet) && !this.isEOS()) {
            clause.appendChild((IParseNode)this.parseStatement());
        }
        return clause;
    }

    private JSParseNode parseCatch() throws ParseException, LexerException {
        Lexeme keyword = this.currentLexeme;
        this.assertAndAdvance(11, "error.internal.keyword");
        this.assertAndAdvance(50, "error.try.catch.lparen");
        this.assertType(8, "error.try.catch.identifier");
        JSParseNode name = this.createNode(64, this.currentLexeme);
        this.advance();
        this.assertAndAdvance(58, "error.try.catch.rparen");
        JSParseNode body = this.parseBlock();
        JSParseNode result = this.createNode(38, keyword);
        result.appendChild((IParseNode)name);
        result.appendChild((IParseNode)body);
        return result;
    }

    private JSParseNode parseConditionalExpression(boolean noIn) throws ParseException, LexerException {
        JSParseNode result = this.parseLogicalORExpression(noIn);
        if (this.isType(71)) {
            JSParseNode condition = result;
            JSParseNode trueCase = this.createNode(43, null);
            JSParseNode falseCase = this.createNode(43, null);
            Lexeme question = this.currentLexeme;
            this.advance();
            trueCase = this.parseAssignmentExpression(noIn);
            this.assertType(78, "error.conditional.colon");
            this.advance();
            falseCase = this.parseAssignmentExpression(noIn);
            result = this.createNode(39, question);
            result.appendChild((IParseNode)condition);
            result.appendChild((IParseNode)trueCase);
            result.appendChild((IParseNode)falseCase);
        }
        return result;
    }

    private JSParseNode parseContinueStatement() throws ParseException, LexerException {
        JSParseNode label = this.createNode(43, null);
        Lexeme keyword = this.currentLexeme;
        this.assertAndAdvance(12, "error.internal.keyword");
        if (this.isType(8)) {
            label = this.createNode(64, this.currentLexeme);
            this.advance();
        }
        JSParseNode result = this.createNode(52, keyword);
        result.appendChild((IParseNode)label);
        this.handleOptionalSemicolon(result);
        return result;
    }

    private JSParseNode parseDoStatement() throws ParseException, LexerException {
        Lexeme keyword = this.currentLexeme;
        this.assertAndAdvance(15, "error.internal.keyword");
        JSParseNode body = this.parseStatement();
        this.assertAndAdvance(32, "error.do.while");
        this.assertAndAdvance(50, "error.do.while.lparen");
        JSParseNode condition = this.parseExpression(false, "error.do.while.expression");
        JSParseNode result = this.createNode(42, keyword);
        result.includeLexemeInRange(this.currentLexeme);
        this.assertAndAdvance(58, "error.do.while.rparen");
        if (this.isType(43)) {
            result.includeLexemeInRange(this.currentLexeme);
            result.setIncludesSemicolon(true);
            this.advance();
        }
        result.appendChild((IParseNode)body);
        result.appendChild((IParseNode)condition);
        return result;
    }

    private JSParseNode parseEqualityExpression(boolean noIn) throws ParseException, LexerException {
        JSParseNode result = this.parseRelationalExpression(noIn);
        while (this.inSet(equalityExpressionSet)) {
            JSParseNode lhs = result;
            int operatorType = this.currentLexeme.typeIndex;
            Lexeme operator = this.currentLexeme;
            this.advance();
            JSParseNode rhs = this.parseRelationalExpression(noIn);
            switch (operatorType) {
                case 44: {
                    result = this.createNode(15, operator);
                    break;
                }
                case 52: {
                    result = this.createNode(25, operator);
                    break;
                }
                case 60: {
                    result = this.createNode(18, operator);
                    break;
                }
                case 68: {
                    result = this.createNode(26, operator);
                    break;
                }
                default: {
                    String typeName = JSTokenTypes.getName(operatorType);
                    this.throwParseError(String.valueOf(JSMessages.getString("error.internal.equality.expression")) + typeName);
                }
            }
            result.appendChild((IParseNode)lhs);
            result.appendChild((IParseNode)rhs);
        }
        return result;
    }

    private JSParseNode parseExpression(boolean noIn, String errorKey) throws ParseException, LexerException {
        this._expressionErrorKey = errorKey;
        JSParseNode result = this.parseAssignmentExpression(noIn);
        if (this.isType(51)) {
            JSParseNode commas = this.createNode(55, this.currentLexeme);
            commas.appendChild((IParseNode)result);
            while (this.isType(51)) {
                this.advance();
                JSParseNode node = this.parseAssignmentExpression(noIn);
                commas.appendChild((IParseNode)node);
            }
            result = commas;
        }
        this._expressionErrorKey = null;
        return result;
    }

    private JSParseNode parseFinally() throws ParseException, LexerException {
        this.assertType(20, "error.internal.keyword");
        Lexeme finallyLexeme = this.currentLexeme;
        this.advance();
        JSParseNode block = this.parseBlock();
        JSParseNode result = this.createNode(44, finallyLexeme);
        result.appendChild((IParseNode)block);
        return result;
    }

    private JSParseNode parseForStatement() throws ParseException, LexerException {
        JSParseNode result;
        JSParseNode condition = null;
        JSParseNode object = this.createNode(43, null);
        JSParseNode advance = null;
        JSParseNode body = this.createNode(43, null);
        boolean isForIn = false;
        Lexeme keyword = this.currentLexeme;
        this.assertAndAdvance(21, "error.internal.keyword");
        JSParseNode initialize = this.createNode(43, this.currentLexeme);
        this.assertAndAdvance(50, "error.for.lparen");
        if (!this.isType(43)) {
            initialize = this.isType(30) ? this.parseVarExpression(true) : this.parseExpression(true, "error.for.initialization.expression");
        } else {
            initialize.includeLexemeInRange(this.currentLexeme);
        }
        if (this.isType(18)) {
            this.advance();
            isForIn = true;
            object = this.parseExpression(false, "error.for.in.expression");
        } else {
            condition = this.createNode(43, this.currentLexeme);
            this.assertAndAdvance(43, "error.for.initialization.semicolon");
            if (!this.isType(43)) {
                condition = this.parseExpression(false, "error.for.condition.expression");
            } else {
                condition.includeLexemeInRange(this.currentLexeme);
            }
            advance = this.createNode(43, this.currentLexeme);
            this.assertAndAdvance(43, "error.for.condition.semicolon");
            if (!this.isType(58)) {
                advance = this.parseExpression(false, "error.for.iteration.expression");
            } else {
                advance.includeLexemeInRange(this.currentLexeme);
            }
        }
        this.assertAndAdvance(58, "error.for.rparen");
        body = this.parseStatement();
        if (isForIn) {
            result = this.createNode(45, keyword);
            result.appendChild((IParseNode)initialize);
            result.appendChild((IParseNode)object);
            result.appendChild((IParseNode)body);
        } else {
            result = this.createNode(46, keyword);
            result.appendChild((IParseNode)initialize);
            result.appendChild((IParseNode)condition);
            result.appendChild((IParseNode)advance);
            result.appendChild((IParseNode)body);
        }
        return result;
    }

    private JSParseNode parseFormalParameterList() throws ParseException, LexerException {
        JSParseNode result = this.createNode(60, this.prevLexeme);
        this.assertType(8, "error.parameters.name");
        JSParseNode name = this.createNode(64, this.currentLexeme);
        this.advance();
        result.appendChild((IParseNode)name);
        while (this.isType(51)) {
            this.advance();
            this.assertType(8, "error.parameters.name");
            name = this.createNode(64, this.currentLexeme);
            this.advance();
            result.appendChild((IParseNode)name);
        }
        return result;
    }

    private JSParseNode parseFunctionBody() throws ParseException, LexerException {
        JSParseNode statements = this.createNode(61, this.prevLexeme);
        while (!this.isType(42) && !this.isEOS()) {
            JSParseNode statement = this.isType(22) ? this.parseFunctionDeclaration(false) : this.parseStatement();
            statements.appendChild((IParseNode)statement);
        }
        statements.includeLexemeInRange(this.currentLexeme);
        return statements;
    }

    private JSParseNode parseFunctionDeclaration(boolean identifierRequired) throws ParseException, LexerException {
        Lexeme keyword = this.currentLexeme;
        this.assertAndAdvance(22, "error.internal.keyword");
        return this.parseFunctionDeclaration2(identifierRequired, keyword);
    }

    private JSParseNode parseFunctionDeclaration2(boolean identifierRequired, Lexeme keyword) throws LexerException, ParseException {
        String name = null;
        if (this.isType(8)) {
            name = this.currentLexeme.getText();
            this.advance();
        } else if (identifierRequired) {
            this.throwParseError(JSMessages.getString("error.function.name"));
        }
        JSParseNode parameters = this.createNode(43, this.currentLexeme);
        this.prevLexeme = this.currentLexeme;
        this.assertAndAdvance(50, "error.function.lparen");
        if (this.isType(8)) {
            parameters = this.parseFormalParameterList();
        }
        parameters.includeLexemeInRange(this.currentLexeme);
        this.assertAndAdvance(58, "error.function.rparen");
        this.prevLexeme = this.currentLexeme;
        this.assertAndAdvance(34, "error.function.lcurly");
        JSParseNode body = this.parseFunctionBody();
        Lexeme rcurly = this.currentLexeme;
        this.assertAndAdvance(42, "error.function.rcurly");
        JSParseNode result = this.createNode(47, keyword);
        if (name != null) {
            result.setAttribute("name", name);
        }
        result.appendChild((IParseNode)parameters);
        result.appendChild((IParseNode)body);
        result.includeLexemeInRange(rcurly);
        return result;
    }

    private JSParseNode parseIfStatement() throws ParseException, LexerException {
        JSParseNode falseCase = this.createNode(43, null);
        Lexeme keyword = this.currentLexeme;
        this.assertAndAdvance(17, "error.internal.keyword");
        this.assertAndAdvance(50, "error.if.lparen");
        JSParseNode condition = this.parseExpression(false, "error.if.condition");
        this.assertAndAdvance(58, "error.if.rparen");
        JSParseNode trueCase = this.parseStatement();
        if (this.isType(16)) {
            this.advance();
            falseCase = this.parseStatement();
        }
        JSParseNode result = this.createNode(48, keyword);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)trueCase);
        result.appendChild((IParseNode)falseCase);
        return result;
    }

    private JSParseNode parseLabelledStatement() throws ParseException, LexerException {
        Lexeme identifier = this.currentLexeme;
        JSParseNode result = this.parseExpression(false, null);
        if (this.isType(78)) {
            JSParseNode label = this.createNode(64, identifier);
            this.advance();
            JSParseNode statement = this.parseStatement();
            result = this.createNode(50, null);
            result.appendChild((IParseNode)label);
            result.appendChild((IParseNode)statement);
        }
        this.handleOptionalSemicolon(result);
        return result;
    }

    private JSParseNode parseLogicalANDExpression(boolean noIn) throws ParseException, LexerException {
        JSParseNode result = this.parseBitwiseORExpression(noIn);
        while (this.isType(55)) {
            JSParseNode lhs = result;
            Lexeme operator = this.currentLexeme;
            this.advance();
            JSParseNode rhs = this.parseBitwiseORExpression(noIn);
            result = this.createNode(23, operator);
            result.appendChild((IParseNode)lhs);
            result.appendChild((IParseNode)rhs);
        }
        return result;
    }

    private JSParseNode parseLogicalORExpression(boolean noIn) throws ParseException, LexerException {
        JSParseNode result = this.parseLogicalANDExpression(noIn);
        while (this.isType(63)) {
            JSParseNode lhs = result;
            Lexeme operator = this.currentLexeme;
            this.advance();
            JSParseNode rhs = this.parseLogicalANDExpression(noIn);
            result = this.createNode(24, operator);
            result.appendChild((IParseNode)lhs);
            result.appendChild((IParseNode)rhs);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private JSParseNode parseMemberExpression(boolean isInvocable) throws ParseException, LexerException {
        JSParseNode result = null;
        switch (this.currentLexeme.typeIndex) {
            case 22: {
                result = this.parseFunctionDeclaration(false);
                break;
            }
            case 23: {
                Lexeme newKeyword = this.currentLexeme;
                this.advance();
                JSParseNode memberExpression = this.parseMemberExpression(false);
                JSParseNode arguments = this.createNode(43, this.currentLexeme);
                if (this.isType(50)) {
                    this.advance();
                    if (!this.isType(58)) {
                        arguments = this.parseArgumentList();
                    } else {
                        arguments.includeLexemeInRange(this.currentLexeme);
                    }
                    this.assertAndAdvance(58, "error.new.rparen");
                }
                result = this.createNode(40, newKeyword);
                result.appendChild((IParseNode)memberExpression);
                result.appendChild((IParseNode)arguments);
                break;
            }
            default: {
                result = this.parsePrimaryExpression();
                break;
            }
        }
        while (this.inSet(postfixMemberExpressionSet)) {
            switch (this.currentLexeme.typeIndex) {
                case 35: {
                    Lexeme dot = this.currentLexeme;
                    this.advance();
                    this.assertType(8, "error.get.property.name");
                    JSParseNode identifier = this.createNode(64, this.currentLexeme);
                    this.advance();
                    JSParseNode temp = this.createNode(14, dot);
                    temp.appendChild((IParseNode)result);
                    temp.appendChild((IParseNode)identifier);
                    result = temp;
                    break;
                }
                case 66: {
                    Lexeme lbrace = this.currentLexeme;
                    this.advance();
                    JSParseNode indexExpression = this.parseExpression(false, "error.get.element.expression");
                    this.assertAndAdvance(74, "error.get.element.rbracket");
                    JSParseNode temp = this.createNode(13, lbrace);
                    temp.appendChild((IParseNode)result);
                    temp.appendChild((IParseNode)indexExpression);
                    result = temp;
                    break;
                }
                case 50: {
                    if (!isInvocable) {
                        return result;
                    }
                    JSParseNode arguments = this.createNode(43, this.currentLexeme);
                    Lexeme lparen = this.currentLexeme;
                    this.advance();
                    if (this.currentLexeme.typeIndex != 58) {
                        arguments = this.parseArgumentList();
                        arguments.includeLexemeInRange(this.currentLexeme);
                    } else {
                        arguments.includeLexemeInRange(this.currentLexeme);
                    }
                    Lexeme end = this.currentLexeme;
                    this.assertAndAdvance(58, "error.invocation.rparen");
                    JSParseNode temp = this.createNode(49, lparen);
                    temp.appendChild((IParseNode)result);
                    temp.appendChild((IParseNode)arguments);
                    temp.includeLexemeInRange(end);
                    result = temp;
                }
            }
        }
        return result;
    }

    private JSParseNode parseMultiplicativeExpression() throws ParseException, LexerException {
        JSParseNode result = this.parseUnaryExpression();
        while (this.inSet(multiplicativeExpressionSet)) {
            JSParseNode lhs = result;
            int operatorType = this.currentLexeme.typeIndex;
            Lexeme operator = this.currentLexeme;
            this.advance();
            JSParseNode rhs = this.parseUnaryExpression();
            switch (operatorType) {
                case 53: {
                    result = this.createNode(34, operator);
                    break;
                }
                case 80: {
                    result = this.createNode(32, operator);
                    break;
                }
                case 61: {
                    result = this.createNode(33, operator);
                    break;
                }
                default: {
                    String typeName = JSTokenTypes.getName(operatorType);
                    this.throwParseError(String.valueOf(JSMessages.getString("error.internal.multiplicative.expression")) + typeName);
                }
            }
            result.appendChild((IParseNode)lhs);
            result.appendChild((IParseNode)rhs);
        }
        return result;
    }

    private JSParseNode parseObjectLiteral() throws ParseException, LexerException {
        JSParseNode result = this.createNode(59, this.currentLexeme);
        this.assertAndAdvance(34, "error.internal.punctuator");
        if (this.inSet(propertyNameSet)) {
            result.appendChild((IParseNode)this.parseNameValuePair());
            while (this.isType(51)) {
                this.advance();
                if (this.isType(42)) continue;
                result.appendChild((IParseNode)this.parseNameValuePair());
            }
        }
        result.includeLexemeInRange(this.currentLexeme);
        this.assertAndAdvance(42, "error.object.literal.rcurly");
        return result;
    }

    private JSParseNode parsePrimaryExpression() throws ParseException, LexerException {
        JSParseNode result = null;
        switch (this.currentLexeme.typeIndex) {
            case 80: 
            case 81: {
                Lexeme save = this.currentLexeme;
                this.rescan(REGEX_GROUP);
                if (this.currentLexeme.typeIndex == 89) {
                    result = this.createNode(67, this.currentLexeme);
                    this.advance();
                    break;
                }
                ILexer lexer = this.getLexer();
                this.currentLexeme = save;
                this.addLexeme(this.currentLexeme);
                lexer.setCurrentOffset(save.getEndingOffset());
                lexer.setGroup(DEFAULT_GROUP);
                this.assertType(89, "error.regex");
                break;
            }
            case 89: {
                result = this.createNode(67, this.currentLexeme);
                this.advance();
                break;
            }
            case 86: {
                result = this.createNode(63, this.currentLexeme);
                this.advance();
                break;
            }
            case 8: {
                result = this.createNode(64, this.currentLexeme);
                this.advance();
                break;
            }
            case 66: {
                result = this.parseArrayLiteral();
                break;
            }
            case 34: {
                result = this.parseObjectLiteral();
                break;
            }
            case 50: {
                Lexeme lparen = this.currentLexeme;
                this.advance();
                JSParseNode expression = this.parseExpression(false, "error.group.expression");
                this.assertType(58, "error.group.rparen");
                this.advance();
                result = this.createNode(74, lparen);
                result.appendChild((IParseNode)expression);
                break;
            }
            case 84: {
                result = this.createNode(65, this.currentLexeme);
                this.advance();
                break;
            }
            case 87: {
                result = this.createNode(66, this.currentLexeme);
                this.advance();
                break;
            }
            case 88: {
                result = this.createNode(68, this.currentLexeme);
                this.advance();
                break;
            }
            case 26: {
                result = this.createNode(71, this.currentLexeme);
                this.advance();
                break;
            }
            case 85: {
                result = this.createNode(69, this.currentLexeme);
                this.advance();
                break;
            }
            default: {
                String message = JSMessages.getString("error.primitive");
                if (this.isEOS()) {
                    message = String.valueOf(message) + JSMessages.getString("error.found.eof");
                }
                this.throwParseError(message);
            }
        }
        return result;
    }

    private JSParseNode parseNameValuePair() throws ParseException, LexerException {
        JSParseNode value;
        JSParseNode name;
        this.assertInSet(propertyNameSet, "error.object.literal.name");
        String identifier = this.currentLexeme.getText();
        if ("get".equals(identifier) || "set".equals(identifier)) {
            Lexeme keyword = this.currentLexeme;
            this.advance();
            switch (this.currentLexeme.typeIndex) {
                case 78: {
                    name = this.createNode(64, keyword);
                    this.assertAndAdvance(78, "error.object.literal.colon");
                    value = this.parseAssignmentExpression(false);
                    break;
                }
                default: {
                    name = this.createNode(64, this.currentLexeme);
                    value = this.parseFunctionDeclaration2(true, keyword);
                    break;
                }
            }
        } else {
            name = this.createNode(64, this.currentLexeme);
            this.advance();
            this.assertAndAdvance(78, "error.object.literal.colon");
            value = this.parseAssignmentExpression(false);
        }
        JSParseNode result = this.createNode(70, null);
        result.appendChild((IParseNode)name);
        result.appendChild((IParseNode)value);
        return result;
    }

    private JSParseNode parseRelationalExpression(boolean noIn) throws ParseException, LexerException {
        JSParseNode result = this.parseShiftExpression();
        while (this.inSet(relationalExpressionSet)) {
            if (noIn) break;
            JSParseNode lhs = result;
            int operatorType = this.currentLexeme.typeIndex;
            Lexeme operator = this.currentLexeme;
            this.advance();
            JSParseNode rhs = this.parseShiftExpression();
            switch (operatorType) {
                case 59: {
                    result = this.createNode(21, operator);
                    result.appendChild((IParseNode)lhs);
                    result.appendChild((IParseNode)rhs);
                    break;
                }
                case 67: {
                    result = this.createNode(16, operator);
                    result.appendChild((IParseNode)lhs);
                    result.appendChild((IParseNode)rhs);
                    break;
                }
                case 75: {
                    result = this.createNode(22, operator);
                    result.appendChild((IParseNode)lhs);
                    result.appendChild((IParseNode)rhs);
                    break;
                }
                case 36: {
                    result = this.createNode(17, operator);
                    result.appendChild((IParseNode)lhs);
                    result.appendChild((IParseNode)rhs);
                    break;
                }
                case 19: {
                    result = this.createNode(20, operator);
                    result.appendChild((IParseNode)lhs);
                    result.appendChild((IParseNode)rhs);
                    break;
                }
                case 18: {
                    result = this.createNode(19, operator);
                    result.appendChild((IParseNode)lhs);
                    result.appendChild((IParseNode)rhs);
                    break;
                }
                default: {
                    String typeName = JSTokenTypes.getName(operatorType);
                    this.throwParseError(String.valueOf(JSMessages.getString("error.internal.relational.expression")) + typeName);
                }
            }
        }
        return result;
    }

    private JSParseNode parseReturnStatement() throws ParseException, LexerException {
        JSParseNode expression = this.createNode(43, null);
        Lexeme keyword = this.currentLexeme;
        this.assertAndAdvance(24, "error.internal.keyword");
        if (!this.inSet(returnSet)) {
            expression = this.parseExpression(false, "error.return.expression");
        }
        JSParseNode result = this.createNode(83, keyword);
        result.appendChild((IParseNode)expression);
        this.handleOptionalSemicolon(result);
        return result;
    }

    private JSParseNode parseShiftExpression() throws ParseException, LexerException {
        JSParseNode result = this.parseAdditiveExpression();
        while (this.inSet(shiftExpressionSet)) {
            JSParseNode lhs = result;
            int operatorType = this.currentLexeme.typeIndex;
            Lexeme operator = this.currentLexeme;
            this.advance();
            JSParseNode rhs = this.parseAdditiveExpression();
            switch (operatorType) {
                case 38: {
                    result = this.createNode(35, operator);
                    result.appendChild((IParseNode)lhs);
                    result.appendChild((IParseNode)rhs);
                    break;
                }
                case 46: {
                    result = this.createNode(36, operator);
                    result.appendChild((IParseNode)lhs);
                    result.appendChild((IParseNode)rhs);
                    break;
                }
                case 54: {
                    result = this.createNode(28, operator);
                    result.appendChild((IParseNode)lhs);
                    result.appendChild((IParseNode)rhs);
                    break;
                }
                default: {
                    String typeName = JSTokenTypes.getName(operatorType);
                    this.throwParseError(String.valueOf(JSMessages.getString("error.internal.shift.expression")) + typeName);
                }
            }
        }
        return result;
    }

    private JSParseNode parseSourceElement() throws ParseException, LexerException {
        JSParseNode result = null;
        Lexeme startingLexeme = this.currentLexeme;
        if (startingLexeme != EOS) {
            switch (startingLexeme.typeIndex) {
                case 22: {
                    try {
                        result = this.parseFunctionDeclaration(true);
                    }
                    catch (ParseException pe) {
                        result = this.recover(startingLexeme, pe);
                    }
                    break;
                }
                default: {
                    result = this.parseStatement();
                }
            }
        }
        return result;
    }

    private JSParseNode parseStatement() throws LexerException {
        Lexeme startingLexeme = this.currentLexeme;
        JSParseNode result = null;
        try {
            switch (this.currentLexeme.typeIndex) {
                case 34: {
                    result = this.parseBlock();
                    break;
                }
                case 9: {
                    result = this.parseBreakStatement();
                    break;
                }
                case 12: {
                    result = this.parseContinueStatement();
                    break;
                }
                case 43: {
                    result = this.createNode(43, this.currentLexeme);
                    result.setIncludesSemicolon(true);
                    this.advance();
                    break;
                }
                case 21: {
                    result = this.parseForStatement();
                    break;
                }
                case 8: {
                    result = this.parseLabelledStatement();
                    break;
                }
                case 17: {
                    result = this.parseIfStatement();
                    break;
                }
                case 15: {
                    result = this.parseDoStatement();
                    break;
                }
                case 24: {
                    result = this.parseReturnStatement();
                    break;
                }
                case 25: {
                    result = this.parseSwitchStatement();
                    break;
                }
                case 27: {
                    result = this.parseThrowStatement();
                    break;
                }
                case 28: {
                    result = this.parseTryStatement();
                    break;
                }
                case 30: {
                    result = this.parseVarExpression(false);
                    this.handleOptionalSemicolon(result);
                    break;
                }
                case 32: {
                    result = this.parseWhileStatement();
                    break;
                }
                case 33: {
                    result = this.parseWithStatement();
                    break;
                }
                default: {
                    result = this.parseExpression(false, null);
                    this.handleOptionalSemicolon(result);
                    break;
                }
            }
        }
        catch (ParseException pe) {
            result = this.recover(startingLexeme, pe);
        }
        return result;
    }

    private JSParseNode parseSwitchStatement() throws ParseException, LexerException {
        boolean hasDefault = false;
        Lexeme keyword = this.currentLexeme;
        this.assertAndAdvance(25, "error.internal.keyword");
        this.assertAndAdvance(50, "error.switch.lparen");
        JSParseNode expression = this.parseExpression(false, "error.switch.expression");
        JSParseNode result = this.createNode(58, keyword);
        result.appendChild((IParseNode)expression);
        this.assertAndAdvance(58, "error.switch.rparen");
        this.assertAndAdvance(34, "error.switch.lcurly");
        while (!this.isType(42) && !this.isEOS()) {
            JSParseNode block = this.parseCaseOrDefaultBlock();
            if (block.getTypeIndex() == 56) {
                if (hasDefault) {
                    this.throwParseError(JSMessages.getString("error.switch.default.duplicate"));
                } else {
                    hasDefault = true;
                }
            }
            result.appendChild((IParseNode)block);
        }
        result.includeLexemeInRange(this.currentLexeme);
        this.assertAndAdvance(42, "error.switch.rcurly");
        return result;
    }

    private JSParseNode parseThrowStatement() throws ParseException, LexerException {
        Lexeme keyword = this.currentLexeme;
        this.assertAndAdvance(27, "error.internal.keyword");
        JSParseNode expression = this.parseExpression(false, "error.throw.expression");
        JSParseNode result = this.createNode(84, keyword);
        result.appendChild((IParseNode)expression);
        this.handleOptionalSemicolon(result);
        return result;
    }

    private JSParseNode parseTryStatement() throws ParseException, LexerException {
        JSParseNode catchNode = this.createNode(43, null);
        JSParseNode finallyNode = this.createNode(43, null);
        this.assertType(28, "error.internal.keyword");
        Lexeme keyword = this.currentLexeme;
        this.advance();
        JSParseNode body = this.parseBlock();
        if (this.isType(11)) {
            catchNode = this.parseCatch();
        }
        if (this.isType(20)) {
            finallyNode = this.parseFinally();
        }
        if (catchNode == null && finallyNode == null) {
            this.throwParseError(JSMessages.getString("error.try.empty"));
        }
        JSParseNode result = this.createNode(72, keyword);
        result.appendChild((IParseNode)body);
        if (catchNode.isEmpty()) {
            result.includeLexemeInRange(catchNode.getEndingLexeme());
        }
        result.appendChild((IParseNode)catchNode);
        if (!finallyNode.isEmpty()) {
            result.includeLexemeInRange(finallyNode.getEndingLexeme());
        }
        result.appendChild((IParseNode)finallyNode);
        return result;
    }

    private JSParseNode parseUnaryExpression() throws ParseException, LexerException {
        JSParseNode result = null;
        if (this.inSet(unaryExpressionSet)) {
            int type = this.currentLexeme.typeIndex;
            boolean isMemberExpression = this.inSet(postfixExpressionSet);
            Lexeme operator = this.currentLexeme;
            this.advance();
            result = isMemberExpression ? this.parseMemberExpression(true) : this.parseUnaryExpression();
            switch (type) {
                case 14: {
                    JSParseNode temp = this.createNode(73, operator);
                    temp.appendChild((IParseNode)result);
                    result = temp;
                    break;
                }
                case 39: {
                    JSParseNode temp = this.createNode(75, operator);
                    temp.appendChild((IParseNode)result);
                    result = temp;
                    break;
                }
                case 45: {
                    JSParseNode temp = this.createNode(77, operator);
                    temp.appendChild((IParseNode)result);
                    result = temp;
                    break;
                }
                case 76: {
                    JSParseNode temp = this.createNode(81, operator);
                    temp.appendChild((IParseNode)result);
                    result = temp;
                    break;
                }
                case 37: {
                    JSParseNode temp = this.createNode(78, operator);
                    temp.appendChild((IParseNode)result);
                    result = temp;
                    break;
                }
                case 69: {
                    JSParseNode temp = this.createNode(82, operator);
                    temp.appendChild((IParseNode)result);
                    result = temp;
                    break;
                }
                case 47: {
                    JSParseNode temp = this.createNode(76, operator);
                    temp.appendChild((IParseNode)result);
                    result = temp;
                    break;
                }
                case 29: {
                    JSParseNode temp = this.createNode(85, operator);
                    temp.appendChild((IParseNode)result);
                    result = temp;
                    break;
                }
                case 31: {
                    JSParseNode temp = this.createNode(86, operator);
                    temp.appendChild((IParseNode)result);
                    result = temp;
                    break;
                }
            }
        } else {
            result = this.parseMemberExpression(true);
            if (!this.currentLexeme.isAfterEOL() && this.inSet(postfixExpressionSet)) {
                int type = this.currentLexeme.typeIndex;
                Lexeme operator = this.currentLexeme;
                this.advance();
                switch (type) {
                    case 69: {
                        JSParseNode temp = this.createNode(80, operator);
                        temp.appendChild((IParseNode)result);
                        result = temp;
                        break;
                    }
                    case 76: {
                        JSParseNode temp = this.createNode(79, operator);
                        temp.appendChild((IParseNode)result);
                        result = temp;
                        break;
                    }
                }
            }
        }
        return result;
    }

    private JSParseNode parseVarExpression(boolean noIn) throws ParseException, LexerException {
        JSParseNode result = this.createNode(62, this.currentLexeme);
        this.assertAndAdvance(30, "error.internal.keyword");
        result.appendChild((IParseNode)this.parseVariableDeclaration(noIn));
        while (this.isType(51)) {
            this.advance();
            result.appendChild((IParseNode)this.parseVariableDeclaration(noIn));
        }
        return result;
    }

    private JSParseNode parseVariableDeclaration(boolean noIn) throws ParseException, LexerException {
        JSParseNode assignment = this.createNode(43, null);
        this.assertType(8, "error.var.name");
        JSParseNode id = this.createNode(64, this.currentLexeme);
        this.advance();
        if (this.isType(40)) {
            this.advance();
            assignment = this.parseAssignmentExpression(noIn);
        }
        JSParseNode result = this.createNode(41, null);
        result.appendChild((IParseNode)id);
        result.appendChild((IParseNode)assignment);
        return result;
    }

    private JSParseNode parseWhileStatement() throws ParseException, LexerException {
        Lexeme keyword = this.currentLexeme;
        this.assertAndAdvance(32, "error.internal.keyword");
        this.assertAndAdvance(50, "error.while.lparen");
        JSParseNode condition = this.parseExpression(false, "error.while.expression");
        this.assertAndAdvance(58, "error.while.rparen");
        JSParseNode body = this.parseStatement();
        JSParseNode result = this.createNode(87, keyword);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)body);
        return result;
    }

    private JSParseNode parseWithStatement() throws ParseException, LexerException {
        Lexeme keyword = this.currentLexeme;
        this.assertAndAdvance(33, "error.internal.keyword");
        this.assertAndAdvance(50, "error.with.lparen");
        JSParseNode expression = this.parseExpression(false, "error.with.expression");
        this.assertAndAdvance(58, "error.with.rparen");
        JSParseNode body = this.parseStatement();
        JSParseNode result = this.createNode(88, keyword);
        result.appendChild((IParseNode)expression);
        result.appendChild((IParseNode)body);
        return result;
    }

    private JSParseNode recover(Lexeme startingLexeme, ParseException exception) throws LexerException {
        JSParseNode error = this.createNode(-1, startingLexeme);
        if (startingLexeme != EOS) {
            int stop;
            LexemeList lexemes = this.getLexemeList();
            int lexemeCount = lexemes.size();
            boolean inStopSet = false;
            int start = lexemes.getLexemeIndex(startingLexeme);
            int n = stop = this.currentLexeme != EOS ? lexemes.getLexemeIndex(this.currentLexeme) : lexemeCount;
            if (start == stop) {
                stop = Math.min(stop + 1, lexemeCount);
                this.advance();
            }
            if (!this.isEOS() && this.currentLexeme.isAfterEOL() && !(inStopSet = this.inSet(stopSet))) {
                this.advance();
            }
            while (!(this.isEOS() || this.currentLexeme.isAfterEOL() || inStopSet)) {
                inStopSet = this.inSet(stopSet);
                this.advance();
            }
        }
        return error;
    }

    private void rescan(String groupName) throws LexerException {
        ILexer lexer = this.getLexer();
        LexemeList lexemes = this.getLexemeList();
        lexemes.remove(this.currentLexeme);
        lexemes.getAffectedRegion().includeInRange(this.currentLexeme);
        lexer.setLexerState(groupName, this.currentLexeme.offset);
        this.advance();
        if (!this.isEOS()) {
            this.getParseState().addUpdateRegion((IRange)this.currentLexeme);
        }
    }

    protected void throwParseError(String message) throws ParseException {
        if (this.currentLexeme != null) {
            if (this._expressionErrorKey != null && this._expressionErrorKey.length() > 0) {
                message = JSMessages.getString(this._expressionErrorKey);
            }
            if (this.currentLexeme != EOS) {
                message = String.valueOf(message) + JSMessages.getString("error.near", this.currentLexeme.getText());
            }
        }
        throw new ParseException(message, -1);
    }

    public String getPiLanguage() {
        return this._piLanguage;
    }

    public void setPiLanguage(String piLanguage) {
        this._piLanguage = piLanguage;
    }
}

