/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.contentassist;

import com.aptana.ide.editors.unified.contentassist.IUnifiedCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class JSCompletionProposal
implements ICompletionProposal,
IUnifiedCompletionProposal {
    private String displayString;
    private String replacementString;
    private int fReplacementOffset;
    private int replacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;
    private int fObjectType;
    private String fFileLocation;
    public boolean defaultSelection = false;
    public boolean suggestedSelection = false;
    private Image[] userAgentImages;

    public JSCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int objectType, String fileLocation, Image[] userAgentImages) {
        this.replacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.displayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.fObjectType = objectType;
        this.fFileLocation = fileLocation;
        this.userAgentImages = userAgentImages;
    }

    public static String padToColumn(String stringToPad, int columnWidth) {
        String blanks = "                             ";
        if (stringToPad.length() > columnWidth) {
            return stringToPad.substring(0, columnWidth);
        }
        int blankLength = columnWidth - stringToPad.length();
        return String.valueOf(stringToPad) + blanks.substring(0, blankLength);
    }

    public int getObjectType() {
        return this.fObjectType;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.replacementLength, this.replacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        return this.replacementString;
    }

    public String getReplaceString() {
        return this.replacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public boolean isDefaultSelection() {
        return this.defaultSelection;
    }

    public void setDefaultSelection(boolean defaultSelection) {
        this.defaultSelection = defaultSelection;
    }

    public String getFileLocation() {
        return this.fFileLocation;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        this.replacementLength = replacementLength;
    }

    public Image[] getUserAgentImages() {
        return this.userAgentImages;
    }

    public boolean isSuggestedSelection() {
        return this.suggestedSelection;
    }

    public void setSuggestedSelection(boolean suggestedSelection) {
        this.suggestedSelection = suggestedSelection;
    }
}

