/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js;

import com.aptana.ide.editor.js.JSContributor;
import com.aptana.ide.editor.js.JSDocumentProvider;
import com.aptana.ide.editor.js.JSFileServiceFactory;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.Messages;
import com.aptana.ide.editor.js.context.JSContextAwareness;
import com.aptana.ide.editors.toolbar.ToolbarWidget;
import com.aptana.ide.editors.unified.ContributedOutline;
import com.aptana.ide.editors.unified.DocumentSourceProvider;
import com.aptana.ide.editors.unified.IFileServiceFactory;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.editors.unified.context.IContextAwareness;
import com.aptana.ide.editors.unified.folding.FoldingExtensionPointLoader;
import com.aptana.ide.views.model.ModelContributer;
import com.aptana.ide.views.outline.UnifiedOutlinePage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class JSEditor
extends UnifiedEditor {
    private static final String JSCOMMENT = "JSCOMMENT";
    private static final String SDCOMMENT = "SDCOMMENT";
    private boolean _isDisposing = false;
    private boolean _toolbarEnabled;
    private JSContributor _contributor;
    private ToolbarWidget _toolbar;
    private Composite _displayArea;

    public JSEditor() {
        this(true);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"com.aptana.ide.editors.UnifiedEditorsScope", "com.aptana.ide.editors.JSEditorScope"});
    }

    public JSEditor(boolean toolbarEnabled) {
        this.addPluginToPreferenceStore(JSPlugin.getDefault());
        this._toolbarEnabled = toolbarEnabled;
    }

    protected IUnifiedEditorContributor createLocalContributor() {
        this._contributor = new JSContributor();
        return this._contributor;
    }

    public IFileServiceFactory getFileServiceFactory() {
        return JSFileServiceFactory.getInstance();
    }

    public UnifiedOutlinePage getOutlinePage() {
        UnifiedOutlinePage result;
        if (this.outlinePage == null || this.outlinePage.getControl() != null && this.outlinePage.getControl().isDisposed()) {
            result = super.getOutlinePage();
            if ("true".equals(System.getProperty("environment.outline", "false"))) {
                ModelContributer outlineTab = new ModelContributer();
                result.addOutline((ContributedOutline)outlineTab, "Model");
            }
        } else {
            result = super.getOutlinePage();
        }
        return result;
    }

    public IContextAwareness getContextAwareness() {
        return JSContextAwareness.getInstance((IUnifiedEditor)this);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        if (this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
            this.getSourceViewer().getTextWidget().redraw();
        }
    }

    public String getDefaultFileExtension() {
        return "js";
    }

    public void dispose() {
        if (this._isDisposing) {
            return;
        }
        this._isDisposing = true;
        if (this._contributor != null) {
            this._contributor.dispose();
        }
        if (this._toolbar != null) {
            this._toolbar.dispose();
        }
        super.dispose();
    }

    protected String[] collectContextMenuPreferencePages() {
        return new String[]{"com.aptana.ide.editor.js.preferences.GeneralPreferencePage", "com.aptana.ide.editor.js.preferences.ColorizationPreferencePage", "com.aptana.ide.editor.js.preferences.FoldingPreferencePage", "com.aptana.ide.editor.js.preferences.ProblemsPreferencePage", "com.aptana.ide.editor.js.preferences.CodeAssistPreferencePage", "com.aptana.ide.editor.js.preferences.FormatterPreferencePage", "com.aptana.ide.editor.js.preferences.TypingPreferencePage", "com.aptana.ide.editor.scriptdoc.preferences.GeneralPreferencePage", "com.aptana.ide.editor.scriptdoc.preferences.ColorizationPreferencePage", "org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.Annotations", "org.eclipse.ui.editors.preferencePages.QuickDiff", "org.eclipse.ui.editors.preferencePages.Accessibility", "org.eclipse.ui.editors.preferencePages.Spelling", "org.eclipse.ui.editors.preferencePages.LinkedModePreferencePage"};
    }

    protected boolean isNewInput(IEditorInput input) {
        JSDocumentProvider.JSFileInfo cuInfo = this.getJSFileInfo(input);
        if (cuInfo == null) {
            throw new RuntimeException(Messages.JSEditor_JSFileInfo_Not_Defined);
        }
        JSDocumentProvider dp = (JSDocumentProvider)this.getDocumentProvider();
        IDocument document = dp.getDocument(input);
        DocumentSourceProvider provider = new DocumentSourceProvider(document, input);
        if (provider == null) {
            throw new RuntimeException(Messages.JSEditor_Provider_Not_Defined);
        }
        return cuInfo.sourceProvider == null || !cuInfo.sourceProvider.equals(provider);
    }

    private JSDocumentProvider.JSFileInfo getJSFileInfo(IEditorInput input) {
        JSDocumentProvider dp = (JSDocumentProvider)this.getDocumentProvider();
        if (dp == null) {
            throw new RuntimeException(Messages.JSEditor_Document_Provider_Not_Defined);
        }
        return (JSDocumentProvider.JSFileInfo)dp.getFileInfoPublic(input);
    }

    protected void updateFileInfo(IEditorInput input, DocumentSourceProvider provider, IDocument document) {
        super.updateFileInfo(input, provider, document);
        if (this.isNewInput(input)) {
            this.getJSFileInfo((IEditorInput)input).sourceProvider = provider;
        }
    }

    public void createPartControl(Composite parent) {
        this._displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this._displayArea.setLayout((Layout)daLayout);
        this._displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        IPreferenceStore store = this.getPreferenceStore();
        boolean show = store.getBoolean("com.aptana.ide.editor.js.SHOW_JS_TOOLBAR");
        if (show && this._toolbarEnabled) {
            this._toolbar = new ToolbarWidget(new String[]{"text/javascript"}, new String[]{"text/javascript"}, this.getPreferenceStore(), "com.aptana.ide.editor.js.LINK_CURSOR_WITH_JS_TOOLBAR_TAB", (IUnifiedEditor)this);
            this._toolbar.createControl(this._displayArea);
        }
        Composite editorArea = new Composite(this._displayArea, 0);
        editorArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout eaLayout = new GridLayout(1, true);
        eaLayout.marginHeight = 0;
        eaLayout.marginWidth = 0;
        editorArea.setLayout((Layout)new FillLayout());
        super.createPartControl(editorArea);
    }

    public IDocumentProvider createDocumentProvider() {
        return JSDocumentProvider.getInstance();
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        IMenuManager findMenuUsingPath = menu.findMenuUsingPath("projection");
        if (findMenuUsingPath != null) {
            findMenuUsingPath.add((IAction)new Action(Messages.JSEditor_CollapseComments, 1){

                public void run() {
                    ProjectionViewer viewer2 = (ProjectionViewer)JSEditor.this.getViewer();
                    FoldingExtensionPointLoader.collapseAll((ProjectionAnnotationModel)viewer2.getProjectionAnnotationModel(), (String)"text/javascript", (String)JSEditor.JSCOMMENT);
                    FoldingExtensionPointLoader.collapseAll((ProjectionAnnotationModel)viewer2.getProjectionAnnotationModel(), (String)"text/javascript", (String)JSEditor.SDCOMMENT);
                }
            });
            findMenuUsingPath.add((IAction)new Action(Messages.JSEditor_ExpandComments, 1){

                public void run() {
                    ProjectionViewer viewer2 = (ProjectionViewer)JSEditor.this.getViewer();
                    FoldingExtensionPointLoader.expandAll((ProjectionAnnotationModel)viewer2.getProjectionAnnotationModel(), (String)"text/javascript", (String)JSEditor.JSCOMMENT);
                    FoldingExtensionPointLoader.expandAll((ProjectionAnnotationModel)viewer2.getProjectionAnnotationModel(), (String)"text/javascript", (String)JSEditor.SDCOMMENT);
                }
            });
        }
    }

    public boolean isNeverShowToolbar() {
        return !this._toolbarEnabled;
    }
}

