/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml.validator;

import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.colorizer.ColorizerReader;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.UnifiedErrorReporter;
import com.aptana.ide.editors.validator.ValidatorBase;
import com.aptana.xml.IErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ColorizationValidator
extends ValidatorBase
implements IErrorHandler {
    private UnifiedErrorReporter _reporter;
    private String _path;
    private boolean _collectErrors;
    private boolean _collectWarnings;
    private boolean _collectInfos;

    public IFileError[] parseForErrors(String path, String source, IFileSourceProvider sourceProvider, boolean collectErrors, boolean collectWarnings, boolean collectInfos) {
        this._path = path;
        this._collectErrors = collectErrors;
        this._collectWarnings = collectWarnings;
        this._collectInfos = collectInfos;
        this._reporter = new UnifiedErrorReporter(sourceProvider);
        ColorizerReader reader = new ColorizerReader();
        reader.setErrorHandler((IErrorHandler)this);
        ByteArrayInputStream in = new ByteArrayInputStream(source.getBytes());
        reader.loadLanguageColorizer((InputStream)in, false);
        return this._reporter.getErrors();
    }

    public void handleError(int line, int column, String message) {
        if (this._collectErrors) {
            this._reporter.error(message, this._path, line + 1, "", column);
        }
    }

    public void handleInfo(int line, int column, String message) {
        if (this._collectInfos) {
            this._reporter.info(message, this._path, line + 1, "", column);
        }
    }

    public void handleWarning(int line, int column, String message) {
        if (this._collectWarnings) {
            this._reporter.warning(message, this._path, line + 1, "", column);
        }
    }
}

