/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml.parsing;

import com.aptana.ide.editor.xml.parsing.XMLParserBase;
import com.aptana.ide.editor.xml.parsing.nodes.XMLDeclarationNode;
import com.aptana.ide.editor.xml.parsing.nodes.XMLElementNode;
import com.aptana.ide.editor.xml.parsing.nodes.XMLParseNode;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.IParseNodeAttribute;
import com.aptana.ide.parsing.nodes.ParseRootNode;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Stack;

public class XMLParser
extends XMLParserBase {
    private static final int[] elementEndSet = new int[]{30, 38};
    private Stack<IParseNode> _elementStack = new Stack();

    static {
        Arrays.sort(elementEndSet);
    }

    public XMLParser() throws ParserInitializationException {
        this("text/xml");
    }

    public XMLParser(String mimeType) throws ParserInitializationException {
        super(mimeType);
    }

    private void closeElement() {
        if (this._currentElement != null) {
            this._currentElement.includeLexemeInRange(this.currentLexeme);
        }
        this._currentElement = this._elementStack.size() > 0 ? this._elementStack.pop() : null;
    }

    private XMLParseNode createNode(int type, Lexeme startingLexeme) {
        return (XMLParseNode)this.getParseNodeFactory().createParseNode(type, startingLexeme);
    }

    private void openElement(XMLElementNode element) {
        if (this._currentElement != null) {
            this._currentElement.appendChild((IParseNode)element);
        }
        this._elementStack.push(this._currentElement);
        this._currentElement = element;
    }

    public synchronized void parseAll(IParseNode parentNode) throws LexerException {
        this._elementStack.clear();
        this._currentElement = parentNode;
        ILexer lexer = this.getLexer();
        lexer.setLanguageAndGroup(this.getLanguage(), "default");
        try {
            this.parseText(false);
        }
        catch (ParseException parseException) {
            lexer.setGroup("default");
        }
        while (!this.isEOS()) {
            try {
                switch (this.currentLexeme.typeIndex) {
                    case 24: {
                        this.parseCDATASection();
                        break;
                    }
                    case 2: {
                        this.parseText(false);
                        break;
                    }
                    case 25: {
                        this.parseDocTypeDeclaration();
                        break;
                    }
                    case 27: {
                        this.parseEndTag();
                        break;
                    }
                    case 33: {
                        this.parsePI();
                        this.parseText(false);
                        break;
                    }
                    case 40: {
                        this.parseStartTag();
                        break;
                    }
                    case 41: {
                        this.parseXMLDeclaration();
                        break;
                    }
                    default: {
                        this.advance();
                        break;
                    }
                }
            }
            catch (ParseException parseException) {
                lexer.setGroup("default");
            }
        }
    }

    private void parseAttribute() throws ParseException, LexerException {
        String name = this.currentLexeme.getText();
        this.assertAndAdvance(42, "error.attribute");
        this.assertAndAdvance(29, "error.attribute.equal");
        this.assertType(43, "error.attribute.value");
        if (this.currentLexeme.getCategoryIndex() != 0) {
            String value = this.currentLexeme.getText();
            char firstChar = value.charAt(0);
            int quoteType = 0;
            if (firstChar == '\"') {
                value = value.substring(1, value.length() - 1);
                quoteType = 1;
            } else if (firstChar == '\'') {
                value = value.substring(1, value.length() - 1);
                quoteType = 2;
            }
            this._currentElement.setAttribute(name, value);
            IParseNodeAttribute attr = this._currentElement.getAttributeNode(name);
            attr.setQuoteType(quoteType);
        }
        this.advance();
    }

    private void parseCDATASection() throws LexerException, ParseException {
        ILexer lexer = this.getLexer();
        lexer.setGroup("cdata-section");
        this.assertAndAdvance(24, "error.cdata");
        this.assertAndAdvance(23, "error.cdata.close");
    }

    private void parseEndTag() throws LexerException, ParseException {
        this.assertAndAdvance(27, "error.tag.end");
        this.closeElement();
        this.parseText(true);
    }

    private void parsePI() throws LexerException, ParseException {
        ILexer lexer = this.getLexer();
        lexer.setGroup("processing-instruction");
        this.assertAndAdvance(33, "error.pi");
        this.assertAndAdvance(23, "error.pi.close");
    }

    private void parseStartTag() throws ParseException, LexerException {
        this.assertType(40, "error.tag.start");
        XMLElementNode element = (XMLElementNode)this.createNode(3, this.currentLexeme);
        this.openElement(element);
        this.advance();
        while (!this.isEOS() && !this.inSet(elementEndSet)) {
            this.parseAttribute();
        }
        switch (this.currentLexeme.typeIndex) {
            case 30: {
                break;
            }
            case 38: {
                this.closeElement();
                break;
            }
            default: {
                this.throwParseError("error.tag.start.unclosed");
            }
        }
        this.parseText(false);
    }

    private XMLDeclarationNode parseXMLDeclaration() throws LexerException, ParseException {
        this.getLexer().setGroup("xml-declaration");
        XMLDeclarationNode decl = (XMLDeclarationNode)this.createNode(2, this.currentLexeme);
        this.assertAndAdvance(41, "error.xml.declaration");
        decl.setVersion(this.currentLexeme.getText());
        if (this._currentElement instanceof ParseRootNode) {
            this._currentElement.appendChild((IParseNode)decl);
        }
        this.assertAndAdvance(52, "error.xml.declaration.version");
        if (this.isType(50)) {
            decl.setEncoding(this.currentLexeme.getText());
            this.advance();
        }
        if (this.isType(51)) {
            decl.setStandalone(this.currentLexeme.getText());
            this.advance();
        }
        this.getLexer().setGroup("default");
        this.assertAndAdvance(36, "error.xml.declaration.close");
        return decl;
    }
}

