/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.xml.Messages;
import com.aptana.ide.editor.xml.XMLErrorManager;
import com.aptana.ide.editor.xml.XMLFileLanguageService;
import com.aptana.ide.editor.xml.XMLPlugin;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.BaseFileServiceFactory;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.ParentOffsetMapper;
import com.aptana.ide.editors.unified.errors.IErrorManager;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import org.eclipse.core.runtime.Plugin;

public final class XMLFileServiceFactory
extends BaseFileServiceFactory {
    private static XMLFileServiceFactory instance;

    private XMLFileServiceFactory() {
    }

    protected IParser createScanner() {
        IParser result = null;
        if (UnifiedEditorsPlugin.getDefault().useFastScan()) {
            result = LanguageRegistry.getScanner((String)"text/xml");
        }
        return result;
    }

    public static XMLFileServiceFactory getInstance() {
        if (instance == null) {
            instance = new XMLFileServiceFactory();
        }
        return instance;
    }

    public FileService createFileService(IFileSourceProvider sourceProvider, boolean parse) {
        IParser parser = this.createParser();
        IParser scanner = this.createScanner();
        IParseState parseState = parser.createParseState(null);
        FileService fileService = new FileService(parser, parseState, sourceProvider, "text/xml");
        fileService.setScanner(scanner);
        fileService.setErrorManager((IErrorManager)new XMLErrorManager(fileService));
        ParentOffsetMapper mapper = new ParentOffsetMapper(fileService);
        XMLFileLanguageService languageService = new XMLFileLanguageService(fileService, parseState, parser, (IParentOffsetMapper)mapper);
        fileService.addLanguageService("text/xml", (IFileLanguageService)languageService);
        if (parse) {
            fileService.doFullParse();
        }
        return fileService;
    }

    protected IParser createParser() {
        IParser parser = LanguageRegistry.getParser((String)"text/xml");
        if (parser == null) {
            IdeLog.logError((Plugin)XMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.XMLFileServiceFactory_ERR_CreateParser, (String)"text/xml"));
        }
        return parser;
    }
}

