/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.util;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.model.IJSScriptElement;
import com.aptana.ide.debug.core.model.ISourceLink;
import com.aptana.ide.debug.internal.ui.util.Messages;
import com.aptana.ide.debug.internal.ui.util.SourceDisplayUtil;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.UIJob;

public class SourceDisplayAdapter
implements InvocationHandler {
    private static final String DEFAULT_SOURCE_LOCATOR_ID = "com.aptana.ide.debug.core.sourceLookupDirector";
    private static final String DEFAULT_SOURCE_PATH_COMPUTER_ID = "com.aptana.ide.debug.core.sourcePathComputer";
    private static Class clazz;
    private static Object fInstance;
    private SourceLookupJob fSourceLookupJob = new SourceLookupJob();
    private SourceDisplayJob fSourceDisplayJob = new SourceDisplayJob();
    private ISourceLocator fDefaultSourceLocator;

    static {
        try {
            clazz = Class.forName("org.eclipse.debug.ui.sourcelookup.ISourceDisplay");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(Messages.getString("SourceDisplayAdapter.3"));
            }
            catch (ClassNotFoundException classNotFoundException2) {}
        }
    }

    private SourceDisplayAdapter() {
    }

    public static synchronized Object getInstance() {
        if (fInstance == null) {
            fInstance = Proxy.newProxyInstance(SourceDisplayAdapter.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new SourceDisplayAdapter());
        }
        return fInstance;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        method = this.getClass().getMethod(method.getName(), method.getParameterTypes());
        return method.invoke((Object)this, args);
    }

    public void displaySource(Object element, IWorkbenchPage page, boolean forceSourceLookup) {
        this.fSourceLookupJob.setLookupInfo(element, element instanceof IDebugElement ? this.getSourceLocator((IDebugElement)element) : null, page);
        this.fSourceLookupJob.schedule();
    }

    private ISourceLocator getSourceLocator(IDebugElement debugElement) {
        ISourceLocator sourceLocator = null;
        if (debugElement.getDebugTarget() == null) {
            if (debugElement instanceof ISourceLink) {
                sourceLocator = this.getDefaultSourceLocator();
            }
            return sourceLocator;
        }
        ILaunch launch = debugElement.getLaunch();
        if (launch != null) {
            sourceLocator = launch.getSourceLocator();
        }
        return sourceLocator;
    }

    private ISourceLocator getDefaultSourceLocator() {
        if (this.fDefaultSourceLocator == null) {
            try {
                this.fDefaultSourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(DEFAULT_SOURCE_LOCATOR_ID);
                if (this.fDefaultSourceLocator instanceof ISourceLookupDirector) {
                    ISourceLookupDirector sourceLookupDirector = (ISourceLookupDirector)this.fDefaultSourceLocator;
                    sourceLookupDirector.initializeParticipants();
                    sourceLookupDirector.setSourceContainers(new ISourceContainer[]{new DefaultSourceContainer(){

                        protected ISourceContainer[] createSourceContainers() throws CoreException {
                            ISourcePathComputer sourcePathComputer = null;
                            ISourceLookupDirector director = this.getDirector();
                            if (director != null) {
                                sourcePathComputer = director.getSourcePathComputer();
                            }
                            if (sourcePathComputer != null) {
                                return sourcePathComputer.computeSourceContainers(null, null);
                            }
                            return new ISourceContainer[0];
                        }
                    }});
                    ISourcePathComputer sourcePathComputer = DebugPlugin.getDefault().getLaunchManager().getSourcePathComputer(DEFAULT_SOURCE_PATH_COMPUTER_ID);
                    sourceLookupDirector.setSourcePathComputer(sourcePathComputer);
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (String)"", (Throwable)e);
            }
        }
        return this.fDefaultSourceLocator;
    }

    public static class Factory
    implements IAdapterFactory {
        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (adapterType == clazz) {
                return SourceDisplayAdapter.getInstance();
            }
            return null;
        }

        public Class[] getAdapterList() {
            return new Class[]{clazz};
        }
    }

    private class SourceDisplayJob
    extends UIJob {
        private ISourceLookupResult fResult;
        private IWorkbenchPage fPage;

        public SourceDisplayJob() {
            super("Debug Source Display");
            this.setSystem(true);
            this.setPriority(10);
        }

        public synchronized void setDisplayInfo(ISourceLookupResult result, IWorkbenchPage page) {
            this.fResult = result;
            this.fPage = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            ISourceLookupResult result = null;
            IWorkbenchPage page = null;
            SourceDisplayJob sourceDisplayJob = this;
            synchronized (sourceDisplayJob) {
                result = this.fResult;
                page = this.fPage;
                this.setDisplayInfo(null, null);
            }
            if (!monitor.isCanceled() && result != null && page != null) {
                if (result.getEditorInput() == null) {
                    MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)Messages.getString("SourceDisplayAdapter.Error_Opening_Source"), (String)StringUtils.format((String)Messages.getString("SourceDisplayAdapter.Source_Not_Located"), (String)DebugUiPlugin.getDefault().getModelPresentation().getText(result.getArtifact())));
                    return Status.CANCEL_STATUS;
                }
                if (result.getArtifact() instanceof ISourceLink) {
                    boolean oldReuseValue = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.reuse_editor");
                    DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.reuse_editor", false);
                    DebugUITools.displaySource((ISourceLookupResult)result, (IWorkbenchPage)page);
                    DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.reuse_editor", oldReuseValue);
                } else {
                    DebugUITools.displaySource((ISourceLookupResult)result, (IWorkbenchPage)page);
                }
                if (result.getArtifact() instanceof IJSScriptElement) {
                    IEditorPart editorPart;
                    int lineNumber = ((IJSScriptElement)result.getArtifact()).getBaseLine();
                    IEditorInput editorInput = result.getEditorInput();
                    if (editorInput != null && lineNumber > 0 && (editorPart = SourceDisplayUtil.findEditor(editorInput)) != null) {
                        SourceDisplayUtil.revealLineInEditor(editorPart, lineNumber);
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }

    private class SourceLookupJob
    extends Job {
        private Object fTarget;
        private ISourceLocator fLocator;
        private IWorkbenchPage fPage;

        public SourceLookupJob() {
            super("Debug Source Lookup");
            this.setPriority(10);
            this.setSystem(true);
        }

        public void setLookupInfo(Object target, ISourceLocator locator, IWorkbenchPage page) {
            this.fTarget = target;
            this.fLocator = locator;
            this.fPage = page;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                Object lookupObject = this.fTarget;
                ISourceLocator lookupLocator = this.fLocator;
                if (!(lookupObject == null || lookupLocator == null || lookupObject instanceof IStackFrame && ((IStackFrame)lookupObject).isTerminated())) {
                    ISourceLookupResult result = null;
                    result = DebugUITools.lookupSource((Object)lookupObject, (ISourceLocator)lookupLocator);
                    if (!(monitor.isCanceled() || this.fPage == null || lookupObject instanceof IStackFrame && ((IStackFrame)lookupObject).isTerminated())) {
                        SourceDisplayAdapter.this.fSourceDisplayJob.setDisplayInfo(result, this.fPage);
                        SourceDisplayAdapter.this.fSourceDisplayJob.schedule();
                    }
                }
                this.setLookupInfo(null, null, null);
            }
            return Status.OK_STATUS;
        }
    }
}

