/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.console;

import com.aptana.ide.debug.internal.ui.console.JSConsoleHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class JSConsoleTracker
implements IPatternMatchListenerDelegate {
    private TextConsole fConsole;

    public void connect(TextConsole console) {
        this.fConsole = console;
    }

    public void disconnect() {
        this.fConsole = null;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            int lineNumber = 0;
            String text = this.getMatchText(event);
            int index = text.lastIndexOf(58);
            try {
                lineNumber = Integer.parseInt(text.substring(index + 1));
            }
            catch (NumberFormatException numberFormatException) {}
            text = text.substring(0, index);
            JSConsoleHyperlink link = new JSConsoleHyperlink(this.fConsole, text, lineNumber);
            this.fConsole.addHyperlink((IHyperlink)link, event.getOffset() + 1, event.getLength() - 2);
        }
        catch (BadLocationException badLocationException) {}
    }

    private String getMatchText(PatternMatchEvent event) throws BadLocationException {
        IDocument document = ((TextConsole)event.getSource()).getDocument();
        int lineNumber = document.getLineOfOffset(event.getOffset());
        IRegion lineInformation = document.getLineInformation(lineNumber);
        int lineOffset = lineInformation.getOffset();
        String line = document.get(lineOffset, lineInformation.getLength());
        int beginIndex = event.getOffset() - lineOffset + 1;
        line = line.substring(beginIndex, beginIndex + event.getLength() - 2);
        return line;
    }
}

