/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.debug.core.model.JSInspectExpression;
import com.aptana.ide.debug.internal.ui.actions.InspectAction;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class PopupInspectAction
extends InspectAction
implements IInformationProvider {
    public static final String ACTION_DEFININIITION_ID = "com.aptana.ide.debug.ui.commands.Inspect";
    private ITextViewer viewer;
    private JSInspectExpression expression;
    private InformationPresenter fInformationPresenter;

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        return "not null";
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        return this.getRegion();
    }

    protected void showPopup(IWatchExpressionResult result) {
        try {
            Class.forName("org.eclipse.debug.ui.InspectPopupDialog");
            this.showPopup32(result);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.showPopup31(result);
        }
    }

    private void showPopup32(IWatchExpressionResult result) {
        this.expression = new JSInspectExpression(result);
        Window displayPopup = null;
        try {
            Class<?> clazz = Class.forName("org.eclipse.debug.ui.InspectPopupDialog");
            Constructor<?> constructor = clazz.getConstructor(Shell.class, Point.class, String.class, IExpression.class);
            displayPopup = (Window)constructor.newInstance(this.getShell(), PopupInspectAction.getPopupAnchor(this.viewer), ACTION_DEFININIITION_ID, this.expression);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (String)"", (Throwable)e);
        }
        if (displayPopup != null) {
            displayPopup.open();
        }
    }

    private void showPopup31(final IWatchExpressionResult result) {
        final InformationPresenter infoPresenter = new InformationPresenter(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                IWorkbenchPage page = DebugUiPlugin.getActivePage();
                PopupInspectAction.this.expression = new JSInspectExpression(result);
                IInformationControl control = null;
                try {
                    Class<?> clazz = Class.forName("org.eclipse.debug.internal.ui.views.expression.ExpressionInformationControl");
                    Constructor<?> constructor = clazz.getConstructor(IWorkbenchPage.class, IExpression.class, String.class);
                    control = (IInformationControl)constructor.newInstance(page, PopupInspectAction.this.expression, PopupInspectAction.ACTION_DEFININIITION_ID);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (String)"", (Throwable)e);
                }
                if (control != null) {
                    control.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            PopupInspectAction.this.getInformationPresenter().uninstall();
                        }
                    });
                }
                return control;
            }
        });
        this.setInformationPresenter(infoPresenter);
        DebugUiPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                if (PopupInspectAction.this.viewer != null) {
                    Point p = PopupInspectAction.this.viewer.getSelectedRange();
                    IDocument doc = PopupInspectAction.this.viewer.getDocument();
                    try {
                        try {
                            String contentType = TextUtilities.getContentType((IDocument)doc, (String)infoPresenter.getDocumentPartitioning(), (int)p.x, (boolean)true);
                            infoPresenter.setInformationProvider((IInformationProvider)PopupInspectAction.this, contentType);
                            infoPresenter.install(PopupInspectAction.this.viewer);
                            infoPresenter.showInformation();
                        }
                        catch (BadLocationException badLocationException) {
                            PopupInspectAction.this.viewer = null;
                            return;
                        }
                    }
                    finally {
                        PopupInspectAction.this.viewer = null;
                    }
                }
            }
        });
    }

    protected void displayResult(IWatchExpressionResult result) {
        IWorkbenchPart part = this.getTargetPart();
        this.viewer = (ITextViewer)part.getAdapter(ITextViewer.class);
        if (this.viewer == null && part instanceof IUnifiedEditor) {
            this.viewer = ((IUnifiedEditor)part).getViewer();
        }
        if (this.viewer == null) {
            super.displayResult(result);
        } else {
            this.showPopup(result);
        }
    }

    private IWorkbenchPart getTargetPart() {
        return DebugUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
    }

    private InformationPresenter getInformationPresenter() {
        return this.fInformationPresenter;
    }

    private void setInformationPresenter(InformationPresenter informationPresenter) {
        this.fInformationPresenter = informationPresenter;
    }

    protected IRegion getRegion() {
        Point point = this.viewer.getSelectedRange();
        return new Region(point.x, point.y);
    }

    private Shell getShell() {
        if (this.getTargetPart() != null) {
            return this.getTargetPart().getSite().getShell();
        }
        return DebugUiPlugin.getActiveWorkbenchShell();
    }

    private static Point getPopupAnchor(ITextViewer viewer) {
        StyledText textWidget = viewer.getTextWidget();
        Point docRange = textWidget.getSelectionRange();
        int midOffset = docRange.x + docRange.y / 2;
        Point point = textWidget.getLocationAtOffset(midOffset);
        point = textWidget.toDisplay(point);
        GC gc = new GC((Drawable)textWidget);
        gc.setFont(textWidget.getFont());
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        point.y += height;
        return point;
    }
}

