/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.wizards;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.wizards.Messages;
import com.aptana.ide.ui.io.IOUIPlugin;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SyncImportPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    private Text pathText;
    private Button browseButton;

    protected SyncImportPage() {
        super("importSync");
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.pathText.getText().trim().length() > 0);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        String result = dialog.open();
        if (result != null) {
            this.pathText.setText(result);
        }
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(main, 0);
        label.setText(Messages.SyncImportPage_FROM_FILE);
        this.pathText = new Text(main, 2048);
        this.pathText.setText(SyncImportPage.getPreferenceStore().getString("EXPORT_INITIAL_PATH"));
        this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pathText.addModifyListener((ModifyListener)this);
        this.browseButton = new Button(main, 8);
        this.browseButton.setText(StringUtils.ellipsify((String)CoreStrings.BROWSE));
        this.browseButton.addSelectionListener((SelectionListener)this);
        this.setTitle(Messages.SyncImportPage_TITLE);
        this.setDescription(Messages.SyncImportPage_DESCRIPTION);
        this.setControl((Control)main);
    }

    public boolean performFinish() {
        String path = this.pathText.getText();
        File file = new File(path);
        if (!file.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SyncImportPage_FILE_NOT_EXIST, (String)StringUtils.format((String)Messages.SyncImportPage_FILE_NOT_EXIST_DESC, (String)file.getAbsolutePath()));
            return false;
        }
        if (!file.canRead()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SyncImportPage_FILE_NOT_READABLE, (String)StringUtils.format((String)Messages.SyncImportPage_FILE_NOT_READABLE_DESC, (String)file.getAbsolutePath()));
            return false;
        }
        SyncingPlugin.getSiteConnectionManager().loadState((IPath)new Path(path));
        IOUIPlugin.refreshNavigatorView(null);
        SyncImportPage.getPreferenceStore().setValue("EXPORT_INITIAL_PATH", path);
        return true;
    }

    private static IPreferenceStore getPreferenceStore() {
        return SyncingUIPlugin.getDefault().getPreferenceStore();
    }
}

