/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.wizards;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.wizards.Messages;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SyncExportPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    private Text pathText;
    private Button browseButton;
    private Button overwriteButton;

    public SyncExportPage() {
        super("exportSync");
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.pathText.getText().trim().length() > 0);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        String result = dialog.open();
        if (result != null) {
            this.pathText.setText(result);
        }
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(main, 0);
        label.setText(Messages.SyncExportPage_TO_FILE);
        this.pathText = new Text(main, 2048);
        this.pathText.setText(SyncExportPage.getPreferenceStore().getString("EXPORT_INITIAL_PATH"));
        this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pathText.addModifyListener((ModifyListener)this);
        this.browseButton = new Button(main, 8);
        this.browseButton.setText(StringUtils.ellipsify((String)CoreStrings.BROWSE));
        this.browseButton.addSelectionListener((SelectionListener)this);
        Group group = new Group(main, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.SyncExportPage_OPTIONS);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        this.overwriteButton = new Button((Composite)group, 32);
        this.overwriteButton.setText(Messages.SyncExportPage_NO_WARNING);
        this.overwriteButton.setSelection(SyncExportPage.getPreferenceStore().getBoolean("OVEWRITE_FILE_WITHOUT_WARNING"));
        this.setTitle(Messages.SyncExportPage_TITLE);
        this.setDescription(Messages.SyncExportPage_DESCRIPTION);
        this.setControl((Control)main);
    }

    public boolean performFinish() {
        String path = this.pathText.getText();
        boolean overwrite = this.overwriteButton.getSelection();
        File file = new File(path);
        if (file.exists()) {
            if (!overwrite && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.SyncExportPage_Overwrite, (String)StringUtils.format((String)Messages.SyncExportPage_Confirm_Overwrite, (String)file.getAbsolutePath()))) {
                return false;
            }
            if (!file.canWrite()) {
                MessageDialog.openError((Shell)this.pathText.getShell(), (String)Messages.SyncExportPage_Error, (String)StringUtils.format((String)Messages.SyncExportPage_NOT_WRITABLE, (String)file.getAbsolutePath()));
                return false;
            }
        }
        SyncingPlugin.getSiteConnectionManager().saveState((IPath)new Path(path));
        SyncExportPage.getPreferenceStore().setValue("EXPORT_INITIAL_PATH", path);
        SyncExportPage.getPreferenceStore().setValue("OVEWRITE_FILE_WITHOUT_WARNING", overwrite);
        return true;
    }

    private static IPreferenceStore getPreferenceStore() {
        return SyncingUIPlugin.getDefault().getPreferenceStore();
    }
}

