/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.wizards;

import com.aptana.ide.core.io.ConnectionPointUtils;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.SiteConnectionUtils;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.actions.DownloadAction;
import com.aptana.ide.syncing.ui.wizards.Messages;
import com.aptana.ide.syncing.ui.wizards.RemoteConnectionSelectionPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class RemoteProjectWizard
extends Wizard
implements IExecutableExtension,
INewWizard {
    public static final String ID = "com.aptana.ide.syncing.ui.wizards.RemoteProjectWizard";
    private WizardNewProjectCreationPage mainPage;
    private RemoteConnectionSelectionPage connectionPage;
    private IProject newProject;
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private IConfigurationElement fConfigElement;

    public RemoteProjectWizard() {
        this.setWindowTitle(Messages.RemoteProjectWizard_TTL_ConnectHostedSiteWizard);
    }

    public boolean performFinish() {
        final IProject p = this.createNewProject();
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    RemoteProjectWizard.this.createProject(p, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        IPath newPath = null;
        if (!this.mainPage.useDefaults()) {
            newPath = this.mainPage.getLocationPath();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        description.setNatureIds(new String[]{"com.aptana.ide.project.remote.nature"});
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                if (monitor != null) {
                    monitor.beginTask(Messages.RemoteProjectWizard_MSG_CreatingRemoteProject, 1);
                }
                RemoteProjectWizard.this.createProject(description, newProjectHandle, monitor);
                if (monitor != null) {
                    monitor.worked(1);
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_caseVariantExistsError, (Object)newProjectHandle.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                IDEWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.ide", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_internalError, (Object)t.getMessage()));
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    private void createProject(IProjectDescription description, final IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            IConnectionPoint site = this.connectionPage.getSite();
            if (site == null) {
                return;
            }
            IConnectionPoint source = ConnectionPointUtils.findOrCreateWorkspaceConnectionPoint((IContainer)projectHandle);
            CoreIOPlugin.getConnectionPointManager().addConnectionPoint(source);
            ISiteConnection connection = SiteConnectionUtils.createSite((String)projectHandle.getName(), (IConnectionPoint)source, (IConnectionPoint)site);
            SyncingPlugin.getSiteConnectionManager().addSiteConnection(connection);
            if (this.connectionPage.isSynchronize()) {
                UIJob syncJob = new UIJob(Messages.RemoteProjectWizard_UIJOB_Synchronizing){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        DownloadAction action = new DownloadAction();
                        action.setActivePart(null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
                        action.setSelection((ISelection)new StructuredSelection((Object)projectHandle));
                        action.run(null);
                        return Status.OK_STATUS;
                    }
                };
                syncJob.schedule();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void createProject(IProject p, IProgressMonitor monitor) {
        if (this.newProject == null) {
            return;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        BasicNewResourceWizard.selectAndReveal((IResource)this.newProject, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        this.mainPage.setTitle(Messages.RemoteProjectWizard_TTL_CreateNewExistingHostedSiteProject);
        this.mainPage.setDescription(Messages.RemoteProjectWizard_LBL_CreateNameAndLocationForLocalProject);
        this.mainPage.setPageComplete(false);
        this.addPage((IWizardPage)this.mainPage);
        this.connectionPage = new RemoteConnectionSelectionPage(this.selection);
        this.connectionPage.setTitle(Messages.RemoteProjectWizard_TTL_SelectRemoteConnection);
        this.connectionPage.setPageComplete(false);
        this.addPage((IWizardPage)this.connectionPage);
        this.setDefaultPageImageDescriptor(SyncingUIPlugin.getImageDescriptor("icons/full/obj16/remote_project_wizard.gif"));
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfigElement = config;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }
}

