/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.wizards;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.IConnectionPointManager;
import com.aptana.ide.syncing.ui.wizards.Messages;
import com.aptana.ide.ui.IPropertyDialog;
import com.aptana.ide.ui.ftp.internal.FTPPropertyDialogProvider;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RemoteConnectionSelectionPage
extends WizardPage
implements SelectionListener {
    private Table connectionTable;
    private Button newSiteButton;
    private Button syncOnFinish;
    private boolean synchronize = true;
    private IConnectionPoint site;

    public RemoteConnectionSelectionPage(IStructuredSelection selection) {
        super("connectionPage");
        Object possibleSite;
        if (selection != null && (possibleSite = selection.getFirstElement()) != null && possibleSite instanceof IConnectionPoint) {
            this.site = (IConnectionPoint)possibleSite;
        }
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        Group connGroup = new Group(main, 0);
        connGroup.setText(Messages.RemoteConnectionSelectionPage_Connections);
        connGroup.setLayout((Layout)new GridLayout());
        connGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label((Composite)connGroup, 0);
        label.setText(Messages.RemoteConnectionSelectionPage_LBL_SelectRemoteLocationOfThisProject);
        this.connectionTable = new Table((Composite)connGroup, 67620);
        this.connectionTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TableItem item;
                    TableItem[] items;
                    TableItem[] tableItemArray = items = RemoteConnectionSelectionPage.this.connectionTable.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        item = tableItemArray[n2];
                        if (item != e.item) {
                            item.setChecked(false);
                        }
                        ++n2;
                    }
                    item = (TableItem)e.item;
                    if (item.getChecked()) {
                        RemoteConnectionSelectionPage.this.setErrorMessage(null);
                        RemoteConnectionSelectionPage.this.setPageComplete(true);
                        RemoteConnectionSelectionPage.this.site = (IConnectionPoint)item.getData();
                    } else {
                        RemoteConnectionSelectionPage.this.setErrorMessage(Messages.RemoteConnectionSelectionPage_ERR_SelectSiteOrCreateNewOne);
                        RemoteConnectionSelectionPage.this.setPageComplete(false);
                    }
                }
            }
        });
        this.connectionTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.connectionTable.setLinesVisible(true);
        new TableColumn(this.connectionTable, 16384);
        this.connectionTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ScrollBar vScrolls;
                TableColumn c = RemoteConnectionSelectionPage.this.connectionTable.getColumn(0);
                Point size = RemoteConnectionSelectionPage.this.connectionTable.getSize();
                if (Platform.getOS().equals("macosx") && (vScrolls = RemoteConnectionSelectionPage.this.connectionTable.getVerticalBar()) != null) {
                    size.x = size.x - vScrolls.getSize().x - 10;
                }
                c.setWidth(size.x - 6);
            }
        });
        this.populateTable();
        if (this.site == null) {
            this.setErrorMessage(Messages.RemoteConnectionSelectionPage_ERR_SelectSiteOrCreateNewOne);
            this.setPageComplete(false);
        } else {
            this.checkItem(this.site);
        }
        this.newSiteButton = new Button((Composite)connGroup, 8);
        this.newSiteButton.setText(StringUtils.ellipsify((String)Messages.RemoteConnectionSelectionPage_LBL_NewConnection));
        this.newSiteButton.addSelectionListener((SelectionListener)this);
        Group options = new Group(main, 0);
        options.setText(Messages.RemoteConnectionSelectionPage_LBL_Options);
        options.setLayout((Layout)new GridLayout(1, true));
        options.setLayoutData((Object)new GridData(4, 4, true, false));
        this.syncOnFinish = new Button((Composite)options, 32);
        this.syncOnFinish.setText(Messages.RemoteConnectionSelectionPage_LBL_DownloadOnFinish);
        this.syncOnFinish.setSelection(this.isSynchronize());
        this.syncOnFinish.addSelectionListener((SelectionListener)this);
        this.setControl((Control)main);
    }

    private void checkItem(IConnectionPoint item) {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.connectionTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (ti.getData() == item) {
                ti.setChecked(true);
                this.site = item;
                this.setErrorMessage(null);
                this.setPageComplete(true);
                break;
            }
            ++n2;
        }
    }

    private void populateTable() {
        IConnectionPoint[] remoteSites;
        this.connectionTable.removeAll();
        IConnectionPointManager manager = CoreIOPlugin.getConnectionPointManager();
        IConnectionPoint[] iConnectionPointArray = remoteSites = manager.getConnectionPointCategory("com.aptana.ide.filesystem.ftp.ftpCategory").getConnectionPoints();
        int n = remoteSites.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionPoint site = iConnectionPointArray[n2];
            if (site instanceof IBaseRemoteConnectionPoint) {
                TableItem item = new TableItem(this.connectionTable, 0);
                item.setText(MessageFormat.format("{0}: {1}", manager.getType(site).getName(), site.getName()));
                item.setData((Object)site);
            }
            ++n2;
        }
    }

    public boolean isSynchronize() {
        return this.synchronize;
    }

    public void setSynchronize(boolean synchronize) {
        this.synchronize = synchronize;
    }

    public IConnectionPoint getSite() {
        return this.site;
    }

    public void setSite(IConnectionPoint site) {
        this.site = site;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.newSiteButton) {
            int ret;
            final Shell shell = this.getShell();
            Dialog dlg = new FTPPropertyDialogProvider().createPropertyDialog(new IShellProvider(){

                public Shell getShell() {
                    return shell;
                }
            });
            if (dlg instanceof IPropertyDialog) {
                ((IPropertyDialog)dlg).setPropertySource((Object)CoreIOPlugin.getConnectionPointManager().getType("ftp"));
            }
            if ((ret = dlg.open()) == 0) {
                this.populateTable();
                if (dlg instanceof IPropertyDialog) {
                    this.checkItem((IConnectionPoint)((IPropertyDialog)dlg).getPropertySource());
                }
            }
        } else if (source == this.syncOnFinish) {
            this.setSynchronize(this.syncOnFinish.getSelection());
        }
    }
}

