/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.views;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.syncing.VirtualFileSyncPair;
import com.aptana.ide.syncing.ui.views.ISmartSyncListener;
import com.aptana.ide.syncing.ui.views.Messages;
import com.aptana.ide.syncing.ui.views.SmartSyncEvent;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;

public class SmartSyncEventManager {
    private static SmartSyncEventManager manager;
    private ListenerList listeners = new ListenerList();

    private SmartSyncEventManager() {
    }

    public void addListener(ISmartSyncListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ISmartSyncListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void fireEvent(VirtualFileSyncPair[] completedPairs, IConnectionPoint sourceManager, IConnectionPoint destinationManager, String comment) {
        SmartSyncEvent event = new SmartSyncEvent();
        event.sourceManager = sourceManager;
        event.destinationManager = destinationManager;
        event.completedPairs = completedPairs;
        event.comment = comment;
        Object[] listens = this.listeners.getListeners();
        int i = 0;
        while (i < listens.length) {
            if (listens[i] instanceof ISmartSyncListener) {
                try {
                    ((ISmartSyncListener)listens[i]).smartSyncComplete(event);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)Messages.SmartSyncEventManager_ERR_ExceptionNotifyingSmartSyncListener, (Throwable)e);
                }
                catch (Error e) {
                    IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)Messages.SmartSyncEventManager_ERR_ErrorNotifyingSmartSyncListener, (Throwable)e);
                }
            }
            ++i;
        }
    }

    public static synchronized SmartSyncEventManager getManager() {
        if (manager == null) {
            manager = new SmartSyncEventManager();
        }
        return manager;
    }
}

