/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.views;

import com.aptana.ide.syncing.ui.internal.SyncUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConnectionPointLabelProvider
extends DecoratingLabelProvider
implements ITableLabelProvider {
    private int fSizeIndex = 1;
    private int fModificationIndex = 2;

    public ConnectionPointLabelProvider() {
        super((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
    }

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getImage(element);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(element);
        }
        if (columnIndex == this.fSizeIndex) {
            return ConnectionPointLabelProvider.getFilesize(element);
        }
        if (columnIndex == this.fModificationIndex) {
            return ConnectionPointLabelProvider.getLastModified(element);
        }
        return "";
    }

    public void setSizeIndex(int columnIndex) {
        this.fSizeIndex = columnIndex;
    }

    public void setModificationIndex(int columnIndex) {
        this.fModificationIndex = columnIndex;
    }

    private static String getFilesize(Object element) {
        IFileInfo fileInfo;
        long rawSize = -1L;
        if (element instanceof IResource) {
            rawSize = ((IResource)element).getLocation().toFile().length();
        } else if (element instanceof IAdaptable && (fileInfo = SyncUtils.getFileInfo((IAdaptable)element)) != null) {
            rawSize = fileInfo.getLength();
        }
        if (rawSize >= 0L) {
            long num;
            long leftover = 0L;
            String string = String.valueOf(Long.toString(rawSize)) + " B";
            if (rawSize > 1024L) {
                leftover = (rawSize /= 1024L) % 1024L;
                num = rawSize;
                if (leftover >= 512L) {
                    ++num;
                }
                string = String.valueOf(num) + " KB";
            }
            if (rawSize > 1024L) {
                leftover = (rawSize /= 1024L) % 1024L;
                num = rawSize;
                if (leftover >= 512L) {
                    ++num;
                }
                string = String.valueOf(num) + " MB";
            }
            if (rawSize > 1024L) {
                leftover = (rawSize /= 1024L) % 1024L;
                num = rawSize;
                if (leftover >= 512L) {
                    ++num;
                }
                string = String.valueOf(num) + " GB";
            }
            if (rawSize > 1024L) {
                leftover = (rawSize /= 1024L) % 1024L;
                num = rawSize;
                if (leftover >= 512L) {
                    ++num;
                }
                string = String.valueOf(num) + " TB";
            }
            return string;
        }
        return "";
    }

    private static String getLastModified(Object element) {
        IFileInfo fileInfo;
        long timestamp = -1L;
        if (element instanceof IResource) {
            timestamp = ((IResource)element).getLocalTimeStamp();
        } else if (element instanceof IAdaptable && (fileInfo = SyncUtils.getFileInfo((IAdaptable)element)) != null) {
            timestamp = fileInfo.getLastModified();
        }
        if (timestamp >= 0L) {
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
            return formatter.format(new Date(timestamp));
        }
        return "";
    }
}

