/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.preferences;

import com.aptana.ide.core.ui.preferences.FileExtensionPreferencePage;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.decorators.DecoratorUtils;
import com.aptana.ide.syncing.ui.preferences.Messages;
import com.aptana.ide.ui.io.IOUIPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class SyncPreferencePage
extends FileExtensionPreferencePage {
    public Object addItem() {
        CloakingInfoDialog dialog = new CloakingInfoDialog(this.getControl().getShell());
        if (dialog.open() == 0) {
            return dialog.messageText;
        }
        return null;
    }

    public Object editItem(Object item) {
        CloakingInfoDialog dialog = new CloakingInfoDialog(this.getControl().getShell());
        dialog.setItem(item);
        if (dialog.open() == 0) {
            return dialog.messageText;
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        String value = Platform.getPreferencesService().getString("com.aptana.ide.core.io", this.doGetPreferenceID(), ".svn;.tmp*~;.settings;CVS;.git;.DS_Store", null);
        this.doGetPreferenceStore().setValue(this.doGetPreferenceID(), value);
        return super.createContents(parent);
    }

    protected String getTableDescription() {
        return Messages.SyncPreferencePage_LBL_Description;
    }

    protected Plugin doGetPlugin() {
        return SyncingUIPlugin.getDefault();
    }

    protected String doGetPreferenceID() {
        return "GLOBAL_CLOAKING_EXTENSIONS";
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return IOUIPlugin.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        boolean ret = super.performOk();
        String value = this.doGetPreferenceStore().getString(this.doGetPreferenceID());
        IEclipsePreferences prefs = new InstanceScope().getNode("com.aptana.ide.core.io");
        prefs.put(this.doGetPreferenceID(), value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        DecoratorUtils.updateCloakDecorator();
        return ret;
    }

    private static class CloakingInfoDialog
    extends TitleAreaDialog {
        private Text message;
        private String messageText = "";

        public CloakingInfoDialog(Shell parentShell) {
            super(parentShell);
            this.setHelpAvailable(false);
        }

        public void setItem(Object item) {
            this.messageText = item.toString();
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.SyncPreferencePage_CloakInfo_Shell_Title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)new GridLayout(2, false));
            main.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(main, 16384);
            label.setText(Messages.SyncPreferencePage_CloakInfo_LBL);
            this.message = new Text(main, 2052);
            this.message.setText(this.messageText);
            this.message.setLayoutData((Object)new GridData(4, 4, true, false));
            this.message.setFocus();
            this.message.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    if (event.widget == CloakingInfoDialog.this.message) {
                        CloakingInfoDialog.this.getButton(0).setEnabled(CloakingInfoDialog.this.validateErrorDescriptor());
                    }
                }
            });
            Dialog.applyDialogFont((Control)main);
            this.setTitle(Messages.SyncPreferencePage_CloakInfo_Title);
            this.setMessage(Messages.SyncPreferencePage_CloakInfo_Message);
            return main;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.getButton(0).setEnabled(!this.messageText.equals(""));
        }

        private boolean validateErrorDescriptor() {
            if (this.message.getText().equals("")) {
                return false;
            }
            this.messageText = this.message.getText();
            return true;
        }
    }
}

