/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.actions;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.syncing.ConnectionPointSyncPair;
import com.aptana.ide.core.io.syncing.VirtualFileSyncPair;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.ui.actions.BaseSyncAction;
import com.aptana.ide.syncing.ui.actions.Messages;
import com.aptana.ide.syncing.ui.handlers.SyncEventHandlerAdapter;
import com.aptana.ide.syncing.ui.internal.SyncUtils;
import com.aptana.ide.syncing.ui.views.SmartSyncDialog;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.MessageBox;

public class SynchronizeFilesAction
extends BaseSyncAction {
    private static String MESSAGE_TITLE = StringUtils.ellipsify((String)Messages.SynchronizeFilesAction_MessageTitle);

    protected void performAction(final IAdaptable[] files, ISiteConnection site) throws CoreException {
        final IConnectionPoint source = site.getSource();
        final IConnectionPoint dest = site.getDestination();
        CoreUIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IFileStore[] fileStores = SyncUtils.getFileStores(files);
                    ConnectionPointSyncPair cpsp = new ConnectionPointSyncPair(source, dest);
                    SmartSyncDialog dialog = new SmartSyncDialog(SynchronizeFilesAction.this.getShell(), cpsp, fileStores);
                    dialog.open();
                    dialog.setHandler(new SyncEventHandlerAdapter(){

                        public void syncDone(VirtualFileSyncPair item) {
                        }
                    });
                }
                catch (CoreException coreException) {
                    MessageBox error = new MessageBox(CoreUIUtils.getActiveShell(), 33);
                    error.setMessage("Unable to open synchronization dialog.");
                    error.open();
                }
            }
        });
    }

    protected String getMessageTitle() {
        return MESSAGE_TITLE;
    }
}

