/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.actions;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.ResourceSynchronizationUtils;
import com.aptana.ide.syncing.core.SiteConnectionUtils;
import com.aptana.ide.syncing.ui.actions.Messages;
import com.aptana.ide.syncing.ui.editors.EditorUtils;
import com.aptana.ide.syncing.ui.internal.ChooseSiteConnectionDialog;
import com.aptana.ide.syncing.ui.internal.SyncUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class BaseSyncAction
implements IObjectActionDelegate {
    private IWorkbenchPart fActivePart;
    private List<IAdaptable> fSelectedElements = new ArrayList<IAdaptable>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fActivePart = targetPart;
    }

    public void run(IAction action) {
        if (this.fSelectedElements.size() == 0) {
            return;
        }
        ISiteConnection[] sites = this.getSiteConnections();
        if (sites.length == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getMessageTitle(), (String)Messages.BaseSyncAction_Warning_NoCommonParent);
            return;
        }
        ISiteConnection site = null;
        if (sites.length == 1) {
            site = sites[0];
        } else {
            IAdaptable firstElement = this.fSelectedElements.get(0);
            if (firstElement instanceof IResource) {
                IProject project;
                IContainer container = null;
                boolean remember = false;
                if (firstElement instanceof IContainer && (remember = ResourceSynchronizationUtils.isRememberDecision((IContainer)((IContainer)firstElement)))) {
                    container = (IContainer)firstElement;
                }
                if (!remember && (remember = ResourceSynchronizationUtils.isRememberDecision((IContainer)(project = ((IResource)firstElement).getProject())))) {
                    container = project;
                }
                site = BaseSyncAction.getLastSyncConnection(container);
            }
            if (site == null) {
                ChooseSiteConnectionDialog dialog = new ChooseSiteConnectionDialog(this.getShell(), sites);
                dialog.setShowRememberMyDecision(true);
                dialog.open();
                site = dialog.getSelectedSite();
                if (site != null) {
                    this.setRememberMyDecision(site, dialog.isRememberMyDecision());
                }
            }
        }
        if (site != null) {
            try {
                this.performAction(this.fSelectedElements.toArray(new IAdaptable[this.fSelectedElements.size()]), site);
            }
            catch (CoreException coreException) {}
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        this.setSelection(selection);
        action.setEnabled(this.fSelectedElements.size() > 0);
    }

    public void setSelection(ISelection selection) {
        Object[] elements;
        this.fSelectedElements.clear();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        Object[] objectArray = elements = ((IStructuredSelection)selection).toArray();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteConnection[] sites;
            Object element = objectArray[n2];
            if (element instanceof IAdaptable && (sites = SiteConnectionUtils.findSitesForSource((IAdaptable)((IAdaptable)element))).length > 0) {
                this.fSelectedElements.add((IAdaptable)element);
            }
            ++n2;
        }
    }

    protected abstract void performAction(IAdaptable[] var1, ISiteConnection var2) throws CoreException;

    protected String getMessageTitle() {
        return StringUtils.ellipsify((String)Messages.BaseSyncAction_MessageTitle);
    }

    protected Shell getShell() {
        return this.fActivePart.getSite().getShell();
    }

    protected ISiteConnection[] getSiteConnections() {
        ArrayList sitesList = new ArrayList();
        for (IAdaptable element : this.fSelectedElements) {
            ISiteConnection[] sites = SiteConnectionUtils.findSitesForSource((IAdaptable)element);
            HashSet<ISiteConnection> sitesSet = new HashSet<ISiteConnection>();
            ISiteConnection[] iSiteConnectionArray = sites;
            int n = sites.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteConnection site = iSiteConnectionArray[n2];
                sitesSet.add(site);
                ++n2;
            }
            sitesList.add(sitesSet);
        }
        Set<ISiteConnection> sitesSets = SyncUtils.getIntersection(sitesList.toArray(new Set[sitesList.size()]));
        return sitesSets.toArray(new ISiteConnection[sitesSets.size()]);
    }

    protected void openConnectionEditor() {
        ISiteConnection[] sites = this.getSiteConnections();
        if (sites.length > 0) {
            EditorUtils.openConnectionEditor(sites[0]);
        }
    }

    private static ISiteConnection getLastSyncConnection(IContainer container) {
        ISiteConnection[] sites;
        if (container == null) {
            return null;
        }
        String lastConnection = ResourceSynchronizationUtils.getLastSyncConnection((IContainer)container);
        if (lastConnection == null) {
            return null;
        }
        ISiteConnection[] iSiteConnectionArray = sites = SiteConnectionUtils.findSitesForSource((IAdaptable)container, (boolean)true);
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteConnection site = iSiteConnectionArray[n2];
            String target = site.getDestination().getName();
            if (target.equals(lastConnection)) {
                return site;
            }
            ++n2;
        }
        return null;
    }

    private void setRememberMyDecision(ISiteConnection site, boolean rememberMyDecision) {
        IConnectionPoint source = site.getSource();
        IContainer container = (IContainer)source.getAdapter(IContainer.class);
        if (container == null) {
            return;
        }
        if (rememberMyDecision) {
            ResourceSynchronizationUtils.setRememberDecision((IContainer)container, (boolean)rememberMyDecision);
        }
        ResourceSynchronizationUtils.setLastSyncConnection((IContainer)container, (String)site.getDestination().getName());
    }
}

