/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.snippets;

import com.aptana.ide.snippets.Snippet;
import com.aptana.ide.snippets.SnippetsManager;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class ResourceDeltaVisitor
implements IResourceDeltaVisitor {
    private static final Pattern snippet = Pattern.compile("^/.+/snippets/.+$");

    public boolean visit(IResourceDelta delta) throws CoreException {
        String path = delta.getFullPath().toString();
        Matcher m = snippet.matcher(path);
        boolean result = true;
        if (m.matches()) {
            SnippetsManager snippets = SnippetsManager.getInstance();
            File file = delta.getResource().getLocation().toFile();
            switch (delta.getKind()) {
                case 1: {
                    Snippet snippet = Snippet.fromFile(file);
                    if (snippet == null) break;
                    snippets.addSnippet(snippet);
                    break;
                }
                case 2: {
                    Snippet snippet = snippets.getSnippetByFile(file);
                    if (snippet == null) break;
                    snippets.removeSnippet(snippet);
                    break;
                }
                case 4: {
                    Snippet snippet;
                    int flags = delta.getFlags();
                    if ((flags & 0x40000) == 262144) {
                        snippet = snippets.getSnippetByFile(file);
                        if (snippet != null) {
                            snippets.removeSnippet(snippet);
                        }
                        snippets.addSnippet(Snippet.fromFile(file));
                    }
                    if ((flags & 0x100) != 256) break;
                    snippet = snippets.getSnippetByFile(file);
                    if (snippet != null) {
                        snippets.removeSnippet(snippet);
                    }
                    snippets.addSnippet(Snippet.fromFile(file));
                    break;
                }
            }
        }
        return result;
    }
}

