/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core.impl.servers;

import com.aptana.ide.server.core.IModule;
import com.aptana.ide.server.core.IModuleFile;
import com.aptana.ide.server.core.IModuleFolder;
import com.aptana.ide.server.core.IModuleResource;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerWithWritablePathes;
import com.aptana.ide.server.core.model.IPublishOperationDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CopyOperationDelegate
implements IPublishOperationDelegate {
    public IStatus canPublish(IServer server, int kind, IModule[] module) {
        return Status.OK_STATUS;
    }

    public IStatus performPublish(IServer server, int kind, IModule[] modules, IProgressMonitor monitor) {
        try {
            IServerWithWritablePathes srv = (IServerWithWritablePathes)server;
            switch (kind) {
                case 4: {
                    int a = 0;
                    while (a < modules.length) {
                        IPath rootPath = srv.getRootPath(modules[a]);
                        IModuleResource[] rootResources = modules[a].getRootResources();
                        int b = 0;
                        while (b < rootResources.length) {
                            IModuleResource r = rootResources[b];
                            IPath append = rootPath.append(r.getPath());
                            IStatus clean = srv.clean(append);
                            if (monitor.isCanceled()) {
                                return Status.OK_STATUS;
                            }
                            if (clean.getSeverity() == 4) {
                                return clean;
                            }
                            ++b;
                        }
                        ++a;
                    }
                    break;
                }
                case 2: {
                    return this.doPublish(srv, modules, monitor, true);
                }
                case 1: {
                    return this.doPublish(srv, modules, monitor, false);
                }
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            Status sts = new Status(4, "com.aptana.ide.server", 4, "core exeption", (Throwable)e);
            return sts;
        }
    }

    private IStatus doPublish(IServerWithWritablePathes server, IModule[] modules, IProgressMonitor monitor, boolean c) throws CoreException {
        int a = 0;
        while (a < modules.length) {
            IPath rootPath = server.getRootPath(modules[a]);
            IModuleResource[] rootResources = modules[a].getRootResources();
            int b = 0;
            while (b < rootResources.length) {
                IModuleResource r = rootResources[b];
                IStatus clean = this.publish(server, rootPath, r, c);
                if (monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                if (clean.getSeverity() == 4) {
                    return clean;
                }
                ++b;
            }
            ++a;
        }
        return Status.OK_STATUS;
    }

    private IStatus publish(IServerWithWritablePathes server, IPath rootPath, IModuleResource r, boolean c) throws CoreException {
        if (r.isFolder()) {
            IModuleFolder fld = (IModuleFolder)r;
            return this.publishFolder(server, rootPath, c, fld);
        }
        IPath append = rootPath.append(r.getPath());
        boolean shouldPublish = true;
        IModuleFile file = (IModuleFile)r;
        if (c) {
            long timeStamp = server.getTimeStamp(append);
            boolean bl = shouldPublish = file.getModificationStamp() > timeStamp;
        }
        if (shouldPublish) {
            IStatus writeResource = server.writeResource(append, file.getContents());
            return writeResource;
        }
        return Status.OK_STATUS;
    }

    protected IStatus publishFolder(IServerWithWritablePathes server, IPath rootPath, boolean c, IModuleFolder fld) throws CoreException {
        IModuleResource[] members = fld.getMembers();
        int a = 0;
        while (a < members.length) {
            IStatus ok = this.publish(server, rootPath, members[a], c);
            if (ok.getSeverity() == 4) {
                return ok;
            }
            ++a;
        }
        return Status.OK_STATUS;
    }
}

