/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.update.preferences;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.SWTUtils;
import com.aptana.ide.server.jetty.JettyPlugin;
import com.aptana.ide.update.Activator;
import com.aptana.ide.update.manager.IPluginManager;
import com.aptana.ide.update.preferences.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AutomaticUpdatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String P_UPDATE_POLICY_URL = "updatePolicyURL";
    private static final String DELIMETER = ",";
    private static final String ADDED_UPDATE_SITES = "ADDED_UPDATE_SITES";
    private static final String POLICY_XML_RC = "http://beta.aptana.com/beta/policy.xml";
    private static final String POLICY_XML_NIGHTLY = "http://nightly.aptana.com/nightly/policy.xml";
    private static final String POLICY_XML_DEV_START = "http://developer.aptana.com/";
    private static final String POLICY_XML_DEV_END = "/policy.xml";
    private Button currentRadio;
    private Button nextRadio;
    private Button nightlyRadio;
    private Button developerRadio;
    private Text branchText;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        Link link = new Link(container, 0);
        link.setText(Messages.AutomaticUpdatesPreferencePage_UseP2UpdatePreferences);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)AutomaticUpdatesPreferencePage.this.getShell(), (String)AutomaticUpdatesPreferencePage.getPluginManager().getUpdatePreferencePageId(), null, null);
            }
        });
        AutomaticUpdatesPreferencePage.createSpacer(container, 1);
        Group updateTypeGroup = new Group(container, 0);
        updateTypeGroup.setText(Messages.AutomaticUpdatesPreferencePage_WhatTypesOfUpdates);
        layout = new GridLayout();
        layout.numColumns = 3;
        updateTypeGroup.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        updateTypeGroup.setLayoutData((Object)gd);
        Label basicLabel = new Label((Composite)updateTypeGroup, 0);
        basicLabel.setText(Messages.AutomaticUpdatesPreferencePage_AptanaWillDownloadOnNextRestart);
        basicLabel.setFont(SWTUtils.getDefaultSmallFont());
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.verticalIndent = 10;
        basicLabel.setLayoutData((Object)gd);
        boolean isEnabled = true;
        basicLabel.setEnabled(isEnabled);
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        };
        this.currentRadio = new Button((Composite)updateTypeGroup, 16);
        this.currentRadio.setText(Messages.AutomaticUpdatesPreferencePage_StableReleasesOnly);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.currentRadio.setLayoutData((Object)gd);
        this.currentRadio.addSelectionListener((SelectionListener)adapter);
        this.currentRadio.setEnabled(isEnabled);
        this.nextRadio = new Button((Composite)updateTypeGroup, 16);
        this.nextRadio.setText(Messages.AutomaticUpdatesPreferencePage_NextCandidateBuilds);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.nextRadio.setLayoutData((Object)gd);
        this.nextRadio.addSelectionListener((SelectionListener)adapter);
        this.nextRadio.setEnabled(isEnabled);
        this.nightlyRadio = new Button((Composite)updateTypeGroup, 16);
        this.nightlyRadio.setText(Messages.AutomaticUpdatesPreferencePage_NightlyBuilds);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.nightlyRadio.setLayoutData((Object)gd);
        this.nightlyRadio.addSelectionListener((SelectionListener)adapter);
        this.nightlyRadio.setEnabled(isEnabled);
        Label developerLabel = new Label((Composite)updateTypeGroup, 0);
        developerLabel.setText(Messages.AutomaticUpdatesPreferencePage_ForAdvancedUsers);
        developerLabel.setFont(SWTUtils.getDefaultSmallFont());
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.verticalIndent = 10;
        developerLabel.setLayoutData((Object)gd);
        developerLabel.setEnabled(isEnabled);
        this.developerRadio = new Button((Composite)updateTypeGroup, 16);
        this.developerRadio.setText(Messages.AutomaticUpdatesPreferencePage_SpecifyBranchName);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.developerRadio.setLayoutData((Object)gd);
        this.developerRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.testBranchName();
            }
        });
        this.developerRadio.setEnabled(isEnabled);
        this.branchText = new Text((Composite)updateTypeGroup, 2048);
        gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        this.branchText.setLayoutData((Object)gd);
        this.branchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AutomaticUpdatesPreferencePage.this.testBranchName();
            }
        });
        this.branchText.setEnabled(isEnabled);
        this.initialize();
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void testBranchName() {
        if (this.developerRadio.getSelection() && this.branchText.getText().equals("")) {
            this.setValid(false);
            this.setErrorMessage(Messages.AutomaticUpdatesPreferencePage_MustSpecifyBranchName);
        } else {
            this.setValid(true);
            this.setErrorMessage(null);
        }
    }

    private static void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    private void initialize() {
        String updateUrl = Platform.getPreferencesService().getString("com.aptana.ide.update", P_UPDATE_POLICY_URL, "", null);
        if (updateUrl.equals("")) {
            this.currentRadio.setSelection(true);
        } else if (updateUrl.equals(POLICY_XML_RC)) {
            this.nextRadio.setSelection(true);
        } else if (updateUrl.equals(POLICY_XML_NIGHTLY)) {
            this.nightlyRadio.setSelection(true);
        } else if (updateUrl.startsWith(POLICY_XML_DEV_START)) {
            this.developerRadio.setSelection(true);
            int length = POLICY_XML_DEV_START.length();
            int lastSlash = updateUrl.indexOf(47, length);
            String branchName = updateUrl.substring(length, lastSlash);
            this.branchText.setText(branchName);
        }
        this.pageChanged();
    }

    private void pageChanged() {
        this.branchText.setEnabled(this.developerRadio.getSelection());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.pageChanged();
    }

    public boolean performOk() {
        String updateUrl;
        String oldUpdateUrl = updateUrl = Platform.getPreferencesService().getString("com.aptana.ide.update", P_UPDATE_POLICY_URL, "", null);
        if (this.currentRadio.getSelection()) {
            updateUrl = "";
        } else if (this.nextRadio.getSelection()) {
            updateUrl = POLICY_XML_RC;
        } else if (this.nightlyRadio.getSelection()) {
            updateUrl = POLICY_XML_NIGHTLY;
        } else if (this.developerRadio.getSelection()) {
            updateUrl = POLICY_XML_DEV_START + this.branchText.getText() + POLICY_XML_DEV_END;
        }
        IEclipsePreferences prefs = new InstanceScope().getNode("com.aptana.ide.update");
        prefs.put(P_UPDATE_POLICY_URL, updateUrl);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        AutomaticUpdatesPreferencePage.savePortalUpdateType();
        this.doP2Scheduling(oldUpdateUrl, updateUrl);
        return true;
    }

    private void doP2Scheduling(final String oldUpdateURL, final String updateURL) {
        Job job = new Job(Messages.AutomaticUpdatesPreferencePage_Changing_update_stream_job_title){

            protected IStatus run(IProgressMonitor monitor) {
                this.addPolicyFileUpdateSites();
                AutomaticUpdatesPreferencePage.getPluginManager().checkForUpdates(false);
                return Status.OK_STATUS;
            }

            private void addPolicyFileUpdateSites() {
                if (oldUpdateURL != null && updateURL != null && oldUpdateURL.equals(updateURL)) {
                    return;
                }
                this.wipeOutLastAddedUpdateSites();
                if (updateURL == null || updateURL.trim().length() == 0) {
                    return;
                }
                Document doc = this.getPolicyXMLDocument(updateURL);
                ArrayList<String> addedSites = new ArrayList<String>();
                if (doc != null) {
                    NodeList urlMaps = doc.getElementsByTagName("url-map");
                    int i = 0;
                    while (i < urlMaps.getLength()) {
                        Element urlMap = (Element)urlMaps.item(i);
                        String updateSite = urlMap.getAttribute("url");
                        try {
                            URL updateSiteURL = new URL(updateSite);
                            if (AutomaticUpdatesPreferencePage.getPluginManager().addUpdateSite(updateSiteURL)) {
                                addedSites.add(updateSite);
                            }
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)Activator.getDefault(), (String)e.getMessage(), (Throwable)e);
                        }
                        ++i;
                    }
                }
                this.storeAddedUpdateSites(addedSites);
            }

            private void wipeOutLastAddedUpdateSites() {
                String addedSitesRaw = Platform.getPreferencesService().getString("com.aptana.ide.update", AutomaticUpdatesPreferencePage.ADDED_UPDATE_SITES, "", null);
                String[] lastAdded = addedSitesRaw.split(AutomaticUpdatesPreferencePage.DELIMETER);
                try {
                    String[] stringArray = lastAdded;
                    int n = lastAdded.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String oldAddedURL = stringArray[n2];
                        if (oldAddedURL != null && oldAddedURL.trim().length() != 0) {
                            URL location = new URL(oldAddedURL);
                            AutomaticUpdatesPreferencePage.getPluginManager().removeUpdateSite(location);
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)Activator.getDefault(), (String)e.getMessage(), (Throwable)e);
                }
            }

            private void storeAddedUpdateSites(List<String> addedSites) {
                StringBuilder builder = new StringBuilder();
                for (String addedSite : addedSites) {
                    builder.append(AutomaticUpdatesPreferencePage.DELIMETER);
                    builder.append(addedSite);
                }
                if (builder.length() > 0) {
                    builder.deleteCharAt(0);
                }
                new InstanceScope().getNode("com.aptana.ide.update").put(AutomaticUpdatesPreferencePage.ADDED_UPDATE_SITES, builder.toString());
            }

            private Document getPolicyXMLDocument(String updateURL2) {
                Document doc;
                block14: {
                    InputStream stream = null;
                    doc = null;
                    try {
                        try {
                            stream = new URL(updateURL2).openStream();
                            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)Activator.getDefault(), (String)e.getMessage(), (Throwable)e);
                            try {
                                if (stream != null) {
                                    stream.close();
                                }
                                break block14;
                            }
                            catch (IOException iOException) {}
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                return doc;
            }
        };
        job.setSystem(true);
        job.setPriority(30);
        job.schedule();
    }

    public static void savePortalUpdateType() {
        String portalUpdateType = "production";
        String updateUrl = Platform.getPreferencesService().getString("com.aptana.ide.update", P_UPDATE_POLICY_URL, "", null);
        if (updateUrl.equals(POLICY_XML_RC)) {
            portalUpdateType = "next";
        } else if (updateUrl.equals(POLICY_XML_NIGHTLY)) {
            portalUpdateType = "nightly";
        } else if (updateUrl.startsWith(POLICY_XML_DEV_START)) {
            int length = POLICY_XML_DEV_START.length();
            int lastSlash = updateUrl.indexOf(47, length);
            portalUpdateType = updateUrl.substring(length, lastSlash);
        }
        JettyPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.server.jetty.preferences.PORTAL_UPDATE_TYPE", portalUpdateType);
    }

    private static IPluginManager getPluginManager() {
        return Activator.getDefault().getPluginManager();
    }
}

