/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.documentation.help;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.documentation.DocumentationPlugin;
import com.aptana.ide.documentation.help.Messages;
import java.net.URL;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HelpDialog
extends Window {
    public static final String INTERNAL_PREFIX = "/com.aptana.ide.documentation/html/gettingstarted/";
    public static final String EXTERNAL_PREFIX = "http://www.aptana.com/docs/index.php/";
    public static final String TOPIC_SERVLET = "/help/nftopic";
    private static HelpDialog dialog;
    private Composite displayArea;
    private Browser browser;

    private HelpDialog() {
        super(null);
        this.setShellStyle(HelpDialog.getDefaultOrientation() | 0x10 | 0x860 | 0x400 | 0x80);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.HelpDialog_Title);
        newShell.setImage(DocumentationPlugin.getImage("icons/help.png"));
    }

    protected Control createContents(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 10;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 10;
        layout.verticalSpacing = 0;
        this.displayArea.setLayout((Layout)layout);
        GridData daData = new GridData(4, 4, true, true);
        daData.widthHint = Math.min(1100, parent.getMonitor().getClientArea().width - 200);
        daData.heightHint = Math.min(768, parent.getMonitor().getClientArea().height - 200);
        this.displayArea.setLayoutData((Object)daData);
        this.browser = new Browser(this.displayArea, 2048);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        return this.displayArea;
    }

    public static HelpDialog getHelp() {
        if (dialog == null || dialog.isDisposed()) {
            dialog = new HelpDialog();
        }
        return dialog;
    }

    public boolean isDisposed() {
        return this.displayArea == null || this.displayArea.isDisposed();
    }

    private URL getHelpSystemURL(String topic) {
        return BaseHelpSystem.resolve((String)(INTERNAL_PREFIX + topic + ".html"), (String)TOPIC_SERVLET);
    }

    private String getWikiURL(String topic) {
        return EXTERNAL_PREFIX + topic + "?studio=true";
    }

    public void showTopic(String topic) {
        this.showHelp(!AptanaCorePlugin.getDefault().getPluginPreferences().getBoolean("com.aptana.ide.core.SHOW_LIVE_HELP"), topic);
    }

    public void showHelp(boolean internal, String topic) {
        if (this.isDisposed()) {
            this.open();
        }
        String url = null;
        if (!internal) {
            url = this.getWikiURL(topic);
        } else {
            String external = this.getHelpSystemURL(topic).toExternalForm();
            if (external == null) {
                external = this.getWikiURL(topic);
            }
            url = external;
        }
        if (url != null) {
            super.getShell().setMinimized(false);
            super.getShell().forceActive();
            this.browser.setUrl(url);
        }
    }
}

